/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.multilib.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.skinsrestorer.shadow.multilib.DataStorageImpl;
import net.skinsrestorer.shadow.multilib.MultiLib;
import net.skinsrestorer.shadow.multilib.util.StringAddition;
import org.bukkit.plugin.Plugin;

public class DataStorageCache {
    private static final String CHANNEL = "multilib:datastoragecacheupdate";
    private final String keyPrefix;
    private final DataStorageImpl dataStorage;
    private final Map<String, String> cache = new HashMap<String, String>();

    public DataStorageCache(Plugin plugin, String keyPrefix, DataStorageImpl dataStorage) {
        this.keyPrefix = keyPrefix;
        this.dataStorage = dataStorage;
        MultiLib.onString(plugin, CHANNEL, key -> {
            if (key.startsWith(keyPrefix)) {
                dataStorage.get((String)key).thenAccept(value -> {
                    if (value == null) {
                        this.cache.remove(key);
                    } else {
                        this.cache.put((String)key, (String)value);
                    }
                });
            }
        });
        ((CompletableFuture)dataStorage.list(keyPrefix).thenAccept(this.cache::putAll)).join();
    }

    private void checkKey(String key) throws IllegalArgumentException {
        if (!key.startsWith(this.keyPrefix)) {
            throw new IllegalArgumentException(key + " does not have the prefix " + this.keyPrefix);
        }
    }

    public String get(String key) {
        this.checkKey(key);
        return this.cache.get(key);
    }

    public String get(String key, String def) {
        String value = this.get(key);
        return value != null ? value : def;
    }

    public long getLong(String key) throws NumberFormatException {
        return Long.parseLong(this.get(key));
    }

    public long getLong(String key, long def) {
        try {
            return this.getLong(key);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public int getInt(String key) throws NumberFormatException {
        return Integer.parseInt(this.get(key));
    }

    public int getInt(String key, int def) {
        try {
            return this.getInt(key);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public double getDouble(String key) throws NumberFormatException, NullPointerException {
        return Double.parseDouble(this.get(key));
    }

    public double getDouble(String key, double def) {
        try {
            return this.getDouble(key);
        }
        catch (NullPointerException | NumberFormatException e) {
            return def;
        }
    }

    public Map<String, String> list(String keyPrefix) {
        this.checkKey(keyPrefix);
        HashMap<String, String> list = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.cache.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().startsWith(keyPrefix)) continue;
            list.put(entry.getKey(), entry.getValue());
        }
        return list;
    }

    public void set(String key, String value) {
        this.cache.put(key, value);
        ((CompletableFuture)this.dataStorage.set(key, value).thenAccept(newValue -> this.cache.put(key, (String)newValue))).thenRun(() -> MultiLib.notify(CHANNEL, key));
    }

    public void set(String key, long value) {
        this.set(key, Long.toString(value));
    }

    public void set(String key, int value) {
        this.set(key, Integer.toString(value));
    }

    public void set(String key, double value) {
        this.set(key, Double.toString(value));
    }

    public void add(String key, String increment) {
        this.cache.put(key, StringAddition.add(key, increment));
        ((CompletableFuture)this.dataStorage.add(key, increment).thenAccept(newValue -> this.cache.put(key, (String)newValue))).thenRun(() -> MultiLib.notify(CHANNEL, key));
    }

    public void add(String key, long increment) {
        this.add(key, Long.toString(increment));
    }

    public void add(String key, int increment) {
        this.add(key, Integer.toString(increment));
    }

    public void add(String key, double increment) {
        this.add(key, Double.toString(increment));
    }
}

