/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.skinsrestorer.api.connections.MineSkinAPI;
import net.skinsrestorer.api.connections.model.MineSkinResponse;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.exception.MineSkinException;
import net.skinsrestorer.api.property.InputDataResult;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinType;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.api.storage.SkinStorage;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.api.SharedSkinApplier;
import net.skinsrestorer.shared.commands.library.CommandManager;
import net.skinsrestorer.shared.commands.library.annotations.CommandConditions;
import net.skinsrestorer.shared.commands.library.annotations.CommandNames;
import net.skinsrestorer.shared.commands.library.annotations.CommandPermission;
import net.skinsrestorer.shared.commands.library.annotations.Description;
import net.skinsrestorer.shared.commands.library.annotations.Private;
import net.skinsrestorer.shared.commands.library.annotations.RootCommand;
import net.skinsrestorer.shared.commands.library.annotations.Subcommand;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.storage.CooldownStorage;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.utils.ComponentHelper;
import net.skinsrestorer.shared.utils.SRConstants;
import net.skinsrestorer.shared.utils.ValidationUtil;

@CommandNames(value={"skin"})
@Description(value=Message.HELP_SKIN)
@CommandPermission(value=PermissionRegistry.SKIN)
@CommandConditions(value={"allowed-server"})
public final class SkinCommand {
    private final SRPlatformAdapter<?> adapter;
    private final SRPlugin plugin;
    private final SettingsManager settings;
    private final CooldownStorage cooldownStorage;
    private final SkinStorage skinStorage;
    private final PlayerStorage playerStorage;
    private final SkinsRestorerLocale locale;
    private final SRLogger logger;
    private final SharedSkinApplier<Object> skinApplier;
    private final MineSkinAPI mineSkinAPI;
    private final CommandManager<SRCommandSender> commandManager;

    @RootCommand
    private void onDefault(SRCommandSender sender) {
        if (this.settings.getProperty(CommandConfig.CUSTOM_HELP_ENABLED).booleanValue()) {
            for (String line : this.settings.getProperty(CommandConfig.CUSTOM_HELP_MESSAGE)) {
                sender.sendMessage(ComponentHelper.parseMiniMessageToJsonString(line));
            }
            return;
        }
        this.commandManager.getHelpMessage("skin", sender).forEach(sender::sendMessage);
    }

    @RootCommand
    @CommandPermission(value=PermissionRegistry.SKIN_SET)
    @Description(value=Message.HELP_SKIN_SET)
    @CommandConditions(value={"cooldown"})
    private void onSkinSetShort(SRPlayer player, String skinName) {
        this.onSkinSetOther(player, skinName, player, null);
    }

    @Subcommand(value={"clear"})
    @CommandPermission(value=PermissionRegistry.SKIN_CLEAR)
    @Description(value=Message.HELP_SKIN_CLEAR)
    @CommandConditions(value={"cooldown"})
    private void onSkinClear(SRPlayer player) {
        this.onSkinClearOther(player, player);
    }

    @Subcommand(value={"clear"})
    @CommandPermission(value=PermissionRegistry.SKIN_CLEAR_OTHER)
    @Description(value=Message.HELP_SKIN_CLEAR_OTHER)
    @CommandConditions(value={"cooldown"})
    private void onSkinClearOther(SRCommandSender sender, SRPlayer target) {
        this.playerStorage.removeSkinIdOfPlayer(target.getUniqueId());
        try {
            Optional<SkinProperty> property = this.playerStorage.getSkinForPlayer(target.getUniqueId(), target.getName());
            this.skinApplier.applySkin(target.getAs(Object.class), property.orElse(SRConstants.EMPTY_SKIN));
            if (this.senderEqual(sender, target)) {
                sender.sendMessage(Message.SUCCESS_SKIN_CLEAR, new TagResolver[0]);
            } else {
                sender.sendMessage(Message.SUCCESS_SKIN_CLEAR_OTHER, Placeholder.unparsed("name", target.getName()));
            }
        }
        catch (DataRequestException e) {
            e.printStackTrace();
            sender.sendMessage(Message.ERROR_UPDATING_SKIN, new TagResolver[0]);
        }
    }

    @Subcommand(value={"search"})
    @CommandPermission(value=PermissionRegistry.SKIN_SEARCH)
    @Description(value=Message.HELP_SKIN_SEARCH)
    @CommandConditions(value={"cooldown"})
    private void onSkinSearch(SRCommandSender sender, String searchString) {
        sender.sendMessage(Message.SKIN_SEARCH_MESSAGE, Placeholder.unparsed("search", searchString));
    }

    @Subcommand(value={"update"})
    @CommandPermission(value=PermissionRegistry.SKIN_UPDATE)
    @Description(value=Message.HELP_SKIN_UPDATE)
    @CommandConditions(value={"cooldown"})
    private void onSkinUpdate(SRPlayer player) {
        this.onSkinUpdateOther(player, player);
    }

    @Subcommand(value={"update"})
    @CommandPermission(value=PermissionRegistry.SKIN_UPDATE_OTHER)
    @Description(value=Message.HELP_SKIN_UPDATE_OTHER)
    @CommandConditions(value={"cooldown"})
    private void onSkinUpdateOther(SRCommandSender sender, SRPlayer target) {
        Optional<SkinIdentifier> setSkin = this.playerStorage.getSkinIdOfPlayer(target.getUniqueId());
        try {
            if (setSkin.isPresent() && setSkin.get().getSkinType() == SkinType.PLAYER && !this.skinStorage.updatePlayerSkinData(UUID.fromString(setSkin.get().getIdentifier())).isPresent()) {
                sender.sendMessage(Message.ERROR_UPDATING_SKIN, new TagResolver[0]);
                return;
            }
            Optional<SkinProperty> skin = this.playerStorage.getSkinForPlayer(target.getUniqueId(), target.getName());
            sender.sendMessage(Message.SUCCESS_SKIN_CHANGE, new TagResolver[0]);
            this.skinApplier.applySkin(target.getAs(Object.class), skin.orElse(SRConstants.EMPTY_SKIN));
            if (this.senderEqual(sender, target)) {
                sender.sendMessage(Message.SUCCESS_UPDATING_SKIN, new TagResolver[0]);
            } else {
                sender.sendMessage(Message.SUCCESS_UPDATING_SKIN_OTHER, Placeholder.unparsed("name", target.getName()));
            }
            this.setCoolDown(sender, CommandConfig.SKIN_CHANGE_COOLDOWN);
        }
        catch (DataRequestException e) {
            ComponentHelper.sendException(e, sender, this.locale, this.logger);
            this.setCoolDown(sender, CommandConfig.SKIN_ERROR_COOLDOWN);
        }
    }

    @Subcommand(value={"set"})
    @CommandPermission(value=PermissionRegistry.SKIN_SET)
    @Description(value=Message.HELP_SKIN_SET)
    @CommandConditions(value={"cooldown"})
    private void onSkinSet(SRPlayer player, String skinName) {
        this.onSkinSetOther(player, skinName, player);
    }

    @Subcommand(value={"set"})
    @CommandPermission(value=PermissionRegistry.SKIN_SET_OTHER)
    @Description(value=Message.HELP_SKIN_SET_OTHER)
    @CommandConditions(value={"cooldown"})
    private void onSkinSetOther(SRCommandSender sender, String skinName, SRPlayer target) {
        this.onSkinSetOther(sender, skinName, target, null);
    }

    @Subcommand(value={"set"})
    @CommandPermission(value=PermissionRegistry.SKIN_SET_OTHER)
    @Description(value=Message.HELP_SKIN_SET_OTHER)
    @CommandConditions(value={"cooldown"})
    private void onSkinSetOther(SRCommandSender sender, String skinName, SRPlayer target, SkinVariant skinVariant) {
        if (!this.canSetSkin(sender, skinName)) {
            return;
        }
        if (this.isDisabledSkin(skinName) && !sender.hasPermission(PermissionRegistry.BYPASS_DISABLED)) {
            sender.sendMessage(Message.ERROR_SKIN_DISABLED, new TagResolver[0]);
            return;
        }
        if (!this.setSkin(sender, target, skinName, skinVariant)) {
            this.setCoolDown(sender, CommandConfig.SKIN_ERROR_COOLDOWN);
            return;
        }
        if (this.playerEqual(sender, target)) {
            sender.sendMessage(Message.SUCCESS_SKIN_CHANGE, new TagResolver[0]);
        } else {
            sender.sendMessage(Message.SUCCESS_SKIN_CHANGE_OTHER, Placeholder.unparsed("name", target.getName()));
        }
    }

    @Subcommand(value={"url"})
    @CommandPermission(value=PermissionRegistry.SKIN_SET_URL)
    @Description(value=Message.HELP_SKIN_SET_URL)
    @CommandConditions(value={"cooldown"})
    private void onSkinSetUrlShort(SRPlayer player, String url) {
        if (!ValidationUtil.validSkinUrl(url)) {
            player.sendMessage(Message.ERROR_INVALID_URLSKIN, new TagResolver[0]);
            return;
        }
        this.onSkinSetOther(player, url, player, null);
    }

    @Subcommand(value={"url"})
    @CommandPermission(value=PermissionRegistry.SKIN_SET_URL)
    @Description(value=Message.HELP_SKIN_SET_URL)
    @CommandConditions(value={"cooldown"})
    private void onSkinSetUrl(SRPlayer player, String url, SkinVariant skinVariant) {
        if (!ValidationUtil.validSkinUrl(url)) {
            player.sendMessage(Message.ERROR_INVALID_URLSKIN, new TagResolver[0]);
            return;
        }
        this.onSkinSetOther(player, url, player, skinVariant);
    }

    @Subcommand(value={"menu", "gui"})
    @CommandPermission(value=PermissionRegistry.SKINS)
    @Private
    private void onGUIShortcut(SRPlayer player) {
        this.commandManager.executeCommand(player, "skins");
    }

    private boolean setSkin(SRCommandSender sender, SRPlayer target, String skinInput, SkinVariant skinVariant) {
        Optional<SkinIdentifier> oldSkinId = this.playerStorage.getSkinIdOfPlayer(target.getUniqueId());
        if (ValidationUtil.validSkinUrl(skinInput)) {
            if (!this.allowedSkinUrl(skinInput)) {
                sender.sendMessage(Message.ERROR_SKINURL_DISALLOWED, new TagResolver[0]);
                return false;
            }
            try {
                sender.sendMessage(Message.MS_UPLOADING_SKIN, new TagResolver[0]);
                MineSkinResponse response = this.mineSkinAPI.genSkin(skinInput, skinVariant);
                this.skinStorage.setURLSkinByResponse(skinInput, response);
                this.playerStorage.setSkinIdOfPlayer(target.getUniqueId(), SkinIdentifier.ofURL(skinInput, response.getGeneratedVariant()));
                this.skinApplier.applySkin(target.getAs(Object.class), response.getProperty());
                this.setCoolDown(sender, CommandConfig.SKIN_CHANGE_COOLDOWN);
                return true;
            }
            catch (DataRequestException e) {
                ComponentHelper.sendException(e, sender, this.locale, this.logger);
            }
            catch (Exception e) {
                this.logger.debug(SRLogLevel.SEVERE, String.format("Could not generate skin url: %s", skinInput), e);
                sender.sendMessage(Message.ERROR_INVALID_URLSKIN, new TagResolver[0]);
            }
        } else {
            try {
                Optional<InputDataResult> optional = this.skinStorage.findOrCreateSkinData(skinInput);
                if (!optional.isPresent()) {
                    sender.sendMessage(Message.NOT_PREMIUM, new TagResolver[0]);
                    return false;
                }
                this.playerStorage.setSkinIdOfPlayer(target.getUniqueId(), optional.get().getIdentifier());
                this.skinApplier.applySkin(target.getAs(Object.class), optional.get().getProperty());
                this.setCoolDown(sender, CommandConfig.SKIN_CHANGE_COOLDOWN);
                return true;
            }
            catch (DataRequestException | MineSkinException e) {
                ComponentHelper.sendException(e, sender, this.locale, this.logger);
            }
        }
        this.playerStorage.setSkinIdOfPlayer(target.getUniqueId(), oldSkinId.orElse(null));
        return false;
    }

    private void setCoolDown(SRCommandSender sender, Property<Integer> time) {
        if (sender instanceof SRPlayer) {
            UUID senderUUID = ((SRPlayer)sender).getUniqueId();
            this.cooldownStorage.setCooldown(senderUUID, this.settings.getProperty(time), TimeUnit.SECONDS);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDisabledSkin(String skinName) {
        if (this.settings.getProperty(CommandConfig.DISABLED_SKINS_ENABLED) == false) return false;
        if (!this.settings.getProperty(CommandConfig.DISABLED_SKINS).stream().anyMatch(skinName::equalsIgnoreCase)) return false;
        return true;
    }

    private boolean allowedSkinUrl(String url) {
        if (!this.settings.getProperty(CommandConfig.RESTRICT_SKIN_URLS_ENABLED).booleanValue()) {
            return true;
        }
        for (String possiblyAllowedUrl : this.settings.getProperty(CommandConfig.RESTRICT_SKIN_URLS_LIST)) {
            if (!url.startsWith(possiblyAllowedUrl)) continue;
            return true;
        }
        return false;
    }

    private boolean canSetSkin(SRCommandSender sender, String skinName) {
        if (this.settings.getProperty(CommandConfig.PER_SKIN_PERMISSIONS).booleanValue() && !sender.hasPermission(PermissionRegistry.forSkin(skinName))) {
            SRPlayer player;
            if (sender.hasPermission(PermissionRegistry.OWN_SKIN) && sender instanceof SRPlayer && skinName.equalsIgnoreCase((player = (SRPlayer)sender).getName())) {
                return true;
            }
            sender.sendMessage(Message.PLAYER_HAS_NO_PERMISSION_SKIN, new TagResolver[0]);
            return false;
        }
        if (ValidationUtil.validSkinUrl(skinName) && !sender.hasPermission(PermissionRegistry.SKIN_SET_URL)) {
            sender.sendMessage(Message.PLAYER_HAS_NO_PERMISSION_URL, new TagResolver[0]);
            return false;
        }
        return true;
    }

    private boolean playerEqual(SRCommandSender sender, SRPlayer player) {
        return sender instanceof SRPlayer && ((SRPlayer)sender).getUniqueId().equals(player.getUniqueId());
    }

    private boolean senderEqual(SRCommandSender sender, SRCommandSender target) {
        boolean senderIsPlayer = sender instanceof SRPlayer;
        boolean targetIsPlayer = target instanceof SRPlayer;
        if (senderIsPlayer && targetIsPlayer) {
            return ((SRPlayer)sender).getUniqueId().equals(((SRPlayer)target).getUniqueId());
        }
        return !senderIsPlayer && !targetIsPlayer;
    }

    @Inject
    public SkinCommand(SRPlatformAdapter<?> adapter, SRPlugin plugin, SettingsManager settings, CooldownStorage cooldownStorage, SkinStorage skinStorage, PlayerStorage playerStorage, SkinsRestorerLocale locale, SRLogger logger, SharedSkinApplier<Object> skinApplier, MineSkinAPI mineSkinAPI, CommandManager<SRCommandSender> commandManager) {
        this.adapter = adapter;
        this.plugin = plugin;
        this.settings = settings;
        this.cooldownStorage = cooldownStorage;
        this.skinStorage = skinStorage;
        this.playerStorage = playerStorage;
        this.locale = locale;
        this.logger = logger;
        this.skinApplier = skinApplier;
        this.mineSkinAPI = mineSkinAPI;
        this.commandManager = commandManager;
    }
}

