/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import net.skinsrestorer.shadow.brigadier.Command;
import net.skinsrestorer.shadow.brigadier.context.CommandContext;
import net.skinsrestorer.shadow.brigadier.exceptions.CommandSyntaxException;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.commands.library.CommandPlatform;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.messages.Message;

public class BrigadierCommand<T extends SRCommandSender>
implements Command<T> {
    private final Method method;
    private final MethodHandle methodHandle;
    private final SRLogger logger;
    private final Object command;
    private final CommandPlatform<T> platform;
    private final SettingsManager settingsManager;

    @Override
    public int run(CommandContext<T> context) throws CommandSyntaxException {
        try {
            Object[] parameters = new Object[1 + this.method.getParameterCount()];
            parameters[0] = this.command;
            int i = 1;
            for (Parameter parameter : this.method.getParameters()) {
                if (i == 1) {
                    parameters[i] = context.getSource();
                    ++i;
                    continue;
                }
                Object value = context.getArgument(parameter.getName(), parameter.getType());
                if (value instanceof String) {
                    value = this.handleStringArgument((SRCommandSender)context.getSource(), (String)value);
                }
                parameters[i] = value;
                ++i;
            }
            this.logger.debug(String.format("Executing command %s with method parameters %s", this.method.getName(), Arrays.toString(parameters)));
            this.platform.runAsync(() -> {
                try {
                    this.methodHandle.invokeWithArguments(parameters);
                }
                catch (Throwable t) {
                    this.logger.severe("Error while executing command " + this.method.getName(), t);
                }
            });
            return 1;
        }
        catch (Exception e) {
            this.logger.severe("Error while executing command " + this.method.getName(), e);
            return 0;
        }
    }

    private String handleStringArgument(T source, String argument) {
        if (this.settingsManager.getProperty(CommandConfig.REMOVE_BRACKETS).booleanValue() && (argument.startsWith("<") && argument.endsWith(">") || argument.startsWith("[") && argument.endsWith("]"))) {
            source.sendMessage(Message.INFO_NO_BRACKETS, new TagResolver[0]);
            return argument.substring(1, argument.length() - 1);
        }
        return argument;
    }

    public BrigadierCommand(Method method, MethodHandle methodHandle, SRLogger logger, Object command, CommandPlatform<T> platform, SettingsManager settingsManager) {
        this.method = method;
        this.methodHandle = methodHandle;
        this.logger = logger;
        this.command = command;
        this.platform = platform;
        this.settingsManager = settingsManager;
    }
}

