/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.brigadier.CommandDispatcher;
import net.skinsrestorer.shadow.brigadier.suggestion.Suggestion;
import net.skinsrestorer.shared.commands.library.CommandManager;
import net.skinsrestorer.shared.commands.library.SRCommandMeta;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;

public class CommandExecutor<T extends SRCommandSender> {
    private final CommandDispatcher<T> dispatcher;
    private final CommandManager<T> manager;
    private final SRCommandMeta<T> meta;
    private final SRLogger logger;

    public void execute(T executor, String input) {
        this.manager.executeCommand(executor, input);
    }

    public CompletableFuture<List<String>> tabComplete(T executor, String input) {
        if (executor instanceof SRPlayer) {
            this.logger.debug(String.format("Tab completing: '%s' for '%s'", input, ((SRPlayer)executor).getName()));
        } else {
            this.logger.debug(String.format("Tab completing: '%s' for console", input));
        }
        return this.dispatcher.getCompletionSuggestions(this.dispatcher.parse(input, executor)).thenApply(suggestions -> suggestions.getList().stream().map(Suggestion::getText).collect(Collectors.toList()));
    }

    public boolean hasPermission(T executor) {
        return this.meta.getPermission().test(executor);
    }

    public CommandExecutor(CommandDispatcher<T> dispatcher, CommandManager<T> manager, SRCommandMeta<T> meta, SRLogger logger) {
        this.dispatcher = dispatcher;
        this.manager = manager;
        this.meta = meta;
        this.logger = logger;
    }

    public CommandManager<T> getManager() {
        return this.manager;
    }
}

