/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.brigadier.CommandDispatcher;
import net.skinsrestorer.shadow.brigadier.StringReader;
import net.skinsrestorer.shadow.brigadier.arguments.ArgumentType;
import net.skinsrestorer.shadow.brigadier.arguments.IntegerArgumentType;
import net.skinsrestorer.shadow.brigadier.builder.ArgumentBuilder;
import net.skinsrestorer.shadow.brigadier.builder.LiteralArgumentBuilder;
import net.skinsrestorer.shadow.brigadier.builder.RequiredArgumentBuilder;
import net.skinsrestorer.shadow.brigadier.context.ParsedCommandNode;
import net.skinsrestorer.shadow.brigadier.exceptions.CommandSyntaxException;
import net.skinsrestorer.shadow.brigadier.tree.CommandNode;
import net.skinsrestorer.shadow.brigadier.tree.LiteralCommandNode;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.commands.library.BrigadierCommand;
import net.skinsrestorer.shared.commands.library.CommandExecutor;
import net.skinsrestorer.shared.commands.library.CommandHelpData;
import net.skinsrestorer.shared.commands.library.CommandInjectHelp;
import net.skinsrestorer.shared.commands.library.CommandPlatform;
import net.skinsrestorer.shared.commands.library.ConditionCommand;
import net.skinsrestorer.shared.commands.library.ConditionRegistration;
import net.skinsrestorer.shared.commands.library.PermissionPredicate;
import net.skinsrestorer.shared.commands.library.RecursiveCustomMerger;
import net.skinsrestorer.shared.commands.library.SRCommandMeta;
import net.skinsrestorer.shared.commands.library.SRRegisterPayload;
import net.skinsrestorer.shared.commands.library.annotations.CommandConditions;
import net.skinsrestorer.shared.commands.library.annotations.CommandNames;
import net.skinsrestorer.shared.commands.library.annotations.CommandPermission;
import net.skinsrestorer.shared.commands.library.annotations.Description;
import net.skinsrestorer.shared.commands.library.annotations.Private;
import net.skinsrestorer.shared.commands.library.annotations.RootCommand;
import net.skinsrestorer.shared.commands.library.annotations.Subcommand;
import net.skinsrestorer.shared.commands.library.types.EnumArgumentType;
import net.skinsrestorer.shared.commands.library.types.SRPlayerArgumentType;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.utils.ComponentHelper;
import net.skinsrestorer.shared.utils.FluentList;

public class CommandManager<T extends SRCommandSender> {
    public static final String ARGUMENT_SEPARATOR = " ";
    private final CommandDispatcher<T> dispatcher = new CommandDispatcher();
    private final Map<String, Predicate<T>> conditions = new HashMap<String, Predicate<T>>();
    private final CommandPlatform<T> platform;
    private final SRLogger logger;
    private final SkinsRestorerLocale locale;
    private final SettingsManager settingsManager;

    public CommandManager(CommandPlatform<T> platform, SRLogger logger, SkinsRestorerLocale locale, SettingsManager settingsManager) {
        this.platform = platform;
        this.logger = logger;
        this.locale = locale;
        this.settingsManager = settingsManager;
        this.registerCondition("player-only", sender -> {
            if (sender instanceof SRPlayer) {
                return true;
            }
            sender.sendMessage(Message.ONLY_ALLOWED_ON_PLAYER, new TagResolver[0]);
            return false;
        });
        this.registerCondition("console-only", sender -> {
            if (sender instanceof SRPlayer) {
                sender.sendMessage(Message.ONLY_ALLOWED_ON_CONSOLE, new TagResolver[0]);
                return false;
            }
            return true;
        });
    }

    @SafeVarargs
    private static <T> Set<T> copyAndInsert(Set<T> set, T ... values) {
        LinkedHashSet<T> copy = new LinkedHashSet<T>(set);
        copy.addAll(Arrays.asList(values));
        return copy;
    }

    private static <T> String mergeToUsageHelp(List<ParsedCommandNode<T>> list) {
        return list.stream().map(ParsedCommandNode::getNode).map(CommandNode::getUsageText).collect(Collectors.joining(ARGUMENT_SEPARATOR));
    }

    public void registerCommand(Object command) {
        LiteralArgumentBuilder rootBuilder = LiteralArgumentBuilder.literal("root");
        this.addClassCommands(rootBuilder, new LinkedHashSet<String>(), command, command.getClass());
        CommandNode rootNode = rootBuilder.build();
        CommandNode baseNode = rootNode.getChildren().iterator().next();
        String commandName = baseNode.getName();
        ArrayList<String> aliases = new ArrayList<String>();
        for (CommandNode node : rootNode.getChildren()) {
            if (node.getName().equals(commandName)) continue;
            aliases.add(node.getName());
        }
        for (CommandNode node : rootNode.getChildren()) {
            this.dispatcher.getRoot().addChild(node);
        }
        String[] usage = this.dispatcher.getAllUsage(rootNode, null, false);
        for (int i = 0; i < usage.length; ++i) {
            usage[i] = "/" + usage[i];
        }
        SRCommandMeta<SRCommandSender> meta = new SRCommandMeta<SRCommandSender>(commandName, aliases.toArray(new String[0]), baseNode::canUse, ((CommandInjectHelp)baseNode.getCommand()).getHelpData());
        CommandExecutor<SRCommandSender> executor = new CommandExecutor<SRCommandSender>(this.dispatcher, this, meta, this.logger);
        SRRegisterPayload<SRCommandSender> payload = new SRRegisterPayload<SRCommandSender>(meta, executor);
        this.platform.registerCommand(payload);
    }

    private void addClassCommands(ArgumentBuilder<T, ?> baseNode, Set<String> conditionTrail, Object command, Class<?> commandClass) {
        CommandNames names = this.getAnnotation(CommandNames.class, commandClass).orElseThrow(() -> new IllegalStateException("Command is missing @CommandNames annotation"));
        String mainName = names.value()[0];
        String[] aliases = names.value().length == 1 ? new String[]{} : Arrays.copyOfRange(names.value(), 1, names.value().length);
        PermissionRegistry classPermission = this.getAnnotation(CommandPermission.class, commandClass).map(CommandPermission::value).orElseThrow(() -> new IllegalStateException(String.format("Command %s is missing @CommandPermission annotation", mainName)));
        LiteralArgumentBuilder<T> classBuilder = LiteralArgumentBuilder.literal(mainName);
        classBuilder.requires(this.requirePermission(classPermission));
        LinkedHashSet<String> classConditionTrail = new LinkedHashSet<String>(conditionTrail);
        this.getAnnotation(CommandConditions.class, commandClass).ifPresent(condition -> classConditionTrail.addAll(Arrays.asList(condition.value())));
        CommandHelpData currentHelpData = this.getHelpData(mainName, commandClass);
        this.addMethodCommands(classBuilder, classPermission, classConditionTrail, command, commandClass, currentHelpData);
        CommandNode classCommandNode = classBuilder.build();
        baseNode.then(classCommandNode);
        for (String alias : aliases) {
            baseNode.then(this.buildRedirect(alias, (LiteralCommandNode<T>)classCommandNode));
        }
    }

    private void addMethodCommands(ArgumentBuilder<T, ?> node, PermissionRegistry rootPermission, Set<String> conditionTrail, Object command, Class<?> commandClass, CommandHelpData currentHelpData) {
        ArrayList<Method> sortedMethods = new ArrayList<Method>();
        for (Method method : commandClass.getDeclaredMethods()) {
            method.setAccessible(true);
            sortedMethods.add(method);
        }
        sortedMethods.sort(Comparator.comparingInt(Method::getParameterCount));
        Collections.reverse(sortedMethods);
        for (Method method : sortedMethods) {
            MethodHandle methodHandle;
            try {
                methodHandle = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Error while registering command " + method.getName(), e);
            }
            Optional<RootCommand> def = this.getAnnotation(RootCommand.class, method);
            Optional<Subcommand> names = this.getAnnotation(Subcommand.class, method);
            if (!def.isPresent() && !names.isPresent()) continue;
            this.validateMethod(method);
            Set<String> commandConditions = this.insertPlayerCondition(this.insertAnnotationConditions(conditionTrail, method), method);
            if (def.isPresent()) {
                this.registerParameters(node, rootPermission, commandConditions, command, method, methodHandle, currentHelpData);
                continue;
            }
            String[] namesArray = names.get().value();
            if (namesArray.length == 0) {
                throw new IllegalStateException("Subcommand annotation must have at least one name");
            }
            String name = namesArray[0];
            String[] aliases = Arrays.copyOfRange(namesArray, 1, namesArray.length);
            LiteralArgumentBuilder<T> childNode = LiteralArgumentBuilder.literal(name);
            PermissionRegistry subPermission = this.getAnnotation(CommandPermission.class, method).map(CommandPermission::value).orElseThrow(() -> new IllegalStateException(String.format("Command %s is missing @CommandPermission annotation", method.getName())));
            childNode.requires(this.requirePermission(subPermission));
            CommandHelpData commandHelpData = this.getHelpData(name, method);
            this.registerParameters(childNode, subPermission, commandConditions, command, method, methodHandle, commandHelpData);
            CommandNode registeredNode = childNode.build();
            RecursiveCustomMerger.mergeThen(node, registeredNode);
            for (String alias : aliases) {
                node.then(this.buildRedirect(alias, (LiteralCommandNode<T>)registeredNode));
            }
        }
    }

    private CommandHelpData getHelpData(String nodeName, AnnotatedElement element) {
        Optional<Private> privateAnnotation = this.getAnnotation(Private.class, element);
        if (privateAnnotation.isPresent()) {
            return new CommandHelpData(true, null);
        }
        Message description = this.getAnnotation(Description.class, element).orElseThrow(() -> new IllegalStateException(String.format("Command %s is missing @Description annotation", nodeName))).value();
        return new CommandHelpData(false, description);
    }

    private void registerParameters(ArgumentBuilder<T, ?> node, PermissionRegistry subPermission, Set<String> conditionTrail, Object command, Method method, MethodHandle methodHandle, CommandHelpData currentHelpData) {
        ArrayList<ArgumentBuilder<T, Object>> nodes = new ArrayList<ArgumentBuilder<T, Object>>();
        nodes.add(node);
        int i = 0;
        for (Parameter parameter : method.getParameters()) {
            ArgumentType<String> argumentType;
            if (i == 0) {
                ++i;
                continue;
            }
            if (parameter.getType() == String.class) {
                argumentType = new ArgumentType<String>(){

                    @Override
                    public String parse(StringReader reader) {
                        int start = reader.getCursor();
                        String string = reader.getString();
                        while (reader.canRead() && reader.peek() != ' ') {
                            reader.skip();
                        }
                        return string.substring(start, reader.getCursor());
                    }

                    @Override
                    public Collection<String> getExamples() {
                        return FluentList.of("example", "example2");
                    }
                };
            } else if (parameter.getType() == Integer.TYPE) {
                argumentType = IntegerArgumentType.integer();
            } else if (Enum.class.isAssignableFrom(parameter.getType())) {
                argumentType = new EnumArgumentType(parameter.getType());
            } else if (parameter.getType().isAssignableFrom(SRPlayer.class)) {
                argumentType = new SRPlayerArgumentType(this.platform);
            } else {
                throw new IllegalStateException("Unsupported parameter type: " + parameter.getType().getName());
            }
            RequiredArgumentBuilder<T, String> argumentBuilder = RequiredArgumentBuilder.argument(parameter.getName(), argumentType);
            argumentBuilder.requires(this.requirePermission(subPermission));
            nodes.add(argumentBuilder);
            ++i;
        }
        ArgumentBuilder lastNode = (ArgumentBuilder)nodes.get(nodes.size() - 1);
        lastNode.executes(new CommandInjectHelp<T>(currentHelpData, new ConditionCommand<T>(this.getConditionRegistrations(conditionTrail), new BrigadierCommand<T>(method, methodHandle, this.logger, command, this.platform, this.settingsManager))));
        if (nodes.size() > 1) {
            for (int i1 = nodes.size() - 1; i1 > 0; --i1) {
                ((ArgumentBuilder)nodes.get(i1 - 1)).then((ArgumentBuilder)nodes.get(i1));
            }
        }
    }

    private void validateMethod(Method method) {
        if (method.getParameterTypes().length < 1 || !SRCommandSender.class.isAssignableFrom(method.getParameterTypes()[0])) {
            throw new IllegalStateException(String.format("Method %s must have at least a single parameter of type SRCommandSender", method.getName()));
        }
    }

    private <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass, AnnotatedElement objectClass) {
        A annotation = objectClass.getAnnotation(annotationClass);
        if (annotation == null) {
            return Optional.empty();
        }
        return Optional.of(annotation);
    }

    private Predicate<T> requirePermission(PermissionRegistry permission) {
        return new PermissionPredicate(permission);
    }

    private Set<String> insertAnnotationConditions(Set<String> conditionTrail, AnnotatedElement element) {
        Set<String> copy = CommandManager.copyAndInsert(conditionTrail, new String[0]);
        this.getAnnotation(CommandConditions.class, element).ifPresent(condition -> copy.addAll(Arrays.asList(condition.value())));
        return copy;
    }

    private Set<String> insertPlayerCondition(Set<String> conditionTrail, Method method) {
        if (method.getParameterTypes()[0] == SRPlayer.class) {
            return CommandManager.copyAndInsert(conditionTrail, "player-only");
        }
        return CommandManager.copyAndInsert(conditionTrail, new String[0]);
    }

    public void registerCondition(String name, Predicate<T> condition) {
        this.conditions.put(name, condition);
    }

    private List<ConditionRegistration<T>> getConditionRegistrations(Set<String> conditionTrail) {
        ArrayList<ConditionRegistration<T>> result = new ArrayList<ConditionRegistration<T>>();
        for (String condition : conditionTrail) {
            if (!this.conditions.containsKey(condition)) {
                throw new IllegalStateException("Unknown condition: " + condition);
            }
            result.add(new ConditionRegistration<T>(condition, this.conditions.get(condition)));
        }
        return result;
    }

    public List<String> getHelpMessage(String command, T source) {
        return this.getHelpMessageNodeStart(this.dispatcher.getRoot().getChild(command), Component.text("/" + command), source).stream().map(ComponentHelper::convertToJsonString).collect(Collectors.toList());
    }

    protected List<Component> getHelpMessageNodeStart(CommandNode<T> node, Component commandPrefix, T source) {
        ArrayList<Component> result = new ArrayList<Component>();
        result.add(ComponentHelper.convertJsonToComponent(this.locale.getMessage((SRForeign)source, Message.COMMAND_HELP_HEADER, Placeholder.unparsed("command", ComponentHelper.convertToPlain(commandPrefix)))));
        this.getAllUsage(node, source, result, commandPrefix, true);
        return result;
    }

    private void getAllUsage(CommandNode<T> node, T source, List<Component> result, Component prefix, boolean first) {
        if (!node.canUse(source)) {
            return;
        }
        if (node.getCommand() != null && ((CommandInjectHelp)node.getCommand()).getHelpData().isPrivateCommand()) {
            return;
        }
        String plainPrefix = ComponentHelper.convertToPlain(prefix);
        boolean prefixEmpty = plainPrefix.isEmpty();
        boolean printEvenIfFirst = node.getChildren().isEmpty();
        if (!(node.getCommand() == null || prefixEmpty || first && !printEvenIfFirst)) {
            int firstRequiredArgument = plainPrefix.indexOf(60);
            String completedPrefix = firstRequiredArgument == -1 ? plainPrefix : plainPrefix.substring(0, firstRequiredArgument);
            CommandInjectHelp command = (CommandInjectHelp)node.getCommand();
            if (command.getHelpData() != null) {
                result.add(ComponentHelper.convertJsonToComponent(this.locale.getMessage((SRForeign)source, Message.COMMAND_HELP_FORMAT, TagResolver.resolver(Placeholder.component("command_click_to_suggest", ComponentHelper.convertJsonToComponent(this.locale.getMessage((SRForeign)source, Message.COMMAND_CLICK_TO_SUGGEST))), Placeholder.parsed("suggestion", completedPrefix), Placeholder.component("command", prefix), Placeholder.component("description", ComponentHelper.convertJsonToComponent(this.locale.getMessage((SRForeign)source, command.getHelpData().getCommandDescription())))))));
            } else {
                result.add(prefix);
            }
        }
        if (node.getRedirect() != null) {
            String redirect = node.getRedirect() == this.dispatcher.getRoot() ? "..." : "-> " + node.getRedirect().getUsageText();
            result.add(Component.text(prefixEmpty ? node.getUsageText() + ARGUMENT_SEPARATOR + redirect : prefix + ARGUMENT_SEPARATOR + redirect));
        } else if (!node.getChildren().isEmpty()) {
            for (CommandNode<T> child : node.getChildren()) {
                Component resultPrefix = prefixEmpty ? prefix : prefix.append(Component.text(ARGUMENT_SEPARATOR));
                this.getAllUsage(child, source, result, resultPrefix.append(Component.text(child.getUsageText())), false);
            }
        }
    }

    public void executeCommand(T executor, String input) {
        this.logger.debug(String.format("Executing command: '%s' for '%s'", input, executor));
        try {
            this.dispatcher.execute(input, executor);
        }
        catch (CommandSyntaxException e) {
            String rawMessage = e.getRawMessage().getString();
            if (rawMessage.equals(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().toString()) || rawMessage.equals(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().toString())) {
                List<ParsedCommandNode<T>> parsedNodes = this.dispatcher.parse(input, executor).getContext().getNodes();
                if (parsedNodes.isEmpty()) {
                    return;
                }
                ParsedCommandNode<T> topNode = parsedNodes.get(parsedNodes.size() - 1);
                for (Component component : this.getHelpMessageNodeStart(topNode.getNode(), Component.text("/" + CommandManager.mergeToUsageHelp(parsedNodes)), executor)) {
                    executor.sendMessage(ComponentHelper.convertToJsonString(component));
                }
            }
            executor.sendMessage(ComponentHelper.parseMiniMessageToJsonString(e.getMessage()));
        }
    }

    private LiteralCommandNode<T> buildRedirect(String alias, LiteralCommandNode<T> destination) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(alias.toLowerCase(Locale.ROOT)).requires(destination.getRequirement())).forward(destination.getRedirect(), destination.getRedirectModifier(), destination.isFork())).executes(destination.getCommand());
        for (CommandNode child : destination.getChildren()) {
            builder.then(child);
        }
        return builder.build();
    }
}

