/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library;

import java.lang.reflect.Field;
import java.util.Map;
import net.skinsrestorer.shadow.brigadier.builder.ArgumentBuilder;
import net.skinsrestorer.shadow.brigadier.tree.ArgumentCommandNode;
import net.skinsrestorer.shadow.brigadier.tree.CommandNode;
import net.skinsrestorer.shadow.brigadier.tree.LiteralCommandNode;
import net.skinsrestorer.shadow.brigadier.tree.RootCommandNode;
import net.skinsrestorer.shared.commands.library.PermissionPredicate;
import net.skinsrestorer.shared.subjects.SRCommandSender;

public class RecursiveCustomMerger {
    public static <T extends SRCommandSender> void mergeThen(ArgumentBuilder<T, ?> builder, CommandNode<T> other) {
        try {
            Field argumentsField = ArgumentBuilder.class.getDeclaredField("arguments");
            argumentsField.setAccessible(true);
            RootCommandNode arguments = (RootCommandNode)argumentsField.get(builder);
            RecursiveCustomMerger.addChild(arguments, other);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T extends SRCommandSender> void addChild(CommandNode<T> base, CommandNode<T> other) throws ReflectiveOperationException {
        if (other instanceof RootCommandNode) {
            throw new UnsupportedOperationException("Cannot add a RootCommandNode as a child to any other CommandNode");
        }
        Field childrenField = CommandNode.class.getDeclaredField("children");
        childrenField.setAccessible(true);
        Map children = (Map)childrenField.get(base);
        CommandNode child = (CommandNode)children.get(other.getName());
        if (child != null) {
            if (other.getCommand() != null) {
                Field commandField = CommandNode.class.getDeclaredField("command");
                commandField.setAccessible(true);
                commandField.set(child, other.getCommand());
            }
            if (other.getRequirement() != null) {
                Field requirementField = CommandNode.class.getDeclaredField("requirement");
                requirementField.setAccessible(true);
                PermissionPredicate permissionPredicate = (PermissionPredicate)requirementField.get(child);
                if (permissionPredicate != null) {
                    permissionPredicate.setPermission(((PermissionPredicate)other.getRequirement()).getPermission());
                }
            }
            for (CommandNode commandNode : other.getChildren()) {
                RecursiveCustomMerger.addChild(child, commandNode);
            }
        } else {
            Field literalsField = CommandNode.class.getDeclaredField("literals");
            literalsField.setAccessible(true);
            Field field = CommandNode.class.getDeclaredField("arguments");
            field.setAccessible(true);
            Map literals = (Map)literalsField.get(base);
            Map arguments = (Map)field.get(base);
            children.put(other.getName(), other);
            if (other instanceof LiteralCommandNode) {
                literals.put(other.getName(), (LiteralCommandNode)other);
            } else if (other instanceof ArgumentCommandNode) {
                arguments.put(other.getName(), (ArgumentCommandNode)other);
            }
        }
    }
}

