/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library.types;

import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.skinsrestorer.shadow.brigadier.LiteralMessage;
import net.skinsrestorer.shadow.brigadier.StringReader;
import net.skinsrestorer.shadow.brigadier.arguments.ArgumentType;
import net.skinsrestorer.shadow.brigadier.context.CommandContext;
import net.skinsrestorer.shadow.brigadier.exceptions.CommandSyntaxException;
import net.skinsrestorer.shadow.brigadier.exceptions.SimpleCommandExceptionType;
import net.skinsrestorer.shadow.brigadier.suggestion.Suggestions;
import net.skinsrestorer.shadow.brigadier.suggestion.SuggestionsBuilder;
import net.skinsrestorer.shared.commands.library.CommandPlatform;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.utils.FluentList;

public class SRPlayerArgumentType
implements ArgumentType<SRPlayer> {
    private final CommandPlatform<?> platform;

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (SRPlayer player : this.platform.getOnlinePlayers()) {
            if (!player.getName().toLowerCase(Locale.ROOT).startsWith(builder.getRemaining().toLowerCase(Locale.ROOT)) || context.getSource() instanceof SRPlayer && !((SRPlayer)context.getSource()).canSee(player)) continue;
            builder.suggest(player.getName());
        }
        return builder.buildFuture();
    }

    @Override
    public Collection<String> getExamples() {
        return FluentList.of("Pistonmaster", "xknat");
    }

    @Override
    public SRPlayer parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        String string = reader.readString();
        Optional<SRPlayer> exactPlayer = this.platform.getOnlinePlayers().stream().filter(p -> p.getName().equals(string)).findFirst();
        if (exactPlayer.isPresent()) {
            return exactPlayer.get();
        }
        Optional<SRPlayer> player = this.platform.getOnlinePlayers().stream().filter(p -> p.getName().equalsIgnoreCase(string)).findFirst();
        if (player.isPresent()) {
            return player.get();
        }
        reader.setCursor(start);
        throw new SimpleCommandExceptionType(new LiteralMessage("Unknown player")).createWithContext(reader);
    }

    public SRPlayerArgumentType(CommandPlatform<?> platform) {
        this.platform = platform;
    }
}

