/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.config;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import net.skinsrestorer.shadow.configme.configurationdata.ConfigurationData;
import net.skinsrestorer.shadow.configme.migration.MigrationService;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.properties.PropertyInitializer;
import net.skinsrestorer.shadow.configme.properties.convertresult.PropertyValue;
import net.skinsrestorer.shadow.configme.resource.PropertyReader;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shared.config.APIConfig;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.config.CommandConfig;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.config.DevConfig;
import net.skinsrestorer.shared.config.GUIConfig;
import net.skinsrestorer.shared.config.LoginConfig;
import net.skinsrestorer.shared.config.MessageConfig;
import net.skinsrestorer.shared.config.ProxyConfig;
import net.skinsrestorer.shared.config.ServerConfig;
import net.skinsrestorer.shared.config.StorageConfig;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;

public class ConfigMigratorService
implements MigrationService {
    private final SRLogger logger;
    private final SRPlugin plugin;

    @Override
    public boolean checkAndMigrate(@NotNull PropertyReader reader, @NotNull ConfigurationData configurationData) {
        return this.performMigrations(reader, configurationData) || !configurationData.areAllValuesValidInResource();
    }

    private boolean performMigrations(@NotNull PropertyReader reader, @NotNull ConfigurationData configurationData) {
        return this.migrateV14Layout(reader, configurationData);
    }

    private boolean migrateV14Layout(PropertyReader reader, ConfigurationData configData) {
        boolean migrated = false;
        Property<Boolean> oldDebugProperty = PropertyInitializer.newProperty("Debug", false);
        migrated |= this.moveProperty(oldDebugProperty, DevConfig.DEBUG, reader, configData);
        Property<Boolean> oldMySQLProperty = PropertyInitializer.newProperty("MySQL.Enabled", false);
        migrated |= this.moveProperty(oldMySQLProperty, DatabaseConfig.MYSQL_ENABLED, reader, configData);
        Property<String> oldMySQLHostProperty = PropertyInitializer.newProperty("MySQL.Host", "localhost");
        migrated |= this.moveProperty(oldMySQLHostProperty, DatabaseConfig.MYSQL_HOST, reader, configData);
        Property<Integer> oldMySQLPortProperty = PropertyInitializer.newProperty("MySQL.Port", 3306);
        migrated |= this.moveProperty(oldMySQLPortProperty, DatabaseConfig.MYSQL_PORT, reader, configData);
        Property<String> oldMySQLDatabaseProperty = PropertyInitializer.newProperty("MySQL.Database", "db");
        migrated |= this.moveProperty(oldMySQLDatabaseProperty, DatabaseConfig.MYSQL_DATABASE, reader, configData);
        Property<String> oldMySQLUsernameProperty = PropertyInitializer.newProperty("MySQL.Username", "root");
        migrated |= this.moveProperty(oldMySQLUsernameProperty, DatabaseConfig.MYSQL_USERNAME, reader, configData);
        Property<String> oldMySQLPasswordProperty = PropertyInitializer.newProperty("MySQL.Password", "password");
        migrated |= this.moveProperty(oldMySQLPasswordProperty, DatabaseConfig.MYSQL_PASSWORD, reader, configData);
        Property<String> oldMySQLConnectionOptionsProperty = PropertyInitializer.newProperty("MySQL.ConnectionOptions", "");
        migrated |= this.moveProperty(oldMySQLConnectionOptionsProperty, DatabaseConfig.MYSQL_CONNECTION_OPTIONS, reader, configData);
        Property<Boolean> oldSkinWithoutPermProperty = PropertyInitializer.newProperty("SkinWithoutPerm", true);
        migrated |= this.moveProperty(oldSkinWithoutPermProperty, CommandConfig.FORCE_DEFAULT_PERMISSIONS, reader, configData);
        Property<Integer> oldSkinChangeCooldownProperty = PropertyInitializer.newProperty("SkinChangeCooldown", 30);
        migrated |= this.moveProperty(oldSkinChangeCooldownProperty, CommandConfig.SKIN_CHANGE_COOLDOWN, reader, configData);
        Property<Integer> oldSkinErrorCooldownProperty = PropertyInitializer.newProperty("SkinErrorCooldown", 5);
        migrated |= this.moveProperty(oldSkinErrorCooldownProperty, CommandConfig.SKIN_ERROR_COOLDOWN, reader, configData);
        Property<Boolean> oldEnableCustomHelpProperty = PropertyInitializer.newProperty("EnableCustomHelp", false);
        migrated |= this.moveProperty(oldEnableCustomHelpProperty, CommandConfig.CUSTOM_HELP_ENABLED, reader, configData);
        Property<Boolean> oldDisablePrefixProperty = PropertyInitializer.newProperty("DisablePrefix", false);
        migrated |= this.moveProperty(oldDisablePrefixProperty, MessageConfig.DISABLE_PREFIX, reader, configData);
        Property<Boolean> oldDefaultSkinsEnabledProperty = PropertyInitializer.newProperty("DefaultSkins.Enabled", false);
        migrated |= this.moveProperty(oldDefaultSkinsEnabledProperty, StorageConfig.DEFAULT_SKINS_ENABLED, reader, configData);
        Property<Boolean> oldDefaultSkinsApplyForPremiumProperty = PropertyInitializer.newProperty("DefaultSkins.ApplyForPremium", false);
        migrated |= this.moveProperty(oldDefaultSkinsApplyForPremiumProperty, StorageConfig.DEFAULT_SKINS_PREMIUM, reader, configData);
        Property<List<String>> oldDefaultSkinsNamesProperty = PropertyInitializer.newListProperty("DefaultSkins.Names", Collections.emptyList());
        migrated |= this.moveProperty(oldDefaultSkinsNamesProperty, StorageConfig.DEFAULT_SKINS, reader, configData);
        Property<Boolean> oldDisabledSkinsEnabledProperty = PropertyInitializer.newProperty("DisabledSkins.Enabled", false);
        migrated |= this.moveProperty(oldDisabledSkinsEnabledProperty, CommandConfig.DISABLED_SKINS_ENABLED, reader, configData);
        Property<List<String>> oldDisabledSkinsNamesProperty = PropertyInitializer.newListProperty("DisabledSkins.Names", Collections.emptyList());
        migrated |= this.moveProperty(oldDisabledSkinsNamesProperty, CommandConfig.DISABLED_SKINS, reader, configData);
        Property<Boolean> oldNotAllowedCommandServersProperty = PropertyInitializer.newProperty("NotAllowedCommandServers.Enabled", true);
        migrated |= this.moveProperty(oldNotAllowedCommandServersProperty, ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_ENABLED, reader, configData);
        Property<Boolean> oldNotAllowedCommandServersAllowListProperty = PropertyInitializer.newProperty("NotAllowedCommandServers.AllowList", false);
        migrated |= this.moveProperty(oldNotAllowedCommandServersAllowListProperty, ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_ALLOWLIST, reader, configData);
        Property<Boolean> oldNotAllowedCommandServersIfNoServerBlockCommandProperty = PropertyInitializer.newProperty("NotAllowedCommandServers.IfNoServerBlockCommand", false);
        migrated |= this.moveProperty(oldNotAllowedCommandServersIfNoServerBlockCommandProperty, ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_IF_NONE_BLOCK_COMMAND, reader, configData);
        Property<List<String>> oldNotAllowedCommandServersListProperty = PropertyInitializer.newListProperty("NotAllowedCommandServers.List", Collections.emptyList());
        migrated |= this.moveProperty(oldNotAllowedCommandServersListProperty, ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS, reader, configData);
        Property<Boolean> oldCustomGUIEnabledProperty = PropertyInitializer.newProperty("CustomGUI.Enabled", false);
        migrated |= this.moveProperty(oldCustomGUIEnabledProperty, GUIConfig.CUSTOM_GUI_ENABLED, reader, configData);
        Property<Boolean> oldCustomGUIShowOnlyCustomGUIProperty = PropertyInitializer.newProperty("CustomGUI.ShowOnlyCustomGUI", true);
        migrated |= this.moveProperty(oldCustomGUIShowOnlyCustomGUIProperty, GUIConfig.CUSTOM_GUI_ONLY, reader, configData);
        Property<List<String>> oldCustomGUINamesProperty = PropertyInitializer.newListProperty("CustomGUI.Names", Collections.emptyList());
        migrated |= this.moveProperty(oldCustomGUINamesProperty, GUIConfig.CUSTOM_GUI_SKINS, reader, configData);
        Property<Boolean> oldPerSkinPermissionsProperty = PropertyInitializer.newProperty("PerSkinPermissions", false);
        migrated |= this.moveProperty(oldPerSkinPermissionsProperty, CommandConfig.PER_SKIN_PERMISSIONS, reader, configData);
        Property<Integer> oldSkinExpiresAfterProperty = PropertyInitializer.newProperty("SkinExpiresAfter", 15);
        migrated |= this.moveProperty(oldSkinExpiresAfterProperty, StorageConfig.SKIN_EXPIRES_AFTER, reader, configData);
        Property<Boolean> oldNoSkinIfLoginCanceledProperty = PropertyInitializer.newProperty("NoSkinIfLoginCanceled", true);
        migrated |= this.moveProperty(oldNoSkinIfLoginCanceledProperty, LoginConfig.NO_SKIN_IF_LOGIN_CANCELED, reader, configData);
        Property<Boolean> oldAlwaysApplyPremiumProperty = PropertyInitializer.newProperty("AlwaysApplyPremium", false);
        migrated |= this.moveProperty(oldAlwaysApplyPremiumProperty, LoginConfig.ALWAYS_APPLY_PREMIUM, reader, configData);
        Property<Boolean> oldRestrictSkinUrlsEnabledProperty = PropertyInitializer.newProperty("RestrictSkinUrls.Enabled", false);
        migrated |= this.moveProperty(oldRestrictSkinUrlsEnabledProperty, CommandConfig.RESTRICT_SKIN_URLS_ENABLED, reader, configData);
        Property<List<String>> oldRestrictSkinUrlsListProperty = PropertyInitializer.newListProperty("RestrictSkinUrls.List", Collections.emptyList());
        migrated |= this.moveProperty(oldRestrictSkinUrlsListProperty, CommandConfig.RESTRICT_SKIN_URLS_LIST, reader, configData);
        Property<String> oldMineskinAPIKeyProperty = PropertyInitializer.newProperty("MineskinAPIKey", "key");
        migrated |= this.moveProperty(oldMineskinAPIKeyProperty, APIConfig.MINESKIN_API_KEY, reader, configData);
        Property<Boolean> oldResourcePackFixProperty = PropertyInitializer.newProperty("ResourcePackFix", true);
        migrated |= this.moveProperty(oldResourcePackFixProperty, ServerConfig.RESOURCE_PACK_FIX, reader, configData);
        Property<Boolean> oldDismountPlayerOnSkinUpdateProperty = PropertyInitializer.newProperty("DismountPlayerOnSkinUpdate", true);
        migrated |= this.moveProperty(oldDismountPlayerOnSkinUpdateProperty, ServerConfig.DISMOUNT_PLAYER_ON_UPDATE, reader, configData);
        Property<Boolean> oldRemountPlayerOnSkinUpdateProperty = PropertyInitializer.newProperty("RemountPlayerOnSkinUpdate", true);
        migrated |= this.moveProperty(oldRemountPlayerOnSkinUpdateProperty, ServerConfig.REMOUNT_PLAYER_ON_UPDATE, reader, configData);
        Property<Boolean> oldDismountPassengersOnSkinUpdateProperty = PropertyInitializer.newProperty("DismountPassengersOnSkinUpdate", false);
        migrated |= this.moveProperty(oldDismountPassengersOnSkinUpdateProperty, ServerConfig.DISMOUNT_PASSENGERS_ON_UPDATE, reader, configData);
        Property<Boolean> oldDisableOnJoinSkinsProperty = PropertyInitializer.newProperty("DisableOnJoinSkins", false);
        migrated |= this.moveProperty(oldDisableOnJoinSkinsProperty, AdvancedConfig.DISABLE_ON_JOIN_SKINS, reader, configData);
        Property<Boolean> oldDisallowAutoUpdateSkinProperty = PropertyInitializer.newProperty("DisallowAutoUpdateSkin", false);
        migrated |= this.moveProperty(oldDisallowAutoUpdateSkinProperty, StorageConfig.DISALLOW_AUTO_UPDATE_SKIN, reader, configData);
        Property<Boolean> oldEnablePaperJoinListenerProperty = PropertyInitializer.newProperty("EnablePaperJoinListener", true);
        migrated |= this.moveProperty(oldEnablePaperJoinListenerProperty, AdvancedConfig.ENABLE_PAPER_JOIN_LISTENER, reader, configData);
        Property<Boolean> oldForwardTexturesProperty = PropertyInitializer.newProperty("ForwardTextures", true);
        migrated |= this.moveProperty(oldForwardTexturesProperty, AdvancedConfig.FORWARD_TEXTURES, reader, configData);
        if (Boolean.TRUE.equals(configData.getValue(DatabaseConfig.MYSQL_ENABLED))) {
            Property<String> oldMySQLPlayerTable;
            Property<String> oldMySQLSkinTable = PropertyInitializer.newProperty("MySQL.SkinTable", "Skins");
            if (oldMySQLSkinTable.isValidInResource(reader)) {
                try {
                    Files.write(this.plugin.getDataFolder().resolve("legacy_skin_table.txt"), oldMySQLSkinTable.determineValue(reader).getValue().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    this.logger.severe("Failed to write legacy_skin_table.txt", e);
                }
            }
            if ((oldMySQLPlayerTable = PropertyInitializer.newProperty("MySQL.PlayerTable", "Players")).isValidInResource(reader)) {
                try {
                    Files.write(this.plugin.getDataFolder().resolve("legacy_player_table.txt"), oldMySQLPlayerTable.determineValue(reader).getValue().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    this.logger.severe("Failed to write legacy_player_table.txt", e);
                }
            }
        }
        return migrated;
    }

    protected <T> boolean moveProperty(Property<T> oldProperty, Property<T> newProperty, PropertyReader reader, ConfigurationData configData) {
        PropertyValue<T> oldPropertyValue = oldProperty.determineValue(reader);
        if (oldPropertyValue.isValidInResource()) {
            if (reader.contains(newProperty.getPath())) {
                this.logger.info("Detected deprecated property " + oldProperty.getPath());
            } else {
                this.logger.info("Renaming " + oldProperty.getPath() + " to " + newProperty.getPath());
                configData.setValue(newProperty, oldPropertyValue.getValue());
            }
            return true;
        }
        return false;
    }

    @Inject
    public ConfigMigratorService(SRLogger logger, SRPlugin plugin) {
        this.logger = logger;
        this.plugin = plugin;
    }
}

