/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.config;

import net.skinsrestorer.shadow.configme.SettingsHolder;
import net.skinsrestorer.shadow.configme.configurationdata.CommentsConfiguration;
import net.skinsrestorer.shadow.configme.properties.Property;
import net.skinsrestorer.shadow.configme.properties.PropertyInitializer;

public class DatabaseConfig
implements SettingsHolder {
    public static final Property<Boolean> MYSQL_ENABLED = PropertyInitializer.newProperty("database.enabled", false);
    public static final Property<String> MYSQL_HOST = PropertyInitializer.newProperty("database.host", "localhost");
    public static final Property<Integer> MYSQL_PORT = PropertyInitializer.newProperty("database.port", 3306);
    public static final Property<String> MYSQL_DATABASE = PropertyInitializer.newProperty("database.database", "db");
    public static final Property<String> MYSQL_USERNAME = PropertyInitializer.newProperty("database.username", "root");
    public static final Property<String> MYSQL_PASSWORD = PropertyInitializer.newProperty("database.password", "pass");
    public static final Property<Integer> MYSQL_MAX_POOL_SIZE = PropertyInitializer.newProperty("database.maxPoolSize", 10);
    public static final Property<String> MYSQL_TABLE_PREFIX = PropertyInitializer.newProperty("database.tablePrefix", "sr_");
    public static final Property<String> MYSQL_CONNECTION_OPTIONS = PropertyInitializer.newProperty("database.connectionOptions", "sslMode=trust&serverTimezone=UTC");

    @Override
    public void registerComments(CommentsConfiguration conf) {
        conf.setComment("database", "\n", "\n############", "\n# Database #", "\n############", "\n", "Settings for databases skin storage (recommended for large networks with a lot of skins)", "[!] IF YOU USE A PROXY, DO NOT ENABLE MYSQL in the Spigot / Backend config.yml [!]", "[!] Non-root users: MySQL 8's new default authentication is not supported, use mysql_native_password [!]", "[!] Make sure you have the correct permissions set for your MySQL user. [!]", "[!] Make sure to fill in database.connectionOptions if you're using certificate / ssl authentication. [!]", "[!] If you're not using ssl, change sslMode=trust to sslMode=disable [!]");
    }
}

