/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections.http;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.connections.http.HttpResponse;
import net.skinsrestorer.shared.log.SRLogger;

public class HttpClient {
    private final SRLogger logger;
    private final SettingsManager settings;

    public HttpResponse execute(URI uri, RequestBody requestBody, HttpType accepts, String userAgent, HttpMethod method, Map<String, String> headers, int timeout) throws IOException {
        InputStream is;
        if (this.settings.getProperty(AdvancedConfig.NO_CONNECTIONS).booleanValue()) {
            throw new IOException("Connections are disabled.");
        }
        long start = System.currentTimeMillis();
        URL url = uri.toURL();
        if (!url.getProtocol().equals("https")) {
            throw new IOException("Only HTTPS is supported.");
        }
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod(method.name());
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Accept", accepts.getContentType());
        connection.setRequestProperty("User-Agent", userAgent);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        connection.setDoOutput(requestBody != null);
        if (requestBody != null) {
            connection.setRequestProperty("Content-Length", String.valueOf(requestBody.getBody().length()));
            connection.setRequestProperty("Content-Type", requestBody.getType().getContentType());
            try (DataOutputStream output = new DataOutputStream(connection.getOutputStream());){
                output.writeBytes(requestBody.getBody());
                output.flush();
            }
        }
        connection.connect();
        StringBuilder body = new StringBuilder();
        try {
            is = connection.getInputStream();
        }
        catch (IOException e) {
            this.logger.debug("Failed to get input stream, falling back to error stream.", e);
            is = connection.getErrorStream();
        }
        if (is == null) {
            throw new IOException("Failed to get input stream.");
        }
        try (DataInputStream input = new DataInputStream(is);){
            int c = input.read();
            while (c != -1) {
                body.append((char)c);
                c = input.read();
            }
        }
        HttpResponse response = new HttpResponse(connection.getResponseCode(), body.toString(), connection.getHeaderFields());
        this.logger.debug("Response body: " + response.getBody().replace("\n", "").replace("\r", ""));
        this.logger.debug("Response code: " + response.getStatusCode());
        this.logger.debug("Request took " + (System.currentTimeMillis() - start) + "ms.");
        return response;
    }

    @Inject
    public HttpClient(SRLogger logger, SettingsManager settings) {
        this.logger = logger;
        this.settings = settings;
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }

    public static enum HttpType {
        JSON("application/json"),
        TEXT("text/plain"),
        FORM("application/x-www-form-urlencoded");

        private final String contentType;

        public String getContentType() {
            return this.contentType;
        }

        private HttpType(String contentType) {
            this.contentType = contentType;
        }
    }

    public static class RequestBody {
        private final String body;
        private final HttpType type;

        public String getBody() {
            return this.body;
        }

        public HttpType getType() {
            return this.type;
        }

        public RequestBody(String body, HttpType type) {
            this.body = body;
            this.type = type;
        }
    }
}

