/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.log;

import java.util.EnumMap;
import java.util.Map;
import net.skinsrestorer.shared.log.AnsiBuilder;
import net.skinsrestorer.shared.log.SRChatColor;

public class ANSIConverter {
    private static final Map<SRChatColor, String> replacements = new EnumMap<SRChatColor, String>(SRChatColor.class);
    private static final SRChatColor[] colors = SRChatColor.values();

    public static String convertToAnsi(String minecraftMessage) {
        String result = minecraftMessage;
        for (SRChatColor color : colors) {
            result = result.replaceAll("(?i)" + color.toString(), replacements.getOrDefault((Object)color, ""));
        }
        return result;
    }

    static {
        replacements.put(SRChatColor.BLACK, AnsiBuilder.ansi().fg(AnsiBuilder.Color.BLACK).boldOff().toString());
        replacements.put(SRChatColor.DARK_BLUE, AnsiBuilder.ansi().fg(AnsiBuilder.Color.BLUE).boldOff().toString());
        replacements.put(SRChatColor.DARK_GREEN, AnsiBuilder.ansi().fg(AnsiBuilder.Color.GREEN).boldOff().toString());
        replacements.put(SRChatColor.DARK_AQUA, AnsiBuilder.ansi().fg(AnsiBuilder.Color.CYAN).boldOff().toString());
        replacements.put(SRChatColor.DARK_RED, AnsiBuilder.ansi().fg(AnsiBuilder.Color.RED).boldOff().toString());
        replacements.put(SRChatColor.DARK_PURPLE, AnsiBuilder.ansi().fg(AnsiBuilder.Color.MAGENTA).boldOff().toString());
        replacements.put(SRChatColor.GOLD, AnsiBuilder.ansi().fg(AnsiBuilder.Color.YELLOW).boldOff().toString());
        replacements.put(SRChatColor.GRAY, AnsiBuilder.ansi().fg(AnsiBuilder.Color.WHITE).boldOff().toString());
        replacements.put(SRChatColor.DARK_GRAY, AnsiBuilder.ansi().fg(AnsiBuilder.Color.BLACK).bold().toString());
        replacements.put(SRChatColor.BLUE, AnsiBuilder.ansi().fg(AnsiBuilder.Color.BLUE).bold().toString());
        replacements.put(SRChatColor.GREEN, AnsiBuilder.ansi().fg(AnsiBuilder.Color.GREEN).bold().toString());
        replacements.put(SRChatColor.AQUA, AnsiBuilder.ansi().fg(AnsiBuilder.Color.CYAN).bold().toString());
        replacements.put(SRChatColor.RED, AnsiBuilder.ansi().fg(AnsiBuilder.Color.RED).bold().toString());
        replacements.put(SRChatColor.LIGHT_PURPLE, AnsiBuilder.ansi().fg(AnsiBuilder.Color.MAGENTA).bold().toString());
        replacements.put(SRChatColor.YELLOW, AnsiBuilder.ansi().fg(AnsiBuilder.Color.YELLOW).bold().toString());
        replacements.put(SRChatColor.WHITE, AnsiBuilder.ansi().fg(AnsiBuilder.Color.WHITE).bold().toString());
        replacements.put(SRChatColor.MAGIC, AnsiBuilder.ansi().a(AnsiBuilder.Attribute.BLINK_SLOW).toString());
        replacements.put(SRChatColor.BOLD, AnsiBuilder.ansi().a(AnsiBuilder.Attribute.UNDERLINE_DOUBLE).toString());
        replacements.put(SRChatColor.STRIKETHROUGH, AnsiBuilder.ansi().a(AnsiBuilder.Attribute.STRIKETHROUGH_ON).toString());
        replacements.put(SRChatColor.UNDERLINE, AnsiBuilder.ansi().a(AnsiBuilder.Attribute.UNDERLINE).toString());
        replacements.put(SRChatColor.ITALIC, AnsiBuilder.ansi().a(AnsiBuilder.Attribute.ITALIC).toString());
        replacements.put(SRChatColor.RESET, AnsiBuilder.ansi().a(AnsiBuilder.Attribute.RESET).fg(AnsiBuilder.Color.DEFAULT).toString());
    }
}

