/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.skinsrestorer.shared.log.SRConsole;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRPlatformLogger;

public class JavaLoggerImpl
implements SRPlatformLogger {
    private final SRConsole console;
    private final Logger logger;

    @Override
    public void log(SRLogLevel level, String message) {
        switch (level) {
            case INFO: {
                this.console.sendMessage(message);
                break;
            }
            case WARNING: {
                this.logger.warning(message);
                break;
            }
            case SEVERE: {
                this.logger.severe(message);
                break;
            }
        }
    }

    @Override
    public void log(SRLogLevel level, String message, Throwable throwable) {
        switch (level) {
            case INFO: {
                this.logger.log(Level.INFO, message, throwable);
                break;
            }
            case WARNING: {
                this.logger.log(Level.WARNING, message, throwable);
                break;
            }
            case SEVERE: {
                this.logger.log(Level.SEVERE, message, throwable);
                break;
            }
        }
    }

    public JavaLoggerImpl(SRConsole console, Logger logger) {
        this.console = console;
        this.logger = logger;
    }
}

