/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.mysql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.ijannotations.Language;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.Connection;
import net.skinsrestorer.shadow.mariadb.pool.Pool;
import net.skinsrestorer.shadow.mariadb.pool.Pools;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;

public class MySQLProvider {
    private final SRLogger logger;
    private final SettingsManager settings;
    private Pool pool;

    public void initPool() throws SQLException {
        String host = this.settings.getProperty(DatabaseConfig.MYSQL_HOST);
        String username = this.settings.getProperty(DatabaseConfig.MYSQL_USERNAME);
        String password = this.settings.getProperty(DatabaseConfig.MYSQL_PASSWORD);
        String database = this.settings.getProperty(DatabaseConfig.MYSQL_DATABASE);
        int port = this.settings.getProperty(DatabaseConfig.MYSQL_PORT);
        int maxPoolSize = this.settings.getProperty(DatabaseConfig.MYSQL_MAX_POOL_SIZE);
        String options = this.settings.getProperty(DatabaseConfig.MYSQL_CONNECTION_OPTIONS);
        Configuration configuration = Configuration.parse("jdbc:mysql://" + host + ":" + port + "/" + database + "?permitMysqlScheme&maxPoolSize=" + maxPoolSize + "&" + options);
        this.pool = Pools.retrievePool(configuration.clone(username, password));
    }

    public void execute(@Language(value="sql") String query, Object ... vars) {
        block15: {
            try (Connection connection = this.pool.getPoolConnection().getConnection();
                 PreparedStatement ps = connection.prepareStatement(query);){
                this.fillPreparedStatement(ps, vars);
                ps.execute();
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 1060) {
                    return;
                }
                this.logger.warning("MySQL error: " + e.getMessage(), e);
                if (!SRPlugin.isUnitTest()) break block15;
                throw new AssertionError((Object)e);
            }
        }
    }

    public ResultSet query(@Language(value="sql") String query, Object ... vars) throws SQLException {
        try (Connection connection = this.pool.getPoolConnection().getConnection();){
            ResultSet resultSet;
            block12: {
                PreparedStatement ps = connection.prepareStatement(query);
                try {
                    this.fillPreparedStatement(ps, vars);
                    resultSet = ps.executeQuery();
                    if (ps == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return resultSet;
        }
    }

    private void fillPreparedStatement(PreparedStatement ps, Object ... vars) throws SQLException {
        int i = 0;
        for (Object obj : vars) {
            ++i;
            try {
                ps.setObject(i, obj);
            }
            catch (SQLException e) {
                throw new SQLException("Error while setting prepared statement variable #" + i + " (" + obj + "): " + e.getMessage());
            }
        }
    }

    @Inject
    public MySQLProvider(SRLogger logger, SettingsManager settings) {
        this.logger = logger;
        this.settings = settings;
    }
}

