/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects;

import java.util.Locale;
import java.util.Optional;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.config.MessageConfig;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;

public abstract class AbstractSRCommandSender
implements SRCommandSender {
    @Override
    public Locale getLocale() {
        return this.getSettings().getProperty(MessageConfig.LOCALE);
    }

    @Override
    public void sendMessage(Message key, TagResolver ... resolvers) {
        Optional<String> translatedMessage = this.getSRLocale().getMessageOptional(this, key, resolvers);
        if (!translatedMessage.isPresent()) {
            return;
        }
        this.sendMessage(translatedMessage.get());
    }

    protected abstract SkinsRestorerLocale getSRLocale();

    protected abstract SettingsManager getSettings();

    protected AbstractSRCommandSender(AbstractSRCommandSenderBuilder<?, ?> b) {
    }

    public static abstract class AbstractSRCommandSenderBuilder<C extends AbstractSRCommandSender, B extends AbstractSRCommandSenderBuilder<C, B>> {
        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AbstractSRCommandSender.AbstractSRCommandSenderBuilder()";
        }
    }
}

