/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge.wrapper;

import java.util.Locale;
import java.util.UUID;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRServerPlayer;
import net.skinsrestorer.sponge.wrapper.WrapperCommandSender;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;

public class WrapperPlayer
extends WrapperCommandSender
implements SRServerPlayer {
    private final ServerPlayer player;

    @Override
    public Locale getLocale() {
        return this.player.locale();
    }

    @Override
    public <P> P getAs(Class<P> playerClass) {
        return playerClass.cast(this.player);
    }

    @Override
    public UUID getUniqueId() {
        return this.player.uniqueId();
    }

    @Override
    public String getName() {
        return this.player.name();
    }

    @Override
    public boolean canSee(SRPlayer player) {
        return this.player.canSee((Entity)player.getAs(Player.class));
    }

    @Override
    public void closeInventory() {
        this.player.closeInventory();
    }

    protected WrapperPlayer(WrapperPlayerBuilder<?, ?> b) {
        super((WrapperCommandSender.WrapperCommandSenderBuilder<?, ?>)b);
        this.player = b.player;
    }

    public static WrapperPlayerBuilder<?, ?> builder() {
        return new WrapperPlayerBuilderImpl();
    }

    public static abstract class WrapperPlayerBuilder<C extends WrapperPlayer, B extends WrapperPlayerBuilder<C, B>>
    extends WrapperCommandSender.WrapperCommandSenderBuilder<C, B> {
        private ServerPlayer player;

        public B player(ServerPlayer player) {
            this.player = player;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "WrapperPlayer.WrapperPlayerBuilder(super=" + super.toString() + ", player=" + this.player + ")";
        }
    }

    private static final class WrapperPlayerBuilderImpl
    extends WrapperPlayerBuilder<WrapperPlayer, WrapperPlayerBuilderImpl> {
        private WrapperPlayerBuilderImpl() {
        }

        @Override
        protected WrapperPlayerBuilderImpl self() {
            return this;
        }

        @Override
        public WrapperPlayer build() {
            return new WrapperPlayer(this);
        }
    }
}

