/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity;

import com.google.inject.Injector;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.RawCommand;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.bstats.velocity.Metrics;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.commands.library.CommandUtils;
import net.skinsrestorer.shared.commands.library.SRRegisterPayload;
import net.skinsrestorer.shared.info.Platform;
import net.skinsrestorer.shared.info.PluginInfo;
import net.skinsrestorer.shared.plugin.SRProxyAdapter;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;
import net.skinsrestorer.velocity.SRVelocityBootstrap;
import net.skinsrestorer.velocity.listener.ForceAliveListener;
import net.skinsrestorer.velocity.wrapper.WrapperVelocity;

public class SRVelocityAdapter
implements SRProxyAdapter<PluginContainer> {
    private final net.skinsrestorer.shadow.injector.Injector injector;
    private final SRVelocityBootstrap pluginInstance;
    private final ProxyServer proxy;

    @Override
    public Object createMetricsInstance() {
        Metrics.Factory metricsFactory = (Metrics.Factory)this.injector.getSingleton(Injector.class).getInstance(Metrics.Factory.class);
        return metricsFactory.make(this.pluginInstance, 10606);
    }

    @Override
    public boolean isPluginEnabled(String pluginName) {
        return this.proxy.getPluginManager().getPlugin(pluginName).isPresent();
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.proxy.getScheduler().buildTask((Object)this.pluginInstance, runnable).schedule();
    }

    @Override
    public void runRepeatAsync(Runnable runnable, int delay, int interval, TimeUnit timeUnit) {
        this.proxy.getScheduler().buildTask((Object)this.pluginInstance, runnable).delay((long)delay, timeUnit).repeat((long)interval, timeUnit).schedule();
    }

    @Override
    public void extendLifeTime(PluginContainer plugin, Object object) {
        this.proxy.getEventManager().register((Object)plugin, ProxyShutdownEvent.class, PostOrder.LAST, (EventHandler)new ForceAliveListener(object));
    }

    @Override
    public String getPlatformVersion() {
        return this.proxy.getVersion().getVersion();
    }

    @Override
    public String getPlatformName() {
        return this.proxy.getVersion().getName();
    }

    @Override
    public String getPlatformVendor() {
        return this.proxy.getVersion().getVendor();
    }

    @Override
    public Platform getPlatform() {
        return Platform.VELOCITY;
    }

    @Override
    public List<PluginInfo> getPlugins() {
        return this.proxy.getPluginManager().getPlugins().stream().map(p -> new PluginInfo(p.getInstance().isPresent(), p.getDescription().getName().orElseGet(() -> p.getDescription().getId()), p.getDescription().getVersion().orElse("Unknown"), "N/A", p.getDescription().getAuthors().toArray(new String[0]))).collect(Collectors.toList());
    }

    @Override
    public Optional<SkinProperty> getSkinProperty(SRPlayer player) {
        List prop = player.getAs(Player.class).getGameProfileProperties();
        return prop.stream().filter(p -> p.getName().equals("textures")).map(p -> SkinProperty.of(p.getValue(), p.getSignature())).findFirst();
    }

    @Override
    public Collection<SRPlayer> getOnlinePlayers() {
        WrapperVelocity wrapper = this.injector.getSingleton(WrapperVelocity.class);
        return this.proxy.getAllPlayers().stream().map(wrapper::player).collect(Collectors.toList());
    }

    @Override
    public Optional<SRProxyPlayer> getPlayer(String name) {
        return this.proxy.getPlayer(name).map(this.injector.getSingleton(WrapperVelocity.class)::player);
    }

    @Override
    public void registerCommand(final SRRegisterPayload<SRCommandSender> payload) {
        CommandMeta meta = this.proxy.getCommandManager().metaBuilder(payload.getMeta().getRootName()).plugin((Object)this.pluginInstance).aliases(payload.getMeta().getAliases()).build();
        final WrapperVelocity wrapper = this.injector.getSingleton(WrapperVelocity.class);
        this.proxy.getCommandManager().register(meta, (Command)new RawCommand(){

            public void execute(RawCommand.Invocation invocation) {
                payload.getExecutor().execute(wrapper.commandSender(invocation.source()), CommandUtils.joinCommand(invocation.alias(), (String)invocation.arguments(), false));
            }

            public CompletableFuture<List<String>> suggestAsync(RawCommand.Invocation invocation) {
                return payload.getExecutor().tabComplete(wrapper.commandSender(invocation.source()), CommandUtils.joinCommand(invocation.alias(), (String)invocation.arguments(), true));
            }

            public boolean hasPermission(RawCommand.Invocation invocation) {
                return payload.getExecutor().hasPermission(wrapper.commandSender(invocation.source()));
            }
        });
    }

    public net.skinsrestorer.shadow.injector.Injector getInjector() {
        return this.injector;
    }

    public SRVelocityBootstrap getPluginInstance() {
        return this.pluginInstance;
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    @Inject
    public SRVelocityAdapter(net.skinsrestorer.shadow.injector.Injector injector, SRVelocityBootstrap pluginInstance, ProxyServer proxy) {
        this.injector = injector;
        this.pluginInstance = pluginInstance;
        this.proxy = proxy;
    }
}

