/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.chat.rgb;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.TextColor;
import me.neznamy.tab.api.chat.rgb.format.BukkitFormat;
import me.neznamy.tab.api.chat.rgb.format.CMIFormat;
import me.neznamy.tab.api.chat.rgb.format.HtmlFormat;
import me.neznamy.tab.api.chat.rgb.format.KyoriFormat;
import me.neznamy.tab.api.chat.rgb.format.MiniMessageFormat;
import me.neznamy.tab.api.chat.rgb.format.RGBFormatter;
import me.neznamy.tab.api.chat.rgb.format.UnnamedFormat1;
import me.neznamy.tab.api.chat.rgb.gradient.CMIGradient;
import me.neznamy.tab.api.chat.rgb.gradient.CommonGradient;
import me.neznamy.tab.api.chat.rgb.gradient.GradientPattern;
import me.neznamy.tab.api.chat.rgb.gradient.KyoriGradient;
import me.neznamy.tab.api.util.Preconditions;

public class RGBUtils {
    private static final RGBUtils instance = new RGBUtils();
    private final RGBFormatter[] formats;
    private final GradientPattern[] gradients;
    private final Pattern tabPattern = Pattern.compile("#[0-9a-fA-F]{6}");
    private final Pattern tabPatternLegacy = Pattern.compile("#[0-9a-fA-F]{6}\\|.");

    public RGBUtils() {
        ArrayList<RGBFormatter> list = new ArrayList<RGBFormatter>();
        list.add(new BukkitFormat());
        list.add(new CMIFormat());
        list.add(new UnnamedFormat1());
        list.add(new HtmlFormat());
        list.add(new KyoriFormat());
        try {
            Class.forName("net.kyori.adventure.text.minimessage.MiniMessage");
            list.add(new MiniMessageFormat());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.formats = list.toArray(new RGBFormatter[0]);
        this.gradients = new GradientPattern[]{new CMIGradient(), new CommonGradient(Pattern.compile("<#[0-9a-fA-F]{6}>[^<]*</#[0-9a-fA-F]{6}>"), Pattern.compile("<#[0-9a-fA-F]{6}\\|.>[^<]*</#[0-9a-fA-F]{6}>"), "<#", 9, 2, 9, 7), new CommonGradient(Pattern.compile("<\\$#[0-9a-fA-F]{6}>[^<]*<\\$#[0-9a-fA-F]{6}>"), Pattern.compile("<\\$#[0-9a-fA-F]{6}\\|.>[^<]*<\\$#[0-9a-fA-F]{6}>"), "<$", 10, 3, 10, 7), new KyoriGradient()};
    }

    public static RGBUtils getInstance() {
        return instance;
    }

    public String applyFormats(String text) {
        Preconditions.checkNotNull(text, "text");
        String replaced = text;
        for (GradientPattern pattern : this.gradients) {
            replaced = pattern.applyPattern(replaced, false);
        }
        for (RGBFormatter formatter : this.formats) {
            replaced = formatter.reformat(replaced);
        }
        return replaced;
    }

    public String applyCleanGradients(String text) {
        Preconditions.checkNotNull(text, "text");
        String replaced = text;
        for (GradientPattern pattern : this.gradients) {
            replaced = pattern.applyPattern(replaced, true);
        }
        return replaced;
    }

    public String convertToBukkitFormat(String text, boolean rgbClient) {
        if (text == null) {
            return null;
        }
        if (!text.contains("#")) {
            return text;
        }
        if (rgbClient) {
            String replaced = this.applyFormats(text);
            for (Pattern p : new Pattern[]{this.tabPatternLegacy, this.tabPattern}) {
                Matcher m = p.matcher(replaced);
                while (m.find()) {
                    String hexCode = m.group();
                    String fixed = "&x&" + hexCode.charAt(1) + "&" + hexCode.charAt(2) + "&" + hexCode.charAt(3) + "&" + hexCode.charAt(4) + "&" + hexCode.charAt(5) + "&" + hexCode.charAt(6);
                    replaced = replaced.replace(hexCode, EnumChatFormat.color(fixed));
                }
            }
            return replaced;
        }
        return this.convertRGBtoLegacy(text);
    }

    public String convertRGBtoLegacy(String text) {
        if (text == null) {
            return null;
        }
        if (!text.contains("#")) {
            return EnumChatFormat.color(text);
        }
        String applied = this.applyFormats(text);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < applied.length(); ++i) {
            char c = applied.charAt(i);
            if (c == '#' && applied.length() > i + 6) {
                String hexCode = applied.substring(i + 1, i + 7);
                if (this.isHexCode(hexCode)) {
                    if (RGBUtils.containsLegacyCode(applied, i)) {
                        sb.append(new TextColor(hexCode, EnumChatFormat.getByChar(applied.charAt(i + 8))).getLegacyColor().getFormat());
                        i += 8;
                        continue;
                    }
                    sb.append(new TextColor(hexCode).getLegacyColor().getFormat());
                    i += 6;
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public boolean isHexCode(String string) {
        Preconditions.checkNotNull(string, "string");
        if (string.length() != 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            char c = string.charAt(i);
            if (!(c < '0' || c > '9' && c < 'A' || c > 'F' && c < 'a') && c <= 'f') continue;
            return false;
        }
        return true;
    }

    private static boolean containsLegacyCode(String text, int i) {
        if (text.length() - i < 9 || text.charAt(i + 7) != '|') {
            return false;
        }
        return EnumChatFormat.getByChar(text.charAt(i + 8)) != null;
    }
}

