/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.chat.rgb.gradient;

import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.TextColor;

public interface GradientPattern {
    public String applyPattern(String var1, boolean var2);

    default public String asGradient(TextColor start, String text, TextColor end) {
        String magicCodes = EnumChatFormat.getLastColors(text);
        String deColorized = text.substring(magicCodes.length());
        StringBuilder sb = new StringBuilder();
        int length = deColorized.length();
        if (length == 1) {
            sb.append("#");
            sb.append(new TextColor(start.getRed(), start.getGreen(), start.getBlue()).getHexCode());
            if (start.isLegacyColorForced()) {
                sb.append("|").append(start.getLegacyColor().getCharacter());
            }
            sb.append(magicCodes);
            sb.append(deColorized);
            return sb.toString();
        }
        for (int i = 0; i < length; ++i) {
            int red = (int)((float)start.getRed() + (float)(end.getRed() - start.getRed()) / (float)(length - 1) * (float)i);
            int green = (int)((float)start.getGreen() + (float)(end.getGreen() - start.getGreen()) / (float)(length - 1) * (float)i);
            int blue = (int)((float)start.getBlue() + (float)(end.getBlue() - start.getBlue()) / (float)(length - 1) * (float)i);
            sb.append("#");
            sb.append(new TextColor(red, green, blue).getHexCode());
            if (start.isLegacyColorForced()) {
                sb.append("|").append(start.getLegacyColor().getCharacter());
            }
            sb.append(magicCodes);
            sb.append(deColorized.charAt(i));
        }
        return sb.toString();
    }
}

