/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.util.Preconditions;

public abstract class ConfigurationFile {
    protected List<String> header;
    protected Map<String, Object> values;
    protected final File file;

    protected ConfigurationFile(InputStream source, File destination) throws IOException {
        Preconditions.checkNotNull(destination, "destination");
        this.file = destination;
        if (this.file.getParentFile() != null && !this.file.getParentFile().exists()) {
            Files.createDirectories(this.file.getParentFile().toPath(), new FileAttribute[0]);
        }
        if (!this.file.exists() && source == null) {
            throw new IllegalStateException("File does not exist and source is null");
        }
        if (this.file.createNewFile()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(source, StandardCharsets.UTF_8));
                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.write(line + "\n");
                }
            }
        }
        this.detectHeader();
    }

    public abstract void save();

    public String getName() {
        return this.file.getName();
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Object> values) {
        this.values = values;
    }

    public Object getObject(String path, Object defaultValue) {
        String[] stringArray;
        Object value = this.values;
        if (path.contains(".")) {
            stringArray = path.split("\\.");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = path;
        }
        for (String section : stringArray) {
            if (!(value instanceof Map)) {
                if (defaultValue != null) {
                    this.set(path, defaultValue);
                }
                return defaultValue;
            }
            value = this.getIgnoreCase((Map<Object, Object>)value, section);
        }
        if (value == null && defaultValue != null) {
            TabAPI.getInstance().debug("Inserting missing config option \"" + path + "\" with value \"" + defaultValue + "\" into " + this.file.getName());
            this.set(path, defaultValue);
            return defaultValue;
        }
        return value;
    }

    public Object getObject(String path) {
        return this.getObject(path, null);
    }

    public Object getObject(String[] path) {
        Object value = this.values;
        for (String section : path) {
            if (!(value instanceof Map)) {
                return null;
            }
            value = this.getIgnoreCase((Map<Object, Object>)value, section);
        }
        return value;
    }

    private Object getIgnoreCase(Map<Object, Object> map, String key) {
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            if (!entry.getKey().toString().equalsIgnoreCase(key)) continue;
            return entry.getValue();
        }
        return map.get(key);
    }

    public String getString(String path) {
        return this.getString(path, null);
    }

    public String getString(String path, String defaultValue) {
        Object value = this.getObject(path, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        return String.valueOf(value);
    }

    public List<String> getStringList(String path) {
        return this.getStringList(path, null);
    }

    public List<String> getStringList(String path, List<String> defaultValue) {
        Object value = this.getObject(path, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        if (!(value instanceof List)) {
            return new ArrayList<String>();
        }
        ArrayList<String> fixedList = new ArrayList<String>();
        for (Object key : (List)value) {
            fixedList.add(String.valueOf(key));
        }
        return fixedList;
    }

    public Integer getInt(String path) {
        return this.getInt(path, null);
    }

    public Integer getInt(String path, Integer defaultValue) {
        Object value = this.getObject(path, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        Object value = this.getObject(path, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public Double getDouble(String path, double defaultValue) {
        Object value = this.getObject(path, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public <K, V> Map<K, V> getConfigurationSection(String path) {
        if (path == null || path.length() == 0) {
            return this.values;
        }
        Object value = this.getObject(path, null);
        if (value instanceof Map) {
            return (Map)value;
        }
        return new LinkedHashMap();
    }

    public boolean hasConfigOption(String path) {
        return this.getObject(path) != null;
    }

    public void set(String path, Object value) {
        this.set(this.values, path, value);
        this.save();
    }

    private Map<String, Object> set(Map<String, Object> map, String path, Object value) {
        if (path.contains(".")) {
            String keyWord = this.getRealKey(map, path.split("\\.")[0]);
            LinkedHashMap subMap = map.get(keyWord);
            if (!(subMap instanceof Map)) {
                subMap = new LinkedHashMap();
            }
            map.put(keyWord, this.set(subMap, path.substring(keyWord.length() + 1), value));
        } else if (value == null) {
            map.remove(this.getRealKey(map, path));
        } else {
            map.put(path, value);
        }
        return map;
    }

    private String getRealKey(Map<?, ?> map, String key) {
        for (Object mapKey : map.keySet()) {
            if (!mapKey.toString().equalsIgnoreCase(key)) continue;
            return mapKey.toString();
        }
        return key;
    }

    private void detectHeader() throws IOException {
        this.header = new ArrayList<String>();
        for (String line : Files.readAllLines(this.file.toPath())) {
            if (!line.startsWith("#")) break;
            this.header.add(line);
        }
    }

    public void fixHeader() throws IOException {
        if (this.header == null) {
            return;
        }
        ArrayList<String> content = new ArrayList<String>(this.header);
        content.addAll(Files.readAllLines(this.file.toPath()));
        Files.delete(this.file.toPath());
        if (this.file.createNewFile()) {
            Files.write(this.file.toPath(), content, new OpenOption[0]);
        }
    }

    public File getFile() {
        return this.file;
    }
}

