/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.platforms.bukkit.BukkitPlatform;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class BukkitEventListener
implements Listener {
    private final BukkitPlatform platform;

    public BukkitEventListener(BukkitPlatform platform) {
        this.platform = platform;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onQuit(PlayerQuitEvent e) {
        if (TabAPI.getInstance().isPluginDisabled()) {
            return;
        }
        TabAPI.getInstance().getThreadManager().runTask(() -> TabAPI.getInstance().getFeatureManager().onQuit(TabAPI.getInstance().getPlayer(e.getPlayer().getUniqueId())));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent e) {
        if (TabAPI.getInstance().isPluginDisabled()) {
            return;
        }
        TabAPI.getInstance().getThreadManager().runTask(() -> TabAPI.getInstance().getFeatureManager().onJoin(new BukkitTabPlayer(e.getPlayer(), this.platform.getProtocolVersion(e.getPlayer()))));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        if (TabAPI.getInstance().isPluginDisabled()) {
            return;
        }
        TabAPI.getInstance().getThreadManager().runTask(() -> TabAPI.getInstance().getFeatureManager().onWorldChange(e.getPlayer().getUniqueId(), e.getPlayer().getWorld().getName()));
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent e) {
        if (TabAPI.getInstance().isPluginDisabled()) {
            return;
        }
        if (TabAPI.getInstance().getFeatureManager().onCommand(TabAPI.getInstance().getPlayer(e.getPlayer().getUniqueId()), e.getMessage())) {
            e.setCancelled(true);
        }
    }
}

