/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.libs.org.bstats.bukkit.Metrics;
import me.neznamy.tab.libs.org.bstats.charts.SimplePie;
import me.neznamy.tab.platforms.bukkit.BukkitEventListener;
import me.neznamy.tab.platforms.bukkit.BukkitPlatform;
import me.neznamy.tab.platforms.bukkit.nms.BukkitModernNMSStorage;
import me.neznamy.tab.platforms.bukkit.nms.LegacyNMSStorage;
import me.neznamy.tab.platforms.bukkit.nms.MojangModernNMSStorage;
import me.neznamy.tab.platforms.bukkit.nms.NMSStorage;
import me.neznamy.tab.shared.TAB;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Main
extends JavaPlugin {
    public void onEnable() {
        String version = Bukkit.getBukkitVersion().split("-")[0];
        String serverPackage = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        Bukkit.getConsoleSender().sendMessage(EnumChatFormat.color("[TAB] Server version: " + version + " (" + serverPackage + ")"));
        if (!this.isVersionSupported()) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        BukkitPlatform platform = new BukkitPlatform(this);
        TAB.setInstance(new TAB(platform, ProtocolVersion.fromFriendlyName(version), version + " (" + serverPackage + ")", this.getDataFolder(), this.getLogger()));
        if (TAB.getInstance().getServerVersion() == ProtocolVersion.UNKNOWN_SERVER_VERSION) {
            Bukkit.getConsoleSender().sendMessage(EnumChatFormat.color("&c[TAB] Unknown server version: " + Bukkit.getBukkitVersion() + "! Plugin may not work correctly."));
        }
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitEventListener(platform), (Plugin)this);
        TAB.getInstance().load();
        Metrics metrics = new Metrics(this, 5304);
        metrics.addCustomChart(new SimplePie("unlimited_nametag_mode_enabled", () -> TAB.getInstance().getFeatureManager().isFeatureEnabled("NameTagX") ? "Yes" : "No"));
        metrics.addCustomChart(new SimplePie("placeholderapi", () -> Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") ? "Yes" : "No"));
        metrics.addCustomChart(new SimplePie("permission_system", () -> TAB.getInstance().getGroupManager().getPlugin().getName()));
        metrics.addCustomChart(new SimplePie("server_version", () -> "1." + TAB.getInstance().getServerVersion().getMinorVersion() + ".x"));
        PluginCommand cmd = Bukkit.getPluginCommand((String)"tab");
        if (cmd == null) {
            return;
        }
        TABCommand command = new TABCommand();
        cmd.setExecutor((CommandExecutor)command);
        cmd.setTabCompleter((TabCompleter)command);
    }

    public void onDisable() {
        if (TAB.getInstance() != null) {
            TAB.getInstance().unload();
        }
    }

    private boolean isVersionSupported() {
        List<String> supportedVersions = Arrays.asList("v1_5_R1", "v1_5_R2", "v1_5_R3", "v1_6_R1", "v1_6_R2", "v1_6_R3", "v1_7_R1", "v1_7_R2", "v1_7_R3", "v1_7_R4", "v1_8_R1", "v1_8_R2", "v1_8_R3", "v1_9_R1", "v1_9_R2", "v1_10_R1", "v1_11_R1", "v1_12_R1", "v1_13_R1", "v1_13_R2", "v1_14_R1", "v1_15_R1", "v1_16_R1", "v1_16_R2", "v1_16_R3", "v1_17_R1", "v1_18_R1", "v1_18_R2", "v1_19_R1");
        String serverPackage = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        try {
            long time = System.currentTimeMillis();
            int minorVersion = Integer.parseInt(serverPackage.split("_")[1]);
            if (minorVersion >= 17) {
                try {
                    NMSStorage.setInstance(new BukkitModernNMSStorage());
                }
                catch (ClassNotFoundException e) {
                    NMSStorage.setInstance(new MojangModernNMSStorage());
                }
            } else {
                NMSStorage.setInstance(new LegacyNMSStorage());
            }
            if (supportedVersions.contains(serverPackage)) {
                Bukkit.getConsoleSender().sendMessage(EnumChatFormat.color("[TAB] Loaded NMS hook in " + (System.currentTimeMillis() - time) + "ms"));
                return true;
            }
            Bukkit.getConsoleSender().sendMessage(EnumChatFormat.color("&c[TAB] No compatibility issue was found, but this plugin version does not claim to support your server package (" + serverPackage + "). This jar has only been tested on 1.5.x - 1.19. Disabling just to stay safe."));
        }
        catch (Exception ex) {
            if (supportedVersions.contains(serverPackage)) {
                Bukkit.getConsoleSender().sendMessage(EnumChatFormat.color("&c[TAB] Your server version is marked as compatible, but a compatibility issue was found. Please report the error below (include your server version & fork too)"));
                this.getLogger().log(Level.SEVERE, "", ex);
            }
            Bukkit.getConsoleSender().sendMessage(EnumChatFormat.color("&c[TAB] Your server version is completely unsupported. This plugin version only supports 1.5.x - 1.19. Disabling."));
        }
        return false;
    }

    private static class TABCommand
    implements CommandExecutor,
    TabCompleter {
        private TABCommand() {
        }

        public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
            if (TabAPI.getInstance().isPluginDisabled()) {
                for (String message : TAB.getInstance().getDisabledCommand().execute(args, sender.hasPermission("tab.reload"), sender.hasPermission("tab.admin"))) {
                    sender.sendMessage(EnumChatFormat.color(message));
                }
            } else {
                TabPlayer p = null;
                if (sender instanceof Player && (p = TAB.getInstance().getPlayer(((Player)sender).getUniqueId())) == null) {
                    return true;
                }
                TAB.getInstance().getCommand().execute(p, args);
            }
            return false;
        }

        public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
            TabPlayer p = null;
            if (sender instanceof Player && (p = TAB.getInstance().getPlayer(((Player)sender).getUniqueId())) == null) {
                return new ArrayList<String>();
            }
            return TAB.getInstance().getCommand().complete(p, args);
        }
    }
}

