/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.shared.TAB;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PerWorldPlayerList
extends TabFeature
implements Listener {
    private final JavaPlugin plugin;
    private final boolean allowBypass = TabAPI.getInstance().getConfig().getBoolean("per-world-playerlist.allow-bypass-permission", false);
    private final List<String> ignoredWorlds = TabAPI.getInstance().getConfig().getStringList("per-world-playerlist.ignore-effect-in-worlds", Arrays.asList("ignoredworld", "build"));
    private final Map<String, List<String>> sharedWorlds = TabAPI.getInstance().getConfig().getConfigurationSection("per-world-playerlist.shared-playerlist-world-groups");

    public PerWorldPlayerList(JavaPlugin plugin) {
        super("Per world PlayerList", null);
        this.plugin = plugin;
        TabAPI.getInstance().debug(String.format("Loaded PerWorldPlayerList feature with parameters allowBypass=%s, ignoredWorlds=%s, sharedWorlds=%s", this.allowBypass, this.ignoredWorlds, this.sharedWorlds));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void load() {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getOnlinePlayers().forEach(this::checkPlayer));
    }

    @Override
    public void unload() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            for (Player pl : Bukkit.getOnlinePlayers()) {
                p.showPlayer(pl);
            }
        }
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        long time = System.nanoTime();
        this.checkPlayer(e.getPlayer());
        TAB.getInstance().getCPUManager().addTime(this.getFeatureName(), "Player Join", System.nanoTime() - time);
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        long time = System.nanoTime();
        this.checkPlayer(e.getPlayer());
        TAB.getInstance().getCPUManager().addTime(this.getFeatureName(), "World Switch", System.nanoTime() - time);
    }

    private void checkPlayer(Player p) {
        for (Player all : Bukkit.getOnlinePlayers()) {
            if (all == p) continue;
            if (!this.shouldSee(p, all) && p.canSee(all)) {
                p.hidePlayer(all);
            }
            if (this.shouldSee(p, all) && !p.canSee(all)) {
                p.showPlayer(all);
            }
            if (!this.shouldSee(all, p) && all.canSee(p)) {
                all.hidePlayer(p);
            }
            if (!this.shouldSee(all, p) || all.canSee(p)) continue;
            all.showPlayer(p);
        }
    }

    private boolean shouldSee(Player viewer, Player target) {
        if (target == viewer) {
            return true;
        }
        if (this.allowBypass && viewer.hasPermission("tab.bypass") || this.ignoredWorlds.contains(viewer.getWorld().getName())) {
            return true;
        }
        String viewerWorldGroup = viewer.getWorld().getName() + "-default";
        String targetWorldGroup = target.getWorld().getName() + "-default";
        for (Map.Entry<String, List<String>> group : this.sharedWorlds.entrySet()) {
            if (group.getValue() == null) continue;
            if (group.getValue().contains(viewer.getWorld().getName())) {
                viewerWorldGroup = group.getKey();
            }
            if (!group.getValue().contains(target.getWorld().getName())) continue;
            targetWorldGroup = group.getKey();
        }
        return viewerWorldGroup.equals(targetWorldGroup);
    }
}

