/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features;

import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.bossbar.BossBar;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityTeleport;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WitherBossBar
extends BossBarManagerImpl
implements Listener {
    private static final int WITHER_DISTANCE = 60;

    public WitherBossBar(JavaPlugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        TAB.getInstance().getCPUManager().startRepeatingMeasuredTask(100, this, "Teleporting wither", this::teleport);
    }

    @Override
    public void load() {
        super.load();
        this.teleport();
    }

    private void teleport() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (p.getVersion().getMinorVersion() > 8) continue;
            for (BossBar line : this.getRegisteredBossBars().values()) {
                if (!line.containsPlayer(p)) continue;
                Location loc = ((Player)p.getPlayer()).getEyeLocation().add(((Player)p.getPlayer()).getEyeLocation().getDirection().normalize().multiply(60));
                if (loc.getY() < 1.0) {
                    loc.setY(1.0);
                }
                p.sendCustomPacket((TabPacket)new PacketPlayOutEntityTeleport(line.getUniqueId().hashCode(), loc), "BossBar (Teleporting Wither)");
            }
        }
    }

    @Override
    public void unload() {
        super.unload();
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        TAB.getInstance().getCPUManager().runMeasuredTask(this, "Player Respawn", () -> this.detectBossBarsAndSend(TAB.getInstance().getPlayer(e.getPlayer().getUniqueId())));
    }
}

