/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features.unlimitedtags;

import me.neznamy.tab.api.ArmorStandManager;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.BukkitArmorStandManager;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.EventListener;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.PacketListener;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.VehicleRefresher;
import me.neznamy.tab.shared.features.nametags.unlimited.NameTagX;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitNameTagX
extends NameTagX {
    private final EventListener eventListener = new EventListener(this);
    private final VehicleRefresher vehicleManager = new VehicleRefresher(this);

    public BukkitNameTagX(JavaPlugin plugin) {
        super(BukkitArmorStandManager::new);
        Bukkit.getPluginManager().registerEvents((Listener)this.eventListener, (Plugin)plugin);
        TabAPI.getInstance().getFeatureManager().registerFeature("nametagx-packet", new PacketListener(this));
        TabAPI.getInstance().getFeatureManager().registerFeature("nametagx-vehicle", this.vehicleManager);
    }

    @Override
    public void load() {
        super.load();
        for (TabPlayer all : TabAPI.getInstance().getOnlinePlayers()) {
            if (this.isPlayerDisabled(all)) continue;
            for (TabPlayer viewer : TabAPI.getInstance().getOnlinePlayers()) {
                this.spawnArmorStands(viewer, all);
            }
        }
        this.startVisibilityRefreshTask();
    }

    private void startVisibilityRefreshTask() {
        TabAPI.getInstance().getThreadManager().startRepeatingMeasuredTask(500, this, "Refreshing NameTag visibility", () -> {
            for (TabPlayer p : TabAPI.getInstance().getOnlinePlayers()) {
                if (this.isPlayerDisabled(p)) continue;
                this.getArmorStandManager(p).updateVisibility(false);
            }
        });
    }

    @Override
    public void unload() {
        super.unload();
        HandlerList.unregisterAll((Listener)this.eventListener);
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        super.onJoin(connectedPlayer);
        if (this.isPlayerDisabled(connectedPlayer)) {
            return;
        }
        for (TabPlayer viewer : TabAPI.getInstance().getOnlinePlayers()) {
            this.spawnArmorStands(viewer, connectedPlayer);
            this.spawnArmorStands(connectedPlayer, viewer);
        }
    }

    @Override
    public boolean isOnBoat(TabPlayer player) {
        return this.vehicleManager != null && this.vehicleManager.isOnBoat(player);
    }

    private void spawnArmorStands(TabPlayer viewer, TabPlayer target) {
        if (viewer.getVersion().getMinorVersion() < 8) {
            return;
        }
        if (target == viewer || this.isPlayerDisabled(target)) {
            return;
        }
        if (((Player)viewer.getPlayer()).getWorld() != ((Player)target.getPlayer()).getWorld()) {
            return;
        }
        if (this.getDistance(viewer, target) <= 48.0 && ((Player)viewer.getPlayer()).canSee((Player)target.getPlayer()) && !target.isVanished()) {
            this.getArmorStandManager(target).spawn(viewer);
        }
    }

    @Override
    public void setNameTagPreview(TabPlayer player, boolean status) {
        if (status) {
            this.getArmorStandManager(player).spawn(player);
        } else {
            this.getArmorStandManager(player).destroy(player);
        }
    }

    @Override
    public void resumeArmorStands(TabPlayer player) {
        if (this.isPlayerDisabled(player)) {
            return;
        }
        for (TabPlayer viewer : TabAPI.getInstance().getOnlinePlayers()) {
            this.spawnArmorStands(viewer, player);
        }
    }

    @Override
    public void pauseArmorStands(TabPlayer player) {
        this.getArmorStandManager(player).destroy();
    }

    @Override
    public void updateNameTagVisibilityView(TabPlayer player) {
        for (TabPlayer all : TabAPI.getInstance().getOnlinePlayers()) {
            this.getArmorStandManager(all).updateVisibility(true);
        }
    }

    @Override
    public void onQuit(TabPlayer disconnectedPlayer) {
        super.onQuit(disconnectedPlayer);
        for (TabPlayer all : TabAPI.getInstance().getOnlinePlayers()) {
            this.getArmorStandManager(all).unregisterPlayer(disconnectedPlayer);
        }
        ((ArmorStandManager)this.armorStandManagerMap.get(disconnectedPlayer)).destroy();
        this.armorStandManagerMap.remove(disconnectedPlayer);
    }

    @Override
    public void onWorldChange(TabPlayer p, String from, String to) {
        super.onWorldChange(p, from, to);
        if (this.isUnlimitedDisabled(p.getServer(), to)) {
            this.getDisabledUnlimitedPlayers().add(p);
            this.updateTeamData(p);
        } else if (this.getDisabledUnlimitedPlayers().remove(p)) {
            this.updateTeamData(p);
        }
        if (this.isPreviewingNametag(p)) {
            this.getArmorStandManager(p).spawn(p);
        }
        for (TabPlayer viewer : TabAPI.getInstance().getOnlinePlayers()) {
            if (!viewer.getWorld().equals(from)) continue;
            this.getArmorStandManager(p).destroy(viewer);
        }
    }

    private double getDistance(TabPlayer player1, TabPlayer player2) {
        Location loc1 = ((Player)player1.getPlayer()).getLocation();
        Location loc2 = ((Player)player2.getPlayer()).getLocation();
        return Math.sqrt(Math.pow(loc1.getX() - loc2.getX(), 2.0) + Math.pow(loc1.getZ() - loc2.getZ(), 2.0));
    }

    @Override
    public BukkitArmorStandManager getArmorStandManager(TabPlayer player) {
        return (BukkitArmorStandManager)this.armorStandManagerMap.get(player);
    }

    public VehicleRefresher getVehicleManager() {
        return this.vehicleManager;
    }
}

