/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features.unlimitedtags;

import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.BukkitNameTagX;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class EventListener
implements Listener {
    private final BukkitNameTagX feature;

    public EventListener(BukkitNameTagX feature) {
        this.feature = feature;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSneak(PlayerToggleSneakEvent e) {
        TabPlayer p = TabAPI.getInstance().getPlayer(e.getPlayer().getUniqueId());
        if (p == null || this.feature.isPlayerDisabled(p)) {
            return;
        }
        TabAPI.getInstance().getThreadManager().runMeasuredTask(this.feature, "Player Sneak", () -> this.feature.getArmorStandManager(p).sneak(e.isSneaking()));
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        TabAPI.getInstance().getThreadManager().runMeasuredTask(this.feature, "Player Respawn", () -> {
            TabPlayer respawned = TabAPI.getInstance().getPlayer(e.getPlayer().getUniqueId());
            if (this.feature.isPlayerDisabled(respawned)) {
                return;
            }
            this.feature.getArmorStandManager(respawned).teleport();
        });
    }
}

