/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import java.util.ArrayList;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketBuilder;
import me.neznamy.tab.api.protocol.PacketPlayOutBoss;
import me.neznamy.tab.api.protocol.PacketPlayOutChat;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerListHeaderFooter;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardDisplayObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.Skin;
import net.md_5.bungee.protocol.PlayerPublicKey;
import net.md_5.bungee.protocol.Property;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.SystemChat;
import net.md_5.bungee.protocol.packet.Team;

public class BungeePacketBuilder
extends PacketBuilder {
    @Override
    public Object build(PacketPlayOutBoss packet, ProtocolVersion clientVersion) {
        if (clientVersion.getMinorVersion() < 9) {
            return null;
        }
        BossBar bungeePacket = new BossBar(packet.getId(), packet.getAction().ordinal());
        bungeePacket.setHealth(packet.getPct());
        bungeePacket.setTitle(packet.getName() == null ? null : IChatBaseComponent.optimizedComponent(packet.getName()).toString(clientVersion));
        bungeePacket.setColor(packet.getColor() == null ? 0 : packet.getColor().ordinal());
        bungeePacket.setDivision(packet.getOverlay() == null ? 0 : packet.getOverlay().ordinal());
        bungeePacket.setFlags(packet.getFlags());
        return bungeePacket;
    }

    @Override
    public Object build(PacketPlayOutChat packet, ProtocolVersion clientVersion) {
        if (clientVersion.getMinorVersion() >= 19) {
            return new SystemChat(packet.getMessage().toString(clientVersion), (int)((byte)packet.getType().ordinal()));
        }
        return new Chat(packet.getMessage().toString(clientVersion), (byte)packet.getType().ordinal());
    }

    @Override
    public Object build(PacketPlayOutPlayerInfo packet, ProtocolVersion clientVersion) {
        ArrayList<PlayerListItem.Item> items = new ArrayList<PlayerListItem.Item>();
        for (PacketPlayOutPlayerInfo.PlayerInfoData data : packet.getEntries()) {
            PlayerListItem.Item item = new PlayerListItem.Item();
            if (data.getDisplayName() != null) {
                if (clientVersion.getMinorVersion() >= 8) {
                    item.setDisplayName(data.getDisplayName().toString(clientVersion));
                } else {
                    item.setDisplayName(data.getDisplayName().toLegacyText());
                }
            } else if (clientVersion.getMinorVersion() < 8) {
                item.setDisplayName(String.valueOf(data.getName()));
            }
            if (data.getGameMode() != null) {
                item.setGamemode(data.getGameMode().ordinal() - 1);
            }
            item.setPing(data.getLatency());
            if (data.getSkin() != null) {
                item.setProperties(new Property[]{new Property("textures", data.getSkin().getValue(), data.getSkin().getSignature())});
            } else {
                item.setProperties(new Property[0]);
            }
            item.setUsername(data.getName());
            item.setUuid(data.getUniqueId());
            item.setPublicKey((PlayerPublicKey)data.getProfilePublicKey());
            items.add(item);
        }
        PlayerListItem bungeePacket = new PlayerListItem();
        bungeePacket.setAction(PlayerListItem.Action.valueOf((String)packet.getAction().toString().replace("GAME_MODE", "GAMEMODE")));
        bungeePacket.setItems(items.toArray(new PlayerListItem.Item[0]));
        return bungeePacket;
    }

    @Override
    public Object build(PacketPlayOutPlayerListHeaderFooter packet, ProtocolVersion clientVersion) {
        return new PlayerListHeaderFooter(packet.getHeader().toString(clientVersion, true), packet.getFooter().toString(clientVersion, true));
    }

    @Override
    public Object build(PacketPlayOutScoreboardDisplayObjective packet, ProtocolVersion clientVersion) {
        return new ScoreboardDisplay((byte)packet.getSlot(), packet.getObjectiveName());
    }

    @Override
    public Object build(PacketPlayOutScoreboardObjective packet, ProtocolVersion clientVersion) {
        return new ScoreboardObjective(packet.getObjectiveName(), this.jsonOrCut(packet.getDisplayName(), clientVersion, 32), packet.getRenderType() == null ? null : ScoreboardObjective.HealthDisplay.valueOf((String)packet.getRenderType().toString()), (byte)packet.getAction());
    }

    @Override
    public Object build(PacketPlayOutScoreboardScore packet, ProtocolVersion clientVersion) {
        return new ScoreboardScore(packet.getPlayer(), (byte)packet.getAction().ordinal(), packet.getObjectiveName(), packet.getScore());
    }

    @Override
    public Object build(PacketPlayOutScoreboardTeam packet, ProtocolVersion clientVersion) {
        int color = 0;
        if (clientVersion.getMinorVersion() >= 13) {
            color = (packet.getColor() != null ? packet.getColor() : EnumChatFormat.lastColorsOf(packet.getPlayerPrefix())).ordinal();
        }
        return new Team(packet.getName(), (byte)packet.getAction(), this.jsonOrCut(packet.getName(), clientVersion, 16), this.jsonOrCut(packet.getPlayerPrefix(), clientVersion, 16), this.jsonOrCut(packet.getPlayerSuffix(), clientVersion, 16), packet.getNameTagVisibility(), packet.getCollisionRule(), color, (byte)packet.getOptions(), packet.getPlayers().toArray(new String[0]));
    }

    @Override
    public PacketPlayOutPlayerInfo readPlayerInfo(Object bungeePacket, ProtocolVersion clientVersion) {
        PlayerListItem item = (PlayerListItem)bungeePacket;
        ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> listData = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
        for (PlayerListItem.Item i : item.getItems()) {
            Skin skin = i.getProperties() == null || i.getProperties().length == 0 ? null : new Skin(i.getProperties()[0].getValue(), i.getProperties()[0].getSignature());
            listData.add(new PacketPlayOutPlayerInfo.PlayerInfoData(i.getUsername(), i.getUuid(), skin, i.getPing(), PacketPlayOutPlayerInfo.EnumGamemode.VALUES[i.getGamemode() + 1], IChatBaseComponent.deserialize(i.getDisplayName()), i.getPublicKey()));
        }
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.valueOf(item.getAction().toString().replace("GAMEMODE", "GAME_MODE")), listData);
    }

    @Override
    public PacketPlayOutScoreboardObjective readObjective(Object bungeePacket) {
        return new PacketPlayOutScoreboardObjective(((ScoreboardObjective)bungeePacket).getAction(), ((ScoreboardObjective)bungeePacket).getName(), null, PacketPlayOutScoreboardObjective.EnumScoreboardHealthDisplay.INTEGER);
    }

    @Override
    public PacketPlayOutScoreboardDisplayObjective readDisplayObjective(Object bungeePacket) {
        return new PacketPlayOutScoreboardDisplayObjective(((ScoreboardDisplay)bungeePacket).getPosition(), ((ScoreboardDisplay)bungeePacket).getName());
    }
}

