/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import de.myzelyam.api.vanish.BungeeVanishAPI;
import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.protocol.Skin;
import me.neznamy.tab.api.util.Preconditions;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.LoginRequest;

public class BungeeTabPlayer
extends ProxyTabPlayer {
    private static Method InitialHandler_getLoginProfile;
    private static Method InitialHandler_getLoginRequest;
    private static Method ChannelWrapper_getHandle;
    private static Method LoginResult_Property_getValue;
    private static Method LoginResult_Property_getSignature;
    private static Method LoginResult_getProperties;
    private static Method UserConnection_getGamemode;
    private static Field wrapperField;
    private static Object directionData;
    private static Method getId;

    public BungeeTabPlayer(ProxiedPlayer p) {
        super(p, p.getUniqueId(), p.getName(), p.getServer() != null ? p.getServer().getInfo().getName() : "-", -1, true);
        try {
            this.channel = (Channel)ChannelWrapper_getHandle.invoke(wrapperField.get(this.getPlayer().getPendingConnection()), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            TAB.getInstance().getErrorManager().criticalError("Failed to get channel of " + this.getPlayer().getName(), e);
        }
    }

    @Override
    public boolean hasPermission0(String permission) {
        Preconditions.checkNotNull(permission, "permission");
        long time = System.nanoTime();
        boolean value = this.getPlayer().hasPermission(permission);
        TAB.getInstance().getCPUManager().addMethodTime("hasPermission", System.nanoTime() - time);
        return value;
    }

    @Override
    public int getPing() {
        return this.getPlayer().getPing();
    }

    @Override
    public void sendPacket(Object nmsPacket) {
        long time = System.nanoTime();
        if (nmsPacket != null && this.getPlayer().isConnected()) {
            this.getPlayer().unsafe().sendPacket((DefinedPacket)nmsPacket);
        }
        TAB.getInstance().getCPUManager().addMethodTime("sendPacket", System.nanoTime() - time);
    }

    @Override
    public Skin getSkin() {
        try {
            Object loginResult = InitialHandler_getLoginProfile.invoke((Object)this.getPlayer().getPendingConnection(), new Object[0]);
            if (loginResult == null) {
                return null;
            }
            Object[] properties = (Object[])LoginResult_getProperties.invoke(loginResult, new Object[0]);
            if (properties == null || properties.length == 0) {
                return null;
            }
            return new Skin((String)LoginResult_Property_getValue.invoke(properties[0], new Object[0]), (String)LoginResult_Property_getSignature.invoke(properties[0], new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().printError("Failed to get skin of " + this.getName(), e);
            return null;
        }
    }

    public ProxiedPlayer getPlayer() {
        return (ProxiedPlayer)this.player;
    }

    public int getPacketId(Class<? extends DefinedPacket> clazz) {
        Preconditions.checkNotNull(clazz, "class");
        try {
            return (Integer)getId.invoke(directionData, clazz, this.getPlayer().getPendingConnection().getVersion());
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().printError("Failed to get packet id for packet " + clazz + " with client version " + this.getPlayer().getPendingConnection().getVersion(), e);
            return -1;
        }
    }

    @Override
    public ProtocolVersion getVersion() {
        return ProtocolVersion.fromNetworkId(this.getPlayer().getPendingConnection().getVersion());
    }

    @Override
    public boolean isVanished() {
        try {
            if (ProxyServer.getInstance().getPluginManager().getPlugin("PremiumVanish") != null && BungeeVanishAPI.isInvisible((ProxiedPlayer)this.getPlayer())) {
                return true;
            }
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("PremiumVanish v" + TAB.getInstance().getPlatform().getPluginVersion("PremiumVanish") + " generated an error when retrieving vanish status of " + this.getName(), e);
        }
        return super.isVanished();
    }

    @Override
    public boolean isOnline() {
        return this.getPlayer().isConnected();
    }

    @Override
    public int getGamemode() {
        try {
            return (Integer)UserConnection_getGamemode.invoke(this.player, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().printError("Failed to get gamemode of " + this.getPlayer().getName(), e);
            return 0;
        }
    }

    @Override
    public Object getProfilePublicKey() {
        try {
            return ((LoginRequest)InitialHandler_getLoginRequest.invoke((Object)this.getPlayer().getPendingConnection(), new Object[0])).getPublicKey();
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().printError("Failed to get profile key of " + this.getPlayer().getName(), e);
            return null;
        }
    }

    @Override
    public void sendPluginMessage(byte[] message) {
        Preconditions.checkNotNull(message, "message");
        if (this.getPlayer().getServer() == null) {
            return;
        }
        this.getPlayer().getServer().sendData("tab:bridge-2", message);
        TAB.getInstance().getCPUManager().packetSent("Plugin Message (" + new String(message) + ")");
    }

    static {
        try {
            Class<?> initialHandler = Class.forName("net.md_5.bungee.connection.InitialHandler");
            InitialHandler_getLoginProfile = initialHandler.getMethod("getLoginProfile", new Class[0]);
            InitialHandler_getLoginRequest = initialHandler.getMethod("getLoginRequest", new Class[0]);
            Class<?> channelWrapper = Class.forName("net.md_5.bungee.netty.ChannelWrapper");
            ChannelWrapper_getHandle = channelWrapper.getMethod("getHandle", new Class[0]);
            Class<?> loginResult = Class.forName("net.md_5.bungee.connection.LoginResult");
            Class<?> loginResult_Property = Class.forName("net.md_5.bungee.protocol.Property");
            LoginResult_Property_getValue = loginResult_Property.getMethod("getValue", new Class[0]);
            LoginResult_Property_getSignature = loginResult_Property.getMethod("getSignature", new Class[0]);
            LoginResult_getProperties = loginResult.getMethod("getProperties", new Class[0]);
            Class<?> userConnection = Class.forName("net.md_5.bungee.UserConnection");
            UserConnection_getGamemode = userConnection.getMethod("getGamemode", new Class[0]);
            Field f = Protocol.class.getDeclaredField("TO_CLIENT");
            f.setAccessible(true);
            directionData = f.get(Protocol.GAME);
            getId = directionData.getClass().getDeclaredMethod("getId", Class.class, Integer.TYPE);
            getId.setAccessible(true);
            wrapperField = initialHandler.getDeclaredField("ch");
            wrapperField.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().criticalError("Failed to initialize bungee internal fields", e);
        }
    }
}

