/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import java.util.ArrayList;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.libs.org.bstats.bungeecord.Metrics;
import me.neznamy.tab.libs.org.bstats.charts.SimplePie;
import me.neznamy.tab.platforms.bungeecord.BungeeEventListener;
import me.neznamy.tab.platforms.bungeecord.BungeePlatform;
import me.neznamy.tab.shared.TAB;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.TabExecutor;

public class Main
extends Plugin {
    public void onEnable() {
        if (!this.isVersionSupported()) {
            this.getLogger().info(EnumChatFormat.color("&cThe plugin requires BungeeCord build #1637 and up to work. Get it at https://ci.md-5.net/job/BungeeCord/"));
            return;
        }
        BungeePlatform platform = new BungeePlatform();
        ProxyServer.getInstance().registerChannel("tab:bridge-2");
        TAB.setInstance(new TAB(platform, ProtocolVersion.PROXY, this.getProxy().getVersion(), this.getDataFolder(), this.getLogger()));
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new BungeeEventListener(platform));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BTABCommand());
        TAB.getInstance().load();
        Metrics metrics = new Metrics(this, 10535);
        metrics.addCustomChart(new SimplePie("permission_system", () -> TAB.getInstance().getGroupManager().getPlugin().getName()));
        metrics.addCustomChart(new SimplePie("global_playerlist_enabled", () -> TAB.getInstance().getFeatureManager().isFeatureEnabled("GlobalPlayerList") ? "Yes" : "No"));
    }

    private boolean isVersionSupported() {
        try {
            Class.forName("net.md_5.bungee.protocol.Property");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void onDisable() {
        if (TAB.getInstance() != null) {
            TAB.getInstance().unload();
        }
    }

    private static class BTABCommand
    extends Command
    implements TabExecutor {
        public BTABCommand() {
            super("btab", null, new String[0]);
        }

        public void execute(CommandSender sender, String[] args) {
            if (TAB.getInstance().isPluginDisabled()) {
                for (String message : TAB.getInstance().getDisabledCommand().execute(args, sender.hasPermission("tab.reload"), sender.hasPermission("tab.admin"))) {
                    sender.sendMessage((BaseComponent)new TextComponent(EnumChatFormat.color(message)));
                }
            } else {
                TabPlayer p = null;
                if (sender instanceof ProxiedPlayer && (p = TAB.getInstance().getPlayer(((ProxiedPlayer)sender).getUniqueId())) == null) {
                    return;
                }
                TAB.getInstance().getCommand().execute(p, args);
            }
        }

        public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
            TabPlayer p = null;
            if (sender instanceof ProxiedPlayer && (p = TAB.getInstance().getPlayer(((ProxiedPlayer)sender).getUniqueId())) == null) {
                return new ArrayList<String>();
            }
            return TAB.getInstance().getCommand().complete(p, args);
        }
    }
}

