/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import io.netty.channel.Channel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.neznamy.tab.api.Property;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.api.protocol.PacketPlayOutChat;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.api.team.TeamManager;
import me.neznamy.tab.api.util.Preconditions;
import me.neznamy.tab.shared.DynamicText;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.event.impl.PlayerLoadEventImpl;
import org.geysermc.floodgate.api.FloodgateApi;

public abstract class ITabPlayer
implements TabPlayer {
    protected final Object player;
    private final String name;
    private final UUID uniqueId;
    private final UUID tabListId;
    private String world;
    private String server;
    private String permissionGroup;
    private String temporaryGroup;
    private String teamName;
    private String teamNameNote;
    private final boolean bedrockPlayer;
    private final Map<String, Property> properties = new HashMap<String, Property>();
    protected final ProtocolVersion version;
    protected Channel channel;
    private boolean onJoinFinished;
    private final List<String> registeredTeams = new ArrayList<String>();
    private final List<String> registeredObjectives = new ArrayList<String>();
    private String nickname;

    protected ITabPlayer(Object player, UUID uniqueId, String name, String server, String world, int protocolVersion, boolean useRealId) {
        this.player = player;
        this.uniqueId = uniqueId;
        this.name = name;
        this.nickname = name;
        this.server = server;
        this.world = world;
        this.version = ProtocolVersion.fromNetworkId(protocolVersion);
        this.bedrockPlayer = TAB.getInstance().isFloodgateInstalled() && FloodgateApi.getInstance() != null && FloodgateApi.getInstance().isFloodgatePlayer(uniqueId);
        this.permissionGroup = TAB.getInstance().getGroupManager().detectPermissionGroup(this);
        UUID offlineId = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
        this.tabListId = useRealId ? this.getUniqueId() : offlineId;
    }

    private boolean setProperty(TabFeature feature, String identifier, String rawValue, String source, boolean exposeInExpansion) {
        DynamicText p = (DynamicText)this.getProperty(identifier);
        if (p == null) {
            this.properties.put(identifier, new DynamicText(exposeInExpansion ? identifier : null, feature, this, rawValue, source));
            return true;
        }
        if (!p.getOriginalRawValue().equals(rawValue)) {
            p.changeRawValue(rawValue, source);
            return true;
        }
        return false;
    }

    @Override
    public boolean setProperty(TabFeature feature, String identifier, String rawValue) {
        return this.setProperty(feature, identifier, rawValue, null, false);
    }

    public void setTeamName(String name) {
        this.teamName = name;
    }

    public void setTeamNameNote(String note) {
        this.teamNameNote = note;
    }

    public void markAsLoaded(boolean join) {
        this.onJoinFinished = true;
        if (TAB.getInstance().getEventBus() != null) {
            TAB.getInstance().getEventBus().fire(new PlayerLoadEventImpl(this, join));
        }
        TAB.getInstance().getPlatform().callLoadEvent(this);
    }

    public void setGroup(String permissionGroup) {
        Preconditions.checkNotNull(permissionGroup, "permissionGroup");
        if (this.permissionGroup.equals(permissionGroup)) {
            return;
        }
        this.permissionGroup = permissionGroup;
        ((PlayerPlaceholder)((Object)TAB.getInstance().getPlaceholderManager().getPlaceholder("%group%"))).updateValue(this, permissionGroup);
        this.forceRefresh();
    }

    public void setWorld(String name) {
        this.world = name;
    }

    public void setServer(String name) {
        this.server = name;
    }

    public void clearRegisteredObjectives() {
        this.registeredTeams.clear();
        this.registeredObjectives.clear();
    }

    @Override
    public void setTemporaryGroup(String group) {
        if (Objects.equals(group, this.temporaryGroup)) {
            return;
        }
        this.temporaryGroup = group;
        this.forceRefresh();
    }

    @Override
    public boolean hasTemporaryGroup() {
        return this.temporaryGroup != null;
    }

    @Override
    public void resetTemporaryGroup() {
        this.setTemporaryGroup(null);
    }

    @Override
    public void sendMessage(String message, boolean translateColors) {
        if (message == null || message.length() == 0) {
            return;
        }
        IChatBaseComponent component = translateColors ? IChatBaseComponent.fromColoredText(message) : new IChatBaseComponent(message);
        this.sendCustomPacket(new PacketPlayOutChat(component, PacketPlayOutChat.ChatMessageType.SYSTEM));
    }

    @Override
    public void sendMessage(IChatBaseComponent message) {
        this.sendCustomPacket(new PacketPlayOutChat(message, PacketPlayOutChat.ChatMessageType.SYSTEM));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public UUID getTablistUUID() {
        return this.tabListId;
    }

    @Override
    public void forceRefresh() {
        if (!this.onJoinFinished) {
            return;
        }
        TAB.getInstance().getFeatureManager().refresh(this, true);
    }

    @Override
    public ProtocolVersion getVersion() {
        return this.version;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public void sendCustomPacket(TabPacket packet) {
        String objective;
        int method;
        if (packet == null) {
            return;
        }
        if (packet instanceof PacketPlayOutScoreboardTeam) {
            String team = ((PacketPlayOutScoreboardTeam)packet).getName();
            method = ((PacketPlayOutScoreboardTeam)packet).getAction();
            if (method == 0) {
                if (this.registeredTeams.contains(team)) {
                    TAB.getInstance().getErrorManager().printError("Tried to register duplicated team " + team + " to player " + this.getName());
                    return;
                }
                this.registeredTeams.add(team);
            } else if (method == 1) {
                this.registeredTeams.remove(team);
            }
        }
        if (packet instanceof PacketPlayOutScoreboardObjective) {
            objective = ((PacketPlayOutScoreboardObjective)packet).getObjectiveName();
            method = ((PacketPlayOutScoreboardObjective)packet).getAction();
            if (method == 0) {
                if (this.registeredObjectives.contains(objective)) {
                    TAB.getInstance().getErrorManager().printError("Tried to register duplicated objective " + objective + " to player " + this.getName());
                    return;
                }
                this.registeredObjectives.add(objective);
            } else if (method == 1) {
                this.registeredObjectives.remove(objective);
            }
        }
        if (packet instanceof PacketPlayOutScoreboardScore) {
            objective = ((PacketPlayOutScoreboardScore)packet).getObjectiveName();
            String player = ((PacketPlayOutScoreboardScore)packet).getPlayer();
            if (!this.registeredObjectives.contains(objective)) {
                TAB.getInstance().getErrorManager().printError("Tried to update score (" + player + ") without the existence of its requested objective '" + objective + "' to player " + this.getName());
                return;
            }
        }
        try {
            this.sendPacket(TAB.getInstance().getPlatform().getPacketBuilder().build(packet, this.getVersion()));
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("An error occurred when creating " + packet.getClass().getSimpleName(), e);
        }
    }

    @Override
    public void sendCustomPacket(TabPacket packet, TabFeature feature) {
        this.sendCustomPacket(packet);
        if (feature != null) {
            TAB.getInstance().getCPUManager().packetSent(feature.getFeatureName());
        }
    }

    @Override
    public void sendCustomPacket(TabPacket packet, String feature) {
        this.sendCustomPacket(packet);
        if (feature != null) {
            TAB.getInstance().getCPUManager().packetSent(feature);
        }
    }

    @Override
    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public String getGroup() {
        return this.temporaryGroup != null ? this.temporaryGroup : this.permissionGroup;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public boolean isLoaded() {
        return this.onJoinFinished;
    }

    @Override
    public boolean loadPropertyFromConfig(TabFeature feature, String property) {
        return this.loadPropertyFromConfig(feature, property, "");
    }

    @Override
    public boolean loadPropertyFromConfig(TabFeature feature, String property, String ifNotSet) {
        String[] value = TAB.getInstance().getConfiguration().getUsers().getProperty(this.getName(), property, this.server, this.world);
        if (value.length == 0) {
            value = TAB.getInstance().getConfiguration().getUsers().getProperty(this.getUniqueId().toString(), property, this.server, this.world);
        }
        if (value.length == 0) {
            value = TAB.getInstance().getConfiguration().getGroups().getProperty(this.getGroup(), property, this.server, this.world);
        }
        if (value.length > 0) {
            return this.setProperty(feature, property, value[0], value[1], true);
        }
        return this.setProperty(feature, property, ifNotSet, "None", true);
    }

    @Override
    public String getTeamName() {
        TeamManager teams = TAB.getInstance().getTeamManager();
        if (teams != null && teams.getForcedTeamName(this) != null) {
            return teams.getForcedTeamName(this);
        }
        return this.teamName;
    }

    @Override
    public String getTeamNameNote() {
        return this.teamNameNote;
    }

    @Override
    public boolean isBedrockPlayer() {
        return this.bedrockPlayer;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

