/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.neznamy.tab.api.PropertyConfiguration;
import me.neznamy.tab.api.config.YamlConfigurationFile;
import me.neznamy.tab.shared.TAB;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlPropertyConfigurationFile
extends YamlConfigurationFile
implements PropertyConfiguration {
    private final String PER_SERVER = "per-server";
    private final String PER_WORLD = "per-world";
    private final String category;
    private final List<Object> worldGroups = new ArrayList(this.getConfigurationSection("per-world").keySet());
    private final List<Object> serverGroups = new ArrayList(this.getConfigurationSection("per-server").keySet());

    public YamlPropertyConfigurationFile(InputStream source, File destination) throws YAMLException, IOException {
        super(source, destination);
        this.category = destination.getName().contains("groups") ? "group" : "user";
    }

    @Override
    public void setProperty(String name, String property, String server, String world, String value) {
        if (world != null) {
            this.set(String.format("%s.%s.%s.%s", "per-world", world, name, property), this.fromString(value));
        } else if (server != null) {
            this.set(String.format("%s.%s.%s.%s", "per-server", server, name, property), this.fromString(value));
        } else {
            this.set(String.format("%s.%s", name, property), this.fromString(value));
        }
    }

    @Override
    public String[] getProperty(String name, String property, String server, String world) {
        Object value = this.getObject(new String[]{"per-world", TAB.getInstance().getConfiguration().getGroup(this.worldGroups, world), name, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + name + ", world=" + world};
        }
        value = this.getObject(new String[]{"per-world", TAB.getInstance().getConfiguration().getGroup(this.worldGroups, world), "_DEFAULT_", property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + "_DEFAULT_" + ", world=" + world};
        }
        value = this.getObject(new String[]{"per-server", TAB.getInstance().getConfiguration().getGroup(this.serverGroups, server), name, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + name + ", server=" + server};
        }
        value = this.getObject(new String[]{"per-server", TAB.getInstance().getConfiguration().getGroup(this.serverGroups, server), "_DEFAULT_", property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + "_DEFAULT_" + ", server=" + server};
        }
        value = this.getObject(new String[]{name, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + name};
        }
        value = this.getObject(new String[]{"_DEFAULT_", property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + "_DEFAULT_"};
        }
        return new String[0];
    }

    @Override
    public void remove(String name) {
        this.set(name, null);
        this.getConfigurationSection("per-world").keySet().forEach(world -> this.set("per-world." + world + "." + name, null));
        this.getConfigurationSection("per-server").keySet().forEach(server -> this.set("per-server." + server + "." + name, null));
    }

    @Override
    public Map<String, Object> getGlobalSettings(String name) {
        return this.getConfigurationSection(name);
    }

    @Override
    public Map<String, Map<String, Object>> getPerWorldSettings(String name) {
        return this.convertMap(this.getConfigurationSection("per-world"), name);
    }

    @Override
    public Map<String, Map<String, Object>> getPerServerSettings(String name) {
        return this.convertMap(this.getConfigurationSection("per-server"), name);
    }

    @Override
    public Set<String> getAllEntries() {
        HashSet<String> set = new HashSet<String>(this.values.keySet());
        set.remove("per-world");
        set.remove("per-server");
        Map perWorld = this.getConfigurationSection("per-world");
        perWorld.values().forEach(m -> set.addAll(m.keySet()));
        Map perServer = this.getConfigurationSection("per-server");
        perServer.values().forEach(m -> set.addAll(m.keySet()));
        return set;
    }
}

