/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import java.util.NoSuchElementException;
import java.util.function.Function;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.TAB;

public abstract class PipelineInjector
extends TabFeature {
    public final String DECODER_NAME = "TAB";
    private final String injectPosition;
    private String lastTeamOverrideMessage;
    protected final boolean antiOverrideTeams = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard-teams.enabled", true) && TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard-teams.anti-override", true);
    protected boolean byteBufDeserialization;

    protected PipelineInjector(String injectPosition) {
        super("Pipeline injection", null);
        this.injectPosition = injectPosition;
        if (this.antiOverrideTeams) {
            this.setByteBufDeserialization(true);
        }
    }

    public void inject(TabPlayer player) {
        if (player.getVersion().getMinorVersion() < 8 || player.getChannel() == null) {
            return;
        }
        if (!player.getChannel().pipeline().names().contains(this.injectPosition)) {
            return;
        }
        this.uninject(player);
        try {
            player.getChannel().pipeline().addBefore(this.injectPosition, "TAB", (ChannelHandler)this.getChannelFunction().apply(player));
        }
        catch (IllegalArgumentException | NoSuchElementException runtimeException) {
            // empty catch block
        }
    }

    public void uninject(TabPlayer player) {
        if (player.getVersion().getMinorVersion() < 8 || player.getChannel() == null) {
            return;
        }
        try {
            if (player.getChannel().pipeline().names().contains("TAB")) {
                player.getChannel().pipeline().remove("TAB");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public void load() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.inject(p);
        }
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.uninject(p);
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        this.inject(connectedPlayer);
    }

    protected void logTeamOverride(String team, String player, String expectedTeam) {
        String message = "Something just tried to add player " + player + " into team " + team + " (expected team: " + expectedTeam + ")";
        if (!message.equals(this.lastTeamOverrideMessage)) {
            this.lastTeamOverrideMessage = message;
            TAB.getInstance().getErrorManager().printError(message, (Throwable)null, false, TAB.getInstance().getErrorManager().getAntiOverrideLog());
        }
    }

    public void setByteBufDeserialization(boolean byteBufDeserialization) {
        this.byteBufDeserialization = byteBufDeserialization;
    }

    public abstract Function<TabPlayer, ChannelDuplexHandler> getChannelFunction();
}

