/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.Placeholder;
import me.neznamy.tab.api.placeholder.PlaceholderManager;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.api.placeholder.RelationalPlaceholder;
import me.neznamy.tab.api.placeholder.ServerPlaceholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.event.impl.TabPlaceholderRegisterEvent;
import me.neznamy.tab.shared.features.TabExpansion;
import me.neznamy.tab.shared.placeholders.PlayerPlaceholderImpl;
import me.neznamy.tab.shared.placeholders.RelationalPlaceholderImpl;
import me.neznamy.tab.shared.placeholders.ServerPlaceholderImpl;
import me.neznamy.tab.shared.placeholders.TabPlaceholder;

public class PlaceholderManagerImpl
extends TabFeature
implements PlaceholderManager {
    private final Pattern placeholderPattern = Pattern.compile("%([^%]*)%");
    private final int defaultRefresh = TAB.getInstance().getConfiguration().getConfig().getInt("placeholderapi-refresh-intervals.default-refresh-interval", 100);
    private final Map<String, Integer> serverPlaceholderRefreshIntervals = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("placeholderapi-refresh-intervals.server");
    private final Map<String, Integer> playerPlaceholderRefreshIntervals = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("placeholderapi-refresh-intervals.player");
    private final Map<String, Integer> relationalPlaceholderRefreshIntervals = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("placeholderapi-refresh-intervals.relational");
    private final Map<String, Placeholder> registeredPlaceholders = new HashMap<String, Placeholder>();
    private final Map<String, Set<TabFeature>> placeholderUsage = new ConcurrentHashMap<String, Set<TabFeature>>();
    private Placeholder[] usedPlaceholders = new Placeholder[0];
    private final AtomicInteger atomic = new AtomicInteger();
    private int refreshInterval = 10000;
    private Future<?> refreshTask = TAB.getInstance().getCPUManager().startRepeatingMeasuredTask(this.refreshInterval, this, "Refreshing placeholders", this::refresh);
    private TabExpansion tabExpansion;

    public PlaceholderManagerImpl() {
        super("Refreshing placeholders", "Updating placeholders");
    }

    private void refresh() {
        int loopTime = this.atomic.addAndGet(this.refreshInterval);
        int size = TAB.getInstance().getOnlinePlayers().length;
        HashMap<TabPlayer, Set<TabFeature>> update = new HashMap<TabPlayer, Set<TabFeature>>(size);
        HashMap<TabPlayer, Set<TabFeature>> forceUpdate = new HashMap<TabPlayer, Set<TabFeature>>(size);
        boolean somethingChanged = false;
        for (Placeholder placeholder : this.usedPlaceholders) {
            if (placeholder.getRefresh() == -1 || loopTime % placeholder.getRefresh() != 0) continue;
            if (placeholder instanceof RelationalPlaceholderImpl && this.updateRelationalPlaceholder((RelationalPlaceholderImpl)placeholder, forceUpdate)) {
                somethingChanged = true;
            }
            if (placeholder instanceof PlayerPlaceholderImpl && this.updatePlayerPlaceholder((PlayerPlaceholderImpl)placeholder, update)) {
                somethingChanged = true;
            }
            if (!(placeholder instanceof ServerPlaceholderImpl) || !this.updateServerPlaceholder((ServerPlaceholderImpl)placeholder, update)) continue;
            somethingChanged = true;
        }
        if (somethingChanged) {
            this.refresh(forceUpdate, update);
        }
    }

    private void refresh(Map<TabPlayer, Set<TabFeature>> forceUpdate, Map<TabPlayer, Set<TabFeature>> update) {
        long startTime;
        for (Map.Entry<TabPlayer, Set<TabFeature>> entry : update.entrySet()) {
            if (!forceUpdate.containsKey(entry.getKey())) continue;
            entry.getValue().removeAll((Collection)forceUpdate.get(entry.getKey()));
        }
        long startRefreshTime = System.nanoTime();
        for (Map.Entry<TabPlayer, Set<TabFeature>> entry : forceUpdate.entrySet()) {
            for (TabFeature r : entry.getValue()) {
                startTime = System.nanoTime();
                r.refresh(entry.getKey(), true);
                TAB.getInstance().getCPUManager().addTime(r.getFeatureName(), r.getRefreshDisplayName(), System.nanoTime() - startTime);
            }
        }
        for (Map.Entry<TabPlayer, Set<TabFeature>> entry : update.entrySet()) {
            for (TabFeature r : entry.getValue()) {
                startTime = System.nanoTime();
                r.refresh(entry.getKey(), false);
                TAB.getInstance().getCPUManager().addTime(r.getFeatureName(), r.getRefreshDisplayName(), System.nanoTime() - startTime);
            }
        }
        TAB.getInstance().getCPUManager().addTime(this.getFeatureName(), "Refreshing placeholders", startRefreshTime - System.nanoTime());
    }

    private boolean updateRelationalPlaceholder(RelationalPlaceholderImpl placeholder, Map<TabPlayer, Set<TabFeature>> forceUpdate) {
        boolean somethingChanged = false;
        long startTime = System.nanoTime();
        for (TabPlayer p1 : TAB.getInstance().getOnlinePlayers()) {
            for (TabPlayer p2 : TAB.getInstance().getOnlinePlayers()) {
                if (placeholder.update(p1, p2)) {
                    forceUpdate.computeIfAbsent(p2, x -> new HashSet()).addAll((Collection)this.placeholderUsage.get(placeholder.getIdentifier()));
                    somethingChanged = true;
                }
                if (!placeholder.update(p2, p1)) continue;
                forceUpdate.computeIfAbsent(p1, x -> new HashSet()).addAll((Collection)this.placeholderUsage.get(placeholder.getIdentifier()));
                somethingChanged = true;
            }
        }
        TAB.getInstance().getCPUManager().addPlaceholderTime(placeholder.getIdentifier(), System.nanoTime() - startTime);
        return somethingChanged;
    }

    private boolean updatePlayerPlaceholder(PlayerPlaceholderImpl placeholder, Map<TabPlayer, Set<TabFeature>> update) {
        boolean somethingChanged = false;
        long startTime = System.nanoTime();
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (!placeholder.update(all)) continue;
            if (placeholder.getIdentifier().equals("%vanished%")) {
                TAB.getInstance().getFeatureManager().onVanishStatusChange(all);
            }
            update.computeIfAbsent(all, k -> new HashSet()).addAll((Collection)this.placeholderUsage.get(placeholder.getIdentifier()));
            somethingChanged = true;
        }
        TAB.getInstance().getCPUManager().addPlaceholderTime(placeholder.getIdentifier(), System.nanoTime() - startTime);
        return somethingChanged;
    }

    private boolean updateServerPlaceholder(ServerPlaceholderImpl placeholder, Map<TabPlayer, Set<TabFeature>> update) {
        boolean somethingChanged = false;
        long startTime = System.nanoTime();
        if (placeholder.update()) {
            somethingChanged = true;
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                update.computeIfAbsent(all, k -> new HashSet()).addAll((Collection)this.placeholderUsage.get(placeholder.getIdentifier()));
            }
        }
        TAB.getInstance().getCPUManager().addPlaceholderTime(placeholder.getIdentifier(), System.nanoTime() - startTime);
        return somethingChanged;
    }

    public int getRelationalRefresh(String identifier) {
        return this.relationalPlaceholderRefreshIntervals.getOrDefault(identifier, this.defaultRefresh);
    }

    public Collection<Placeholder> getAllPlaceholders() {
        return new ArrayList<Placeholder>(this.registeredPlaceholders.values());
    }

    public Placeholder registerPlaceholder(Placeholder placeholder) {
        if (placeholder == null) {
            throw new IllegalArgumentException("Placeholder cannot be null");
        }
        boolean override = this.registeredPlaceholders.containsKey(placeholder.getIdentifier());
        this.registeredPlaceholders.put(placeholder.getIdentifier(), placeholder);
        this.recalculateUsedPlaceholders();
        if (override && this.placeholderUsage.containsKey(placeholder.getIdentifier())) {
            ((TabPlaceholder)placeholder).markAsUsed();
            for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                if (!p.isLoaded()) continue;
                this.placeholderUsage.get(placeholder.getIdentifier()).forEach(f -> f.refresh(p, true));
            }
        }
        return placeholder;
    }

    public Map<String, Integer> getServerPlaceholderRefreshIntervals() {
        return this.serverPlaceholderRefreshIntervals;
    }

    public Map<String, Integer> getPlayerPlaceholderRefreshIntervals() {
        return this.playerPlaceholderRefreshIntervals;
    }

    public int getDefaultRefresh() {
        return this.defaultRefresh;
    }

    @Override
    public void load() {
        for (Placeholder pl : this.usedPlaceholders) {
            if (!(pl instanceof ServerPlaceholderImpl)) continue;
            ((ServerPlaceholderImpl)pl).update();
        }
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
    }

    @Override
    public void unload() {
        this.registeredPlaceholders.values().forEach(Placeholder::unload);
    }

    @Override
    public ServerPlaceholder registerServerPlaceholder(String identifier, int refresh, Supplier<Object> supplier) {
        return (ServerPlaceholder)this.registerPlaceholder(new ServerPlaceholderImpl(identifier, refresh, supplier));
    }

    @Override
    public PlayerPlaceholder registerPlayerPlaceholder(String identifier, int refresh, Function<TabPlayer, Object> function) {
        return (PlayerPlaceholder)this.registerPlaceholder(new PlayerPlaceholderImpl(identifier, refresh, function));
    }

    @Override
    public RelationalPlaceholder registerRelationalPlaceholder(String identifier, int refresh, BiFunction<TabPlayer, TabPlayer, Object> function) {
        return (RelationalPlaceholder)this.registerPlaceholder(new RelationalPlaceholderImpl(identifier, refresh, function));
    }

    @Override
    public List<String> detectPlaceholders(String text) {
        if (text == null || !text.contains("%")) {
            return Collections.emptyList();
        }
        ArrayList<String> placeholders = new ArrayList<String>();
        Matcher m = this.placeholderPattern.matcher(text);
        while (m.find()) {
            placeholders.add(m.group());
        }
        return placeholders;
    }

    @Override
    public TabPlaceholder getPlaceholder(String identifier) {
        TabPlaceholder p = (TabPlaceholder)this.registeredPlaceholders.get(identifier);
        if (p == null) {
            TabPlaceholderRegisterEvent event = new TabPlaceholderRegisterEvent(identifier);
            if (TAB.getInstance().getEventBus() != null) {
                TAB.getInstance().getEventBus().fire(event);
            }
            if (event.getPlaceholder() != null) {
                this.registerPlaceholder(event.getPlaceholder());
            } else {
                TAB.getInstance().getPlatform().registerUnknownPlaceholder(identifier);
            }
            this.addUsedPlaceholder(identifier, this);
            return this.getPlaceholder(identifier);
        }
        if (!this.placeholderUsage.containsKey(identifier)) {
            this.addUsedPlaceholder(identifier, this);
        }
        return p;
    }

    @Override
    public void addUsedPlaceholder(String identifier, TabFeature feature) {
        if (this.placeholderUsage.computeIfAbsent(identifier, x -> new HashSet()).add(feature)) {
            int refresh;
            this.recalculateUsedPlaceholders();
            TabPlaceholder p = this.getPlaceholder(identifier);
            p.markAsUsed();
            if (this.tabExpansion != null) {
                for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                    this.tabExpansion.setPlaceholderValue(all, p.getIdentifier(), p.getLastValue(all));
                }
            }
            if (p.getRefresh() % 50 == 0 && p.getRefresh() > 0 && this.refreshInterval != (refresh = this.gcd(p.getRefresh(), this.refreshInterval))) {
                TAB.getInstance().debug("Decreasing refresh interval of placeholder refreshing task to " + refresh + "ms due to placeholder " + identifier);
                this.refreshTask.cancel(true);
                this.refreshInterval = refresh;
                this.refreshTask = TAB.getInstance().getCPUManager().startRepeatingMeasuredTask(this.refreshInterval, this, "Refreshing placeholders", this::refresh);
                this.atomic.set(0);
            }
        }
    }

    private int gcd(int a, int b) {
        return b == 0 ? a : this.gcd(b, a % b);
    }

    public void recalculateUsedPlaceholders() {
        this.usedPlaceholders = (Placeholder[])this.placeholderUsage.keySet().stream().map(this::getPlaceholder).distinct().toArray(Placeholder[]::new);
    }

    @Override
    public String findReplacement(String placeholder, String output) {
        return this.getPlaceholder(placeholder).getReplacements().findReplacement(output);
    }

    @Override
    public List<String> getUsedPlaceholders() {
        return Arrays.stream(this.usedPlaceholders).map(Placeholder::getIdentifier).collect(Collectors.toList());
    }

    public Map<String, Set<TabFeature>> getPlaceholderUsage() {
        return this.placeholderUsage;
    }

    public AtomicInteger getLoopTime() {
        return this.atomic;
    }

    public TabExpansion getTabExpansion() {
        return this.tabExpansion;
    }

    public void setTabExpansion(TabExpansion tabExpansion) {
        this.tabExpansion = tabExpansion;
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        if (this.tabExpansion == null) {
            return;
        }
        for (Placeholder p : this.usedPlaceholders) {
            if (!(p instanceof ServerPlaceholder)) continue;
            this.tabExpansion.setPlaceholderValue(connectedPlayer, p.getIdentifier(), ((ServerPlaceholder)p).getLastValue());
        }
    }
}

