/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.bossbar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import me.neznamy.tab.api.TabConstants;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.api.bossbar.BossBar;
import me.neznamy.tab.api.protocol.PacketPlayOutBoss;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.placeholders.conditions.Condition;

public class BossBarLine
implements BossBar {
    private final BossBarManagerImpl manager;
    private final String name;
    private final Condition displayCondition;
    private final UUID uuid = UUID.randomUUID();
    private String style;
    private String color;
    private String title;
    private String progress;
    private final boolean announcementOnly;
    private final Set<TabPlayer> players = Collections.newSetFromMap(new WeakHashMap());
    private final TabFeature textRefresher;
    private final TabFeature progressRefresher;
    private final TabFeature colorAndStyleRefresher;
    private final String propertyTitle;
    private final String propertyProgress;
    private final String propertyColor;
    private final String propertyStyle;

    public BossBarLine(BossBarManagerImpl manager, String name, String displayCondition, String color, String style, String title, String progress, boolean announcementOnly) {
        this.manager = manager;
        this.name = name;
        this.displayCondition = Condition.getCondition(displayCondition);
        if (this.displayCondition != null) {
            manager.addUsedPlaceholders(Collections.singletonList(TabConstants.Placeholder.condition(this.displayCondition.getName())));
        }
        this.color = color;
        this.style = style;
        this.title = title;
        this.progress = progress;
        this.announcementOnly = announcementOnly;
        this.propertyTitle = TabConstants.Property.bossbarTitle(name);
        this.propertyProgress = TabConstants.Property.bossbarProgress(name);
        this.propertyColor = TabConstants.Property.bossbarColor(name);
        this.propertyStyle = TabConstants.Property.bossbarStyle(name);
        this.textRefresher = new TabFeature(manager.getFeatureName(), "Updating text"){

            @Override
            public void refresh(TabPlayer refreshed, boolean force) {
                if (!BossBarLine.this.players.contains(refreshed)) {
                    return;
                }
                refreshed.sendCustomPacket((TabPacket)new PacketPlayOutBoss(BossBarLine.this.uuid, refreshed.getProperty(BossBarLine.this.propertyTitle).updateAndGet()), "BossBar (Text)");
            }
        };
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.bossBarTitle(name), this.textRefresher);
        this.progressRefresher = new TabFeature(manager.getFeatureName(), "Updating progress"){

            @Override
            public void refresh(TabPlayer refreshed, boolean force) {
                if (!BossBarLine.this.players.contains(refreshed)) {
                    return;
                }
                refreshed.sendCustomPacket((TabPacket)new PacketPlayOutBoss(BossBarLine.this.uuid, BossBarLine.this.parseProgress(refreshed.getProperty(BossBarLine.this.propertyProgress).updateAndGet()) / 100.0f), "BossBar (Progress)");
            }
        };
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.bossBarProgress(name), this.progressRefresher);
        this.colorAndStyleRefresher = new TabFeature(manager.getFeatureName(), "Updating color and style"){

            @Override
            public void refresh(TabPlayer refreshed, boolean force) {
                if (!BossBarLine.this.players.contains(refreshed)) {
                    return;
                }
                refreshed.sendCustomPacket((TabPacket)new PacketPlayOutBoss(BossBarLine.this.uuid, BossBarLine.this.parseColor(refreshed.getProperty(BossBarLine.this.propertyColor).updateAndGet()), BossBarLine.this.parseStyle(refreshed.getProperty(BossBarLine.this.propertyStyle).updateAndGet())), "BossBar (Color and style)");
            }
        };
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.bossBarColorStyle(name), this.colorAndStyleRefresher);
    }

    public boolean isConditionMet(TabPlayer p) {
        if (this.displayCondition == null) {
            return true;
        }
        return this.displayCondition.isMet(p);
    }

    public BarColor parseColor(String color) {
        try {
            return BarColor.valueOf(color);
        }
        catch (IllegalArgumentException e) {
            return BarColor.PURPLE;
        }
    }

    public BarStyle parseStyle(String style) {
        try {
            return BarStyle.valueOf(style);
        }
        catch (IllegalArgumentException e) {
            return BarStyle.PROGRESS;
        }
    }

    public float parseProgress(String progress) {
        return TAB.getInstance().getErrorManager().parseFloat(progress, 100.0f);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public void setTitle(String title) {
        if (this.title.equals(title)) {
            return;
        }
        this.title = title;
        for (TabPlayer p : this.players) {
            p.setProperty(this.textRefresher, this.propertyTitle, title);
            p.sendCustomPacket((TabPacket)new PacketPlayOutBoss(this.uuid, p.getProperty(this.propertyTitle).get()), this.manager);
        }
    }

    @Override
    public void setProgress(String progress) {
        if (this.progress.equals(progress)) {
            return;
        }
        this.progress = progress;
        for (TabPlayer p : this.players) {
            p.setProperty(this.progressRefresher, this.propertyProgress, progress);
            p.sendCustomPacket((TabPacket)new PacketPlayOutBoss(this.uuid, this.parseProgress(p.getProperty(this.propertyProgress).get()) / 100.0f), this.manager);
        }
    }

    @Override
    public void setProgress(float progress) {
        this.setProgress(String.valueOf(progress));
    }

    @Override
    public void setColor(String color) {
        if (this.color.equals(color)) {
            return;
        }
        this.color = color;
        for (TabPlayer p : this.players) {
            p.setProperty(this.colorAndStyleRefresher, this.propertyColor, color);
            p.sendCustomPacket((TabPacket)new PacketPlayOutBoss(this.uuid, this.parseColor(p.getProperty(this.propertyColor).get()), this.parseStyle(p.getProperty(this.propertyStyle).get())), this.manager);
        }
    }

    @Override
    public void setColor(BarColor color) {
        this.setColor(color.toString());
    }

    @Override
    public void setStyle(String style) {
        if (this.style.equals(style)) {
            return;
        }
        this.style = style;
        for (TabPlayer p : this.players) {
            p.setProperty(this.colorAndStyleRefresher, this.propertyStyle, style);
            p.sendCustomPacket((TabPacket)new PacketPlayOutBoss(this.uuid, this.parseColor(p.getProperty(this.propertyColor).get()), this.parseStyle(p.getProperty(this.propertyStyle).get())), this.manager);
        }
    }

    @Override
    public void setStyle(BarStyle style) {
        this.setStyle(style.toString());
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getProgress() {
        return this.progress;
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void addPlayer(TabPlayer player) {
        if (this.players.contains(player)) {
            return;
        }
        this.players.add(player);
        player.setProperty(this.textRefresher, this.propertyTitle, this.title);
        player.setProperty(this.progressRefresher, this.propertyProgress, this.progress);
        player.setProperty(this.colorAndStyleRefresher, this.propertyColor, this.color);
        player.setProperty(this.colorAndStyleRefresher, this.propertyStyle, this.style);
        player.sendCustomPacket((TabPacket)new PacketPlayOutBoss(this.uuid, player.getProperty(this.propertyTitle).updateAndGet(), this.parseProgress(player.getProperty(this.propertyProgress).updateAndGet()) / 100.0f, this.parseColor(player.getProperty(this.propertyColor).updateAndGet()), this.parseStyle(player.getProperty(this.propertyStyle).updateAndGet())), this.manager);
    }

    @Override
    public void removePlayer(TabPlayer player) {
        if (!this.players.contains(player)) {
            return;
        }
        this.players.remove(player);
        player.sendCustomPacket((TabPacket)new PacketPlayOutBoss(this.uuid), this.manager);
    }

    @Override
    public List<TabPlayer> getPlayers() {
        return new ArrayList<TabPlayer>(this.players);
    }

    @Override
    public boolean containsPlayer(TabPlayer player) {
        return this.players.contains(player);
    }

    @Override
    public boolean isAnnouncementBar() {
        return this.announcementOnly;
    }
}

