/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.bossbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.api.bossbar.BossBar;
import me.neznamy.tab.api.bossbar.BossBarManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.TabExpansion;
import me.neznamy.tab.shared.features.bossbar.BossBarLine;

public class BossBarManagerImpl
extends TabFeature
implements BossBarManager {
    private final List<String> defaultBars = new ArrayList<String>();
    private final Map<String, BossBar> lines = new HashMap<String, BossBar>();
    private BossBar[] lineValues;
    private final String toggleCommand = TAB.getInstance().getConfiguration().getConfig().getString("bossbar.toggle-command", "/bossbar");
    private final boolean hiddenByDefault = TAB.getInstance().getConfiguration().getConfig().getBoolean("bossbar.hidden-by-default", false);
    private final boolean rememberToggleChoice = TAB.getInstance().getConfiguration().getConfig().getBoolean("bossbar.remember-toggle-choice", false);
    private final String toggleOnMessage = TAB.getInstance().getConfiguration().getMessages().getBossBarOn();
    private final String toggleOffMessage = TAB.getInstance().getConfiguration().getMessages().getBossBarOff();
    private final List<BossBar> announcements = new ArrayList<BossBar>();
    private final List<String> bossBarOffPlayers;
    private long announceEndTime;
    private final Set<TabPlayer> visiblePlayers = Collections.newSetFromMap(new WeakHashMap());

    public BossBarManagerImpl() {
        super("BossBar", "Processing display conditions", "bossbar");
        for (Object bar : TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("bossbar.bars").keySet()) {
            BossBarLine line = this.loadFromConfig(bar.toString());
            this.lines.put(bar.toString(), line);
            if (line.isAnnouncementBar()) continue;
            this.defaultBars.add(bar.toString());
        }
        this.lineValues = this.lines.values().toArray(new BossBar[0]);
        this.bossBarOffPlayers = this.rememberToggleChoice ? TAB.getInstance().getConfiguration().getPlayerDataFile().getStringList("bossbar-off", new ArrayList<String>()) : Collections.emptyList();
        TAB.getInstance().getPlaceholderManager().registerServerPlaceholder("%countdown%", 100, () -> (this.announceEndTime - System.currentTimeMillis()) / 1000L);
        TAB.getInstance().debug(String.format("Loaded BossBar feature with parameters disabledWorlds=%s, disabledServers=%s, toggleCommand=%s, defaultBars=%s, hiddenByDefault=%s, remember_toggle_choice=%s", Arrays.toString(this.disabledWorlds), Arrays.toString(this.disabledServers), this.toggleCommand, this.defaultBars, this.hiddenByDefault, this.rememberToggleChoice));
    }

    private BossBarLine loadFromConfig(String bar) {
        Map bossBar = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("bossbar.bars." + bar);
        String condition = (String)bossBar.get("display-condition");
        String style = (String)bossBar.get("style");
        String color = (String)bossBar.get("color");
        String progress = String.valueOf(bossBar.get("progress"));
        String text = (String)bossBar.get("text");
        if (style == null) {
            TAB.getInstance().getErrorManager().missingAttribute(this.getFeatureName(), bar, "style");
            style = "PROGRESS";
        }
        if (color == null) {
            TAB.getInstance().getErrorManager().missingAttribute(this.getFeatureName(), bar, "color");
            color = "WHITE";
        }
        if (progress == null) {
            progress = "100";
            TAB.getInstance().getErrorManager().missingAttribute(this.getFeatureName(), bar, "progress");
        }
        if (text == null) {
            text = "";
            TAB.getInstance().getErrorManager().missingAttribute(this.getFeatureName(), bar, "text");
        }
        return new BossBarLine(this, bar, condition, color, style, text, progress, bossBar.getOrDefault("announcement-bar", false));
    }

    @Override
    public void load() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
    }

    @Override
    public void refresh(TabPlayer p, boolean force) {
        if (!this.hasBossBarVisible(p) || this.isDisabledPlayer(p)) {
            return;
        }
        for (BossBar line : this.lineValues) {
            line.removePlayer(p);
        }
        this.showBossBars(p, this.defaultBars);
    }

    @Override
    public void unload() {
        for (BossBar line : this.lineValues) {
            for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                line.removePlayer(p);
            }
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        if (this.isDisabled(connectedPlayer.getServer(), connectedPlayer.getWorld())) {
            this.addDisabledPlayer(connectedPlayer);
        }
        this.setBossBarVisible(connectedPlayer, this.hiddenByDefault == this.bossBarOffPlayers.contains(connectedPlayer.getName()), false);
    }

    @Override
    public void onServerChange(TabPlayer p, String from, String to) {
        this.onWorldChange(p, null, null);
    }

    @Override
    public void onWorldChange(TabPlayer p, String from, String to) {
        if (this.isDisabled(p.getServer(), p.getWorld())) {
            this.addDisabledPlayer(p);
        } else {
            this.removeDisabledPlayer(p);
        }
        for (BossBar line : this.lineValues) {
            line.removePlayer(p);
        }
        this.detectBossBarsAndSend(p);
    }

    @Override
    public boolean onCommand(TabPlayer sender, String message) {
        if (message.equalsIgnoreCase(this.toggleCommand)) {
            TAB.getInstance().getCommand().execute(sender, new String[]{"bossbar"});
            return true;
        }
        return false;
    }

    protected void detectBossBarsAndSend(TabPlayer p) {
        if (this.isDisabledPlayer(p) || !this.hasBossBarVisible(p)) {
            return;
        }
        this.showBossBars(p, this.defaultBars);
        this.showBossBars(p, this.announcements.stream().map(BossBar::getName).collect(Collectors.toList()));
    }

    private void showBossBars(TabPlayer p, List<String> bars) {
        if (bars == null) {
            return;
        }
        for (String defaultBar : bars) {
            BossBarLine bar = (BossBarLine)this.lines.get(defaultBar);
            if (!bar.isConditionMet(p) || bar.containsPlayer(p)) continue;
            bar.addPlayer(p);
        }
    }

    @Override
    public BossBar createBossBar(String title, float progress, BarColor color, BarStyle style) {
        return this.createBossBar(title, String.valueOf(progress), color.toString(), style.toString());
    }

    @Override
    public BossBar createBossBar(String title, String progress, String color, String style) {
        UUID id = UUID.randomUUID();
        BossBarLine bar = new BossBarLine(this, id.toString(), null, color, style, title, progress, true);
        this.lines.put(id.toString(), bar);
        this.lineValues = this.lines.values().toArray(new BossBar[0]);
        return bar;
    }

    @Override
    public BossBar getBossBar(String name) {
        return this.lines.get(name);
    }

    @Override
    public BossBar getBossBar(UUID id) {
        for (BossBar line : this.lineValues) {
            if (line.getUniqueId() != id) continue;
            return line;
        }
        return null;
    }

    @Override
    public void toggleBossBar(TabPlayer player, boolean sendToggleMessage) {
        this.setBossBarVisible(player, !this.hasBossBarVisible(player), sendToggleMessage);
    }

    @Override
    public Map<String, BossBar> getRegisteredBossBars() {
        return this.lines;
    }

    @Override
    public boolean hasBossBarVisible(TabPlayer player) {
        return this.visiblePlayers.contains(player);
    }

    @Override
    public void setBossBarVisible(TabPlayer player, boolean visible, boolean sendToggleMessage) {
        TabExpansion expansion;
        if (this.visiblePlayers.contains(player) == visible) {
            return;
        }
        if (visible) {
            this.visiblePlayers.add(player);
            this.detectBossBarsAndSend(player);
            if (sendToggleMessage) {
                player.sendMessage(this.toggleOnMessage, true);
            }
            if (this.rememberToggleChoice) {
                if (this.hiddenByDefault) {
                    if (!this.bossBarOffPlayers.contains(player.getName())) {
                        this.bossBarOffPlayers.add(player.getName());
                    }
                } else {
                    this.bossBarOffPlayers.remove(player.getName());
                }
                TAB.getInstance().getConfiguration().getPlayerDataFile().set("bossbar-off", new ArrayList<String>(this.bossBarOffPlayers));
            }
        } else {
            this.visiblePlayers.remove(player);
            for (BossBar l : this.lineValues) {
                l.removePlayer(player);
            }
            if (sendToggleMessage) {
                player.sendMessage(this.toggleOffMessage, true);
            }
            if (this.rememberToggleChoice) {
                if (this.hiddenByDefault) {
                    this.bossBarOffPlayers.remove(player.getName());
                } else if (!this.bossBarOffPlayers.contains(player.getName())) {
                    this.bossBarOffPlayers.add(player.getName());
                }
                TAB.getInstance().getConfiguration().getPlayerDataFile().set("bossbar-off", new ArrayList<String>(this.bossBarOffPlayers));
            }
        }
        if ((expansion = TAB.getInstance().getPlaceholderManager().getTabExpansion()) != null) {
            expansion.setBossBarVisible(player, visible);
        }
    }

    @Override
    public void sendBossBarTemporarily(TabPlayer player, String bossBar, int duration) {
        if (!this.hasBossBarVisible(player)) {
            return;
        }
        BossBar line = this.lines.get(bossBar);
        if (line == null) {
            throw new IllegalArgumentException("No registered BossBar found with name " + bossBar);
        }
        TAB.getInstance().getCPUManager().runTask(() -> line.addPlayer(player));
        TAB.getInstance().getCPUManager().runTaskLater(duration * 1000, this, "Removing temporary BossBar", () -> line.removePlayer(player));
    }

    @Override
    public void announceBossBar(String bossBar, int duration) {
        BossBar line = this.lines.get(bossBar);
        if (line == null) {
            throw new IllegalArgumentException("No registered BossBar found with name " + bossBar);
        }
        TAB.getInstance().getCPUManager().runTask(() -> {
            this.announcements.add(line);
            this.announceEndTime = System.currentTimeMillis() + (long)duration * 1000L;
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (!this.hasBossBarVisible(all) || !((BossBarLine)line).isConditionMet(all)) continue;
                line.addPlayer(all);
            }
        });
        TAB.getInstance().getCPUManager().runTaskLater(duration * 1000, this, "Removing announced BossBar", () -> {
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (!this.hasBossBarVisible(all)) continue;
                line.removePlayer(all);
            }
            this.announcements.remove(line);
        });
    }

    @Override
    public List<BossBar> getAnnouncedBossBars() {
        return this.announcements;
    }
}

