/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.sorting.types;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.sorting.Sorting;
import me.neznamy.tab.shared.features.sorting.types.SortingType;

public class Permissions
extends SortingType {
    private final LinkedHashMap<String, String> sortedGroups;

    public Permissions(Sorting sorting, String options) {
        this.sortedGroups = this.convertSortingElements(options.split(","));
        ArrayList<String> placeholders = new ArrayList<String>();
        for (String permission : this.sortedGroups.keySet()) {
            String placeholder = "%permission:" + permission + "%";
            placeholders.add(placeholder);
            TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder(placeholder, 1000, p -> p.hasPermission(permission));
        }
        sorting.addUsedPlaceholders(placeholders);
    }

    @Override
    public String getChars(ITabPlayer p) {
        String chars = null;
        for (String permission : this.sortedGroups.keySet()) {
            if (!p.hasPermission(permission)) continue;
            chars = this.sortedGroups.get(permission.toLowerCase());
            p.setTeamNameNote("Highest sorting permission: &e" + permission + " &a(#" + Integer.parseInt(chars) + " in list). &r");
            if (!p.hasPermission("tab.testpermission")) break;
            p.setTeamNameNote(p.getTeamNameNote() + "&cThis user appears to have all permissions. Is he OP? &r");
            break;
        }
        if (chars == null) {
            chars = String.valueOf(this.sortedGroups.size() + 1);
            p.setTeamNameNote(p.getTeamNameNote() + "&cPlayer does not have any of the defined permissions. &r");
        }
        return chars;
    }

    public String toString() {
        return "PERMISSIONS";
    }
}

