/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.permission;

import java.util.Optional;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.permission.PermissionPlugin;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;

public class LuckPerms
extends PermissionPlugin {
    private final String UPDATE_MESSAGE = "Upgrade to LuckPerms 5";

    public LuckPerms(String version) {
        super(version);
    }

    @Override
    public String getPrimaryGroup(TabPlayer p) {
        try {
            if (this.getVersion().startsWith("4")) {
                return "Upgrade to LuckPerms 5";
            }
            net.luckperms.api.LuckPerms api = LuckPermsProvider.get();
            User user = api.getUserManager().getUser(p.getUniqueId());
            if (user == null) {
                return "NONE";
            }
            return user.getPrimaryGroup();
        }
        catch (Exception e) {
            return "NONE";
        }
    }

    public String getPrefix(TabPlayer p) {
        return this.getValue(p, true);
    }

    public String getSuffix(TabPlayer p) {
        return this.getValue(p, false);
    }

    private String getValue(TabPlayer p, boolean prefix) {
        try {
            if (this.getVersion().startsWith("4")) {
                return "Upgrade to LuckPerms 5";
            }
            net.luckperms.api.LuckPerms api = LuckPermsProvider.get();
            User user = api.getUserManager().getUser(p.getUniqueId());
            if (user == null) {
                return "";
            }
            Optional options = LuckPermsProvider.get().getContextManager().getQueryOptions(user);
            if (!options.isPresent()) {
                return "";
            }
            CachedMetaData data = user.getCachedData().getMetaData((QueryOptions)options.get());
            String value = prefix ? data.getPrefix() : data.getSuffix();
            return value == null ? "" : value;
        }
        catch (Exception e) {
            return "";
        }
    }
}

