/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.placeholder.RelationalPlaceholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.TabPlaceholder;

public class RelationalPlaceholderImpl
extends TabPlaceholder
implements RelationalPlaceholder {
    private final BiFunction<TabPlayer, TabPlayer, Object> function;
    private final WeakHashMap<TabPlayer, WeakHashMap<TabPlayer, String>> lastValues = new WeakHashMap();

    public RelationalPlaceholderImpl(String identifier, int refresh, BiFunction<TabPlayer, TabPlayer, Object> function) {
        super(identifier, refresh);
        if (!identifier.startsWith("%rel_")) {
            throw new IllegalArgumentException("Relational placeholder identifiers must start with \"rel_\"");
        }
        this.function = function;
    }

    public boolean update(TabPlayer viewer, TabPlayer target) {
        Object output = this.request(viewer, target);
        if (output == null) {
            return false;
        }
        String newValue = this.getReplacements().findReplacement(String.valueOf(output));
        if (!this.lastValues.computeIfAbsent(viewer, v -> new WeakHashMap()).containsKey(target) || !this.lastValues.get(viewer).get(target).equals(newValue)) {
            this.lastValues.get(viewer).put(target, newValue);
            this.updateParents(viewer);
            this.updateParents(target);
            return true;
        }
        return false;
    }

    private void updateValue(TabPlayer viewer, TabPlayer target, Object value, boolean force) {
        String s = this.getReplacements().findReplacement(String.valueOf(value));
        if (this.lastValues.computeIfAbsent(viewer, v -> new WeakHashMap()).containsKey(target) && this.lastValues.get(viewer).get(target).equals(s) && !force) {
            return;
        }
        this.lastValues.get(viewer).put(target, s);
        Set<TabFeature> usage = TAB.getInstance().getPlaceholderManager().getPlaceholderUsage().get(this.identifier);
        if (usage == null) {
            return;
        }
        for (TabFeature f : usage) {
            long time = System.nanoTime();
            f.refresh(viewer, true);
            f.refresh(target, true);
            TAB.getInstance().getCPUManager().addTime(f.getFeatureName(), f.getRefreshDisplayName(), System.nanoTime() - time);
        }
        this.updateParents(viewer);
        this.updateParents(target);
    }

    @Override
    public void updateValue(TabPlayer viewer, TabPlayer target, Object value) {
        this.updateValue(viewer, target, value, false);
    }

    @Override
    public String getLastValue(TabPlayer viewer, TabPlayer target) {
        if (!this.lastValues.computeIfAbsent(viewer, v -> new WeakHashMap()).containsKey(target)) {
            this.update(viewer, target);
        }
        return this.setPlaceholders(this.replacements.findReplacement(EnumChatFormat.color((String)this.lastValues.computeIfAbsent(viewer, v -> new WeakHashMap()).get(target))), target);
    }

    @Override
    public String getLastValue(TabPlayer p) {
        return this.identifier;
    }

    @Override
    public void updateFromNested(TabPlayer player) {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.updateValue(player, all, this.request(player, all), true);
        }
    }

    @Override
    public Object request(TabPlayer viewer, TabPlayer target) {
        try {
            return this.function.apply(viewer, target);
        }
        catch (Throwable t) {
            TAB.getInstance().getErrorManager().placeholderError("Relational placeholder " + this.identifier + " generated an error when setting for players " + viewer.getName() + " and " + target.getName(), t);
            return "ERROR";
        }
    }
}

