/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.util.Set;
import java.util.function.Supplier;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.ServerPlaceholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.TabPlaceholder;

public class ServerPlaceholderImpl
extends TabPlaceholder
implements ServerPlaceholder {
    private final Supplier<Object> supplier;
    private String lastValue;

    public ServerPlaceholderImpl(String identifier, int refresh, Supplier<Object> supplier) {
        super(identifier, refresh);
        if (identifier.startsWith("%rel_")) {
            throw new IllegalArgumentException("\"rel_\" is reserved for relational placeholder identifiers");
        }
        this.supplier = supplier;
        this.update();
    }

    public boolean update() {
        String newValue;
        String obj = this.getReplacements().findReplacement(String.valueOf(this.request()));
        String string = newValue = obj == null ? this.identifier : this.setPlaceholders(obj, null);
        if (this.identifier.equals(newValue) && this.lastValue == null) {
            this.lastValue = this.identifier;
        }
        if (!("ERROR".equals(newValue) || this.identifier.equals(newValue) || this.lastValue != null && this.lastValue.equals(newValue))) {
            this.lastValue = newValue;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                this.updateParents(player);
                if (TAB.getInstance().getPlaceholderManager().getTabExpansion() == null) continue;
                TAB.getInstance().getPlaceholderManager().getTabExpansion().setPlaceholderValue(player, this.identifier, newValue);
            }
            return true;
        }
        return false;
    }

    private void updateValue(Object value, boolean force) {
        String s = this.getReplacements().findReplacement(value == null ? (this.lastValue == null ? this.identifier : this.lastValue) : value.toString());
        if (s.equals(this.lastValue) && !force) {
            return;
        }
        this.lastValue = s;
        Set<TabFeature> usage = TAB.getInstance().getPlaceholderManager().getPlaceholderUsage().get(this.identifier);
        if (usage == null) {
            return;
        }
        for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
            for (TabFeature f : usage) {
                long time = System.nanoTime();
                f.refresh(player, false);
                TAB.getInstance().getCPUManager().addTime(f.getFeatureName(), f.getRefreshDisplayName(), System.nanoTime() - time);
            }
            this.updateParents(player);
            if (TAB.getInstance().getPlaceholderManager().getTabExpansion() == null) continue;
            TAB.getInstance().getPlaceholderManager().getTabExpansion().setPlaceholderValue(player, this.identifier, s);
        }
    }

    @Override
    public void updateValue(Object value) {
        this.updateValue(value, false);
    }

    @Override
    public void updateFromNested(TabPlayer player) {
        this.updateValue(this.request(), true);
    }

    @Override
    public String getLastValue(TabPlayer p) {
        return this.lastValue;
    }

    @Override
    public String getLastValue() {
        return this.lastValue;
    }

    @Override
    public Object request() {
        try {
            return this.supplier.get();
        }
        catch (Throwable t) {
            TAB.getInstance().getErrorManager().placeholderError("Server placeholder " + this.identifier + " generated an error", t);
            return "ERROR";
        }
    }
}

