/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.residence.LocaleManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class select
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=1300)
    public Boolean perform(Residence plugin, CommandSender sender, String[] args, boolean resadmin2) {
        Player player;
        block80: {
            block78: {
                if (!(sender instanceof Player)) {
                    return false;
                }
                player = (Player)sender;
                ResidencePlayer rPlayer = plugin.getPlayerManager().getResidencePlayer(player);
                PermissionGroup group = rPlayer.getGroup();
                if (!group.selectCommandAccess() && !resadmin2) {
                    plugin.msg((CommandSender)player, lm.Select_Disabled, new Object[0]);
                    return true;
                }
                if (!group.canCreateResidences() && rPlayer.getMaxSubzones() <= 0 && !resadmin2) {
                    plugin.msg((CommandSender)player, lm.Select_Disabled, new Object[0]);
                    return true;
                }
                if (!(PermissionManager.ResPerm.create.hasPermission((CommandSender)player) || PermissionManager.ResPerm.select.hasPermission((CommandSender)player) || resadmin2)) {
                    plugin.msg((CommandSender)player, lm.Select_Disabled, new Object[0]);
                    return true;
                }
                if (args.length != 1) break block78;
                switch (args[0].toLowerCase()) {
                    case "cost": 
                    case "size": {
                        if (plugin.getSelectionManager().hasPlacedBoth(player) || plugin.getSelectionManager().worldEdit(player)) {
                            try {
                                plugin.getSelectionManager().showSelectionInfo(player);
                                return true;
                            }
                            catch (Exception ex) {
                                Logger.getLogger(Residence.class.getName()).log(Level.SEVERE, null, ex);
                                return true;
                            }
                        }
                        return false;
                    }
                    case "vert": {
                        plugin.getSelectionManager().vert(player, resadmin2);
                        plugin.getSelectionManager().afterSelectionUpdate(player, true);
                        return true;
                    }
                    case "sky": {
                        plugin.getSelectionManager().sky(player, resadmin2);
                        plugin.getSelectionManager().afterSelectionUpdate(player, true);
                        return true;
                    }
                    case "bedrock": {
                        plugin.getSelectionManager().bedrock(player, resadmin2);
                        plugin.getSelectionManager().afterSelectionUpdate(player, true);
                        return true;
                    }
                    case "coords": {
                        Location playerLoc2;
                        plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
                        if (!plugin.getSelectionManager().hasPlacedBoth(player)) {
                            plugin.msg((CommandSender)player, lm.Select_Points, new Object[0]);
                            return true;
                        }
                        Location playerLoc1 = plugin.getSelectionManager().getPlayerLoc1(player);
                        if (playerLoc1 != null) {
                            plugin.msg((CommandSender)player, lm.Select_Primary, plugin.msg(lm.General_CoordsTop, playerLoc1.getBlockX(), playerLoc1.getBlockY(), playerLoc1.getBlockZ()));
                        }
                        if ((playerLoc2 = plugin.getSelectionManager().getPlayerLoc2(player)) != null) {
                            plugin.msg((CommandSender)player, lm.Select_Secondary, plugin.msg(lm.General_CoordsBottom, playerLoc2.getBlockX(), playerLoc2.getBlockY(), playerLoc2.getBlockZ()));
                        }
                        plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
                        plugin.getSelectionManager().afterSelectionUpdate(player, false);
                        return true;
                    }
                    case "chunk": {
                        plugin.getSelectionManager().getSelection(player).selectChunk();
                        plugin.getSelectionManager().afterSelectionUpdate(player, true);
                        return true;
                    }
                    case "worldedit": {
                        if (plugin.getSelectionManager().worldEdit(player)) {
                            plugin.msg((CommandSender)player, lm.Select_Success, new Object[0]);
                            plugin.getSelectionManager().afterSelectionUpdate(player, false);
                        }
                        return true;
                    }
                }
                break block80;
            }
            if (args.length != 2) break block80;
            int amount = 0;
            switch (args[0].toLowerCase()) {
                case "expand": 
                case "contract": 
                case "shift": {
                    try {
                        amount = Integer.parseInt(args[1]);
                        break;
                    }
                    catch (Exception ex) {
                        plugin.msg((CommandSender)player, lm.Invalid_Amount, new Object[0]);
                        return true;
                    }
                }
            }
            switch (args[0].toLowerCase()) {
                case "expand": {
                    plugin.getSelectionManager().modify(player, false, amount);
                    return true;
                }
                case "contract": {
                    plugin.getSelectionManager().contract(player, amount);
                    return true;
                }
                case "shift": {
                    if (amount > 100) {
                        amount = 100;
                    }
                    if (amount < -100) {
                        amount = -100;
                    }
                    plugin.getSelectionManager().modify(player, true, amount);
                    return true;
                }
            }
        }
        if ((args.length == 1 || args.length == 2) && args[0].equals("auto")) {
            Player target = player;
            if (args.length == 2) {
                if (!PermissionManager.ResPerm.select_auto_others.hasPermission((CommandSender)player, true, new String[0])) {
                    return true;
                }
                target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    plugin.msg((CommandSender)player, lm.General_NotOnline, new Object[0]);
                    return true;
                }
            }
            plugin.getSelectionManager().clearSelection(target);
            plugin.getSelectionManager().placeLoc1(player, player.getLocation().clone(), false);
            plugin.getSelectionManager().placeLoc2(player, player.getLocation().clone().add(0.0, 1.0, 0.0), true);
            plugin.getAutoSelectionManager().switchAutoSelection(target);
            return true;
        }
        if (args.length > 0 && args[0].equals("residence")) {
            String areaName;
            ClaimedResidence res = null;
            res = args.length > 1 ? plugin.getResidenceManager().getByName(args[1]) : plugin.getResidenceManager().getByLoc(player.getLocation());
            if (res == null) {
                plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                return true;
            }
            String resName = res.getName();
            CuboidArea area2 = null;
            if (args.length > 2) {
                area2 = res.getArea(args[2]);
                areaName = args[2];
            } else {
                areaName = res.getAreaIDbyLoc(player.getLocation());
                area2 = res.getArea(areaName);
            }
            if (area2 != null) {
                plugin.getSelectionManager().placeLoc1(player, area2.getHighLocation(), false);
                plugin.getSelectionManager().placeLoc2(player, area2.getLowLocation(), true);
                plugin.msg((CommandSender)player, lm.Select_Area, areaName, resName);
            } else {
                plugin.msg((CommandSender)player, lm.Area_NonExist, new Object[0]);
            }
            return true;
        }
        try {
            plugin.getSelectionManager().selectBySize(player, Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2]));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void getLocale() {
        ConfigReader c = Residence.getInstance().getLocaleManager().getLocaleConfig();
        c.get("Description", "Selection Commands");
        c.get("Info", Arrays.asList("This command selects areas for usage with residence.", "/res select [x] [y] [z] - selects a radius of blocks, with you in the middle."));
        LocaleManager.addTabCompleteSub(this, "[x]", "[y]", "[z]");
        c.setFullPath(String.valueOf(c.getPath()) + "SubCommands.");
        c.get("coords.Description", "Display selected coordinates");
        c.get("coords.Info", Arrays.asList("&eUsage: &6/res select coords"));
        LocaleManager.addTabCompleteSub(this, "coords", new String[0]);
        c.get("size.Description", "Display selected size");
        c.get("size.Info", Arrays.asList("&eUsage: &6/res select size"));
        LocaleManager.addTabCompleteSub(this, "size", new String[0]);
        c.get("auto.Description", "Turns on auto selection tool");
        c.get("auto.Info", Arrays.asList("&eUsage: &6/res select auto [playername]"));
        LocaleManager.addTabCompleteSub(this, "auto", "[playername]");
        c.get("cost.Description", "Display selection cost");
        c.get("cost.Info", Arrays.asList("&eUsage: &6/res select cost"));
        LocaleManager.addTabCompleteSub(this, "cost", new String[0]);
        c.get("vert.Description", "Expand Selection Vertically");
        c.get("vert.Info", Arrays.asList("&eUsage: &6/res select vert", "Will expand selection as high and as low as allowed."));
        LocaleManager.addTabCompleteSub(this, "vert", new String[0]);
        c.get("sky.Description", "Expand Selection to Sky");
        c.get("sky.Info", Arrays.asList("&eUsage: &6/res select sky", "Expands as high as your allowed to go."));
        LocaleManager.addTabCompleteSub(this, "sky", new String[0]);
        c.get("bedrock.Description", "Expand Selection to Bedrock");
        c.get("bedrock.Info", Arrays.asList("&eUsage: &6/res select bedrock", "Expands as low as your allowed to go."));
        LocaleManager.addTabCompleteSub(this, "bedrock", new String[0]);
        c.get("expand.Description", "Expand selection in a direction.");
        c.get("expand.Info", Arrays.asList("&eUsage: &6/res select expand <amount>", "Expands <amount> in the direction your looking."));
        LocaleManager.addTabCompleteSub(this, "expand", "5");
        c.get("shift.Description", "Shift selection in a direction");
        c.get("shift.Info", Arrays.asList("&eUsage: &6/res select shift <amount>", "Pushes your selection by <amount> in the direction your looking."));
        LocaleManager.addTabCompleteSub(this, "shift", "5");
        c.get("chunk.Description", "Select the chunk your currently in.");
        c.get("chunk.Info", Arrays.asList("&eUsage: &6/res select chunk", "Selects the chunk your currently standing in."));
        LocaleManager.addTabCompleteSub(this, "chunk", new String[0]);
        c.get("residence.Description", "Select a existing area in a residence.");
        c.get("residence.Info", Arrays.asList("&eUsage: &6/res select residence <residence>", "Selects a existing area in a residence."));
        LocaleManager.addTabCompleteSub(this, "residence", "[residence]");
        c.get("worldedit.Description", "Set selection using the current WorldEdit selection.");
        c.get("worldedit.Info", Arrays.asList("&eUsage: &6/res select worldedit", "Sets selection area using the current WorldEdit selection."));
        LocaleManager.addTabCompleteSub(this, "worldedit", new String[0]);
    }
}

