/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.containers;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerGroup {
    ResidencePlayer resPlayer;
    long lastCheck = 0L;
    HashMap<String, PermissionGroup> groups = new HashMap();

    public PlayerGroup(ResidencePlayer resPlayer) {
        this.resPlayer = resPlayer;
        Player player = resPlayer.getPlayer();
        if (player != null) {
            this.updateGroup(player.getWorld().getName(), true);
        }
    }

    public void setLastCkeck(Long time) {
        this.lastCheck = time;
    }

    public void addGroup(String world, PermissionGroup group) {
        this.groups.put(world, group);
    }

    public PermissionGroup getGroup(String world) {
        this.updateGroup(world, false);
        return this.groups.get(world);
    }

    public void updateGroup(String world, boolean force) {
        PermissionGroup g;
        String group;
        if (!force && this.lastCheck != 0L && System.currentTimeMillis() - this.lastCheck < 60000L) {
            return;
        }
        this.lastCheck = System.currentTimeMillis();
        ArrayList<PermissionGroup> posibleGroups = new ArrayList<PermissionGroup>();
        if (Residence.getInstance().getPermissionManager().getPlayersGroups().containsKey(this.resPlayer.getName().toLowerCase()) && (group = Residence.getInstance().getPermissionManager().getPlayersGroups().get(this.resPlayer.getName().toLowerCase())) != null && (group = group.toLowerCase()) != null && Residence.getInstance().getPermissionManager().getGroups().containsKey(group)) {
            g = Residence.getInstance().getPermissionManager().getGroups().get(group);
            posibleGroups.add(g);
            this.groups.put(world, g);
        }
        posibleGroups.add(this.getPermissionGroup());
        group = Residence.getInstance().getPermissionManager().getPermissionsGroup(this.resPlayer.getName(), world);
        g = Residence.getInstance().getPermissionManager().getGroupByName(group);
        if (g != null) {
            posibleGroups.add(g);
        }
        PermissionGroup finalGroup = null;
        if (posibleGroups.size() == 1) {
            finalGroup = (PermissionGroup)posibleGroups.get(0);
        }
        int i = 0;
        while (i < posibleGroups.size()) {
            if (finalGroup == null) {
                finalGroup = (PermissionGroup)posibleGroups.get(i);
            } else if (finalGroup.getPriority() < ((PermissionGroup)posibleGroups.get(i)).getPriority()) {
                finalGroup = (PermissionGroup)posibleGroups.get(i);
            }
            ++i;
        }
        if (finalGroup == null || !Residence.getInstance().getPermissionManager().getGroups().containsValue(finalGroup)) {
            this.groups.put(world, Residence.getInstance().getPermissionManager().getDefaultGroup());
        } else {
            this.groups.put(world, finalGroup);
        }
    }

    private PermissionGroup getPermissionGroup() {
        Player player = this.resPlayer.getPlayer();
        PermissionGroup group = Residence.getInstance().getPermissionManager().getDefaultGroup();
        for (Map.Entry<String, PermissionGroup> one : Residence.getInstance().getPermissionManager().getGroups().entrySet()) {
            if (player != null) {
                if (!PermissionManager.ResPerm.group_$1.hasPermission((CommandSender)player, one.getKey())) continue;
                group = one.getValue();
                continue;
            }
            OfflinePlayer offlineP = Residence.getInstance().getOfflinePlayer(this.resPlayer.getName());
            if (offlineP == null || !Residence.getInstance().getPermissionManager().getPermissionsPlugin().hasPermission(offlineP, PermissionManager.ResPerm.group_$1.getPermission(one.getKey()), Residence.getInstance().getConfigManager().getDefaultWorld())) continue;
            group = one.getValue();
        }
        return group;
    }
}

