/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.containers;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.PlayerGroup;
import com.bekvon.bukkit.residence.listeners.ResidenceBlockListener;
import com.bekvon.bukkit.residence.listeners.ResidenceEntityListener;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.raid.ResidenceRaid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ResidencePlayer {
    private String userName = null;
    private Player player = null;
    private OfflinePlayer ofPlayer = null;
    private UUID uuid = null;
    private Set<ClaimedResidence> ResidenceList = new HashSet<ClaimedResidence>();
    private Set<ClaimedResidence> trustedList = new HashSet<ClaimedResidence>();
    private ClaimedResidence mainResidence = null;
    private PlayerGroup groups = null;
    private int maxRes = -1;
    private int maxRents = -1;
    private int maxSubzones = -1;
    private int maxSubzoneDepth = -1;
    private int maxX = -1;
    private int maxZ = -1;
    private static final int maxValue = 9999;
    private Long lastRaidAttackTimer = 0L;
    private Long lastRaidDefendTimer = 0L;
    private ResidenceRaid raid = null;
    private boolean updated = false;

    public ResidencePlayer(OfflinePlayer off) {
        if (off == null) {
            return;
        }
        this.uuid = off.getUniqueId();
        this.userName = off.getName();
        Residence.getInstance().addOfflinePlayerToChache(off);
        this.updatePlayer();
    }

    public ResidencePlayer(Player player) {
        if (player == null) {
            return;
        }
        Residence.getInstance().addOfflinePlayerToChache((OfflinePlayer)player);
        this.updatePlayer(player);
    }

    public boolean isOnline() {
        return this.player != null && this.player.isOnline() || Bukkit.getPlayer((UUID)this.uuid) != null;
    }

    public ResidencePlayer(String userName, UUID uuid) {
        this.userName = userName;
        this.uuid = uuid;
    }

    public ResidencePlayer(String userName) {
        this.userName = userName;
    }

    public void setMainResidence(ClaimedResidence res) {
        if (this.mainResidence != null) {
            this.mainResidence.setMainResidence(false);
        }
        this.mainResidence = res;
    }

    public ClaimedResidence getMainResidence() {
        if (this.mainResidence == null || !this.mainResidence.isOwner(this.getPlayerName())) {
            for (ClaimedResidence claimedResidence : this.ResidenceList) {
                if (claimedResidence == null || !claimedResidence.isMainResidence()) continue;
                this.mainResidence = claimedResidence;
                return this.mainResidence;
            }
            for (String string : Residence.getInstance().getRentManager().getRentedLands(this.userName)) {
                ClaimedResidence res = Residence.getInstance().getResidenceManager().getByName(string);
                if (res == null) continue;
                this.mainResidence = res;
                return this.mainResidence;
            }
            for (ClaimedResidence claimedResidence : this.ResidenceList) {
                if (claimedResidence == null) continue;
                this.mainResidence = claimedResidence;
                return this.mainResidence;
            }
        }
        return this.mainResidence;
    }

    public void recountMaxX() {
        int m = this.getGroup().getMaxX();
        m = m == -1 ? this.maxX : m;
        this.maxX = Residence.getInstance().getPermissionManager().getPermissionInfo(this.getUniqueId(), PermissionManager.ResPerm.max_res_x_$1).getMaxValue(m);
    }

    public void recountMaxZ() {
        int m = this.getGroup().getMaxZ();
        m = m == -1 ? this.maxZ : m;
        this.maxZ = Residence.getInstance().getPermissionManager().getPermissionInfo(this.getUniqueId(), PermissionManager.ResPerm.max_res_z_$1).getMaxValue(m);
    }

    public void recountMaxRes() {
        int m;
        if (this.player != null && this.player.isOnline()) {
            if (PermissionManager.ResPerm.max_res_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxRes = 9999;
                return;
            }
        } else if (this.ofPlayer != null && Residence.getInstance().getPermissionManager().getPermissionsPlugin().hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_res_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxRes = 9999;
            return;
        }
        m = (m = this.getGroup().getMaxZones()) == -1 ? 9999 : m;
        this.maxRes = Residence.getInstance().getPermissionManager().getPermissionInfo(this.getUniqueId(), PermissionManager.ResPerm.max_res_$1).getMaxValue(m);
    }

    public void recountMaxRents() {
        int m;
        if (this.player != null) {
            if (PermissionManager.ResPerm.max_rents_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxRents = 9999;
                return;
            }
        } else if (this.ofPlayer != null && Residence.getInstance().getPermissionManager().getPermissionsPlugin().hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_rents_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxRents = 9999;
            return;
        }
        m = (m = this.getGroup().getMaxRents()) == -1 ? 9999 : m;
        this.maxRents = Residence.getInstance().getPermissionManager().getPermissionInfo(this.getUniqueId(), PermissionManager.ResPerm.max_rents_$1).getMaxValue(m);
    }

    public int getMaxRents() {
        this.recountMaxRents();
        return this.maxRents;
    }

    public void recountMaxSubzones() {
        int m;
        if (this.player != null) {
            if (PermissionManager.ResPerm.max_subzones_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxSubzones = 9999;
                return;
            }
        } else if (this.ofPlayer != null && Residence.getInstance().getPermissionManager().getPermissionsPlugin().hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_subzones_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxSubzones = 9999;
            return;
        }
        m = (m = this.getGroup().getMaxSubzones()) == -1 ? 9999 : m;
        this.maxSubzones = Residence.getInstance().getPermissionManager().getPermissionInfo(this.getUniqueId(), PermissionManager.ResPerm.max_subzones_$1).getMaxValue(m);
    }

    public int getMaxSubzones() {
        this.recountMaxSubzones();
        return this.maxSubzones;
    }

    public void recountMaxSubzoneDepth() {
        int m;
        if (this.player != null) {
            if (PermissionManager.ResPerm.max_subzonedepth_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxSubzoneDepth = 9999;
                return;
            }
        } else if (this.ofPlayer != null && Residence.getInstance().getPermissionManager().getPermissionsPlugin().hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_subzonedepth_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxSubzoneDepth = 9999;
            return;
        }
        m = (m = this.getGroup().getMaxSubzoneDepth()) == -1 ? 9999 : m;
        this.maxSubzoneDepth = Residence.getInstance().getPermissionManager().getPermissionInfo(this.getUniqueId(), PermissionManager.ResPerm.max_subzonedepth_$1).getMaxValue(m);
    }

    public int getMaxSubzoneDepth() {
        this.recountMaxSubzoneDepth();
        return this.maxSubzoneDepth;
    }

    public int getMaxRes() {
        this.recountMaxRes();
        PermissionGroup g = this.getGroup();
        if (this.maxRes < g.getMaxZones()) {
            return g.getMaxZones();
        }
        return this.maxRes;
    }

    public int getMaxX() {
        this.recountMaxX();
        PermissionGroup g = this.getGroup();
        if (this.maxX < g.getMaxX()) {
            return g.getMaxX();
        }
        return this.maxX;
    }

    public int getMaxZ() {
        this.recountMaxZ();
        PermissionGroup g = this.getGroup();
        if (this.maxZ < g.getMaxZ()) {
            return g.getMaxZ();
        }
        return this.maxZ;
    }

    public PermissionGroup getGroup() {
        return this.getGroup(false);
    }

    public PermissionGroup forceUpdateGroup() {
        return this.getGroup(this.player != null ? this.player.getWorld().getName() : Residence.getInstance().getConfigManager().getDefaultWorld(), true);
    }

    public PermissionGroup getGroup(boolean forceUpdate) {
        this.updatePlayer();
        return this.getGroup(this.player != null ? this.player.getWorld().getName() : Residence.getInstance().getConfigManager().getDefaultWorld(), forceUpdate);
    }

    public PermissionGroup getGroup(String world) {
        return this.getGroup(world, false);
    }

    public PermissionGroup getGroup(String world, boolean force) {
        if (this.groups == null) {
            this.groups = new PlayerGroup(this);
        }
        this.groups.updateGroup(world, force);
        PermissionGroup group = this.groups.getGroup(world);
        if (group == null) {
            group = Residence.getInstance().getPermissionManager().getDefaultGroup();
        }
        return group;
    }

    public ResidencePlayer updatePlayer(Player player) {
        if (this.updated) {
            return this;
        }
        if (player.isOnline()) {
            this.updated = true;
        }
        this.player = player;
        this.uuid = player.getUniqueId();
        this.userName = player.getName();
        this.ofPlayer = player;
        return this;
    }

    public void onQuit() {
        this.ofPlayer = null;
        this.player = null;
        this.updated = false;
    }

    private void updatePlayer() {
        if (this.uuid != null) {
            this.player = Bukkit.getPlayer((UUID)this.uuid);
        }
        if (this.player != null) {
            this.updatePlayer(this.player);
        }
        if (this.player != null && this.player.isOnline()) {
            return;
        }
        if (this.uuid != null && Bukkit.getPlayer((UUID)this.uuid) != null) {
            this.player = Bukkit.getPlayer((UUID)this.uuid);
            this.userName = this.player.getName();
            return;
        }
        if (this.userName != null) {
            this.player = Bukkit.getPlayer((String)this.userName);
        }
        if (this.player != null) {
            this.userName = this.player.getName();
            this.uuid = this.player.getUniqueId();
            this.ofPlayer = this.player;
            return;
        }
        if (this.player == null && this.ofPlayer == null) {
            this.ofPlayer = Residence.getInstance().getOfflinePlayer(this.userName);
        }
        if (this.ofPlayer != null) {
            this.userName = Residence.getInstance().getPlayerName(this.uuid);
            this.uuid = this.ofPlayer.getUniqueId();
            return;
        }
    }

    public void addResidence(ClaimedResidence residence) {
        if (residence == null) {
            return;
        }
        if (residence.isSubzone()) {
            return;
        }
        residence.getPermissions().setOwnerUUID(this.uuid);
        if (this.userName != null) {
            residence.getPermissions().setOwnerLastKnownName(this.userName);
        }
        this.ResidenceList.add(residence);
    }

    public void removeResidence(ClaimedResidence residence) {
        if (residence == null) {
            return;
        }
        boolean rem = this.ResidenceList.remove(residence);
        if (!rem) {
            Iterator<ClaimedResidence> iter = this.ResidenceList.iterator();
            while (iter.hasNext()) {
                ClaimedResidence one = iter.next();
                if (!one.getName().equalsIgnoreCase(residence.getName())) continue;
                iter.remove();
                break;
            }
        }
    }

    public int getResAmount() {
        int i = 0;
        for (ClaimedResidence one : this.ResidenceList) {
            if (one.isSubzone()) continue;
            ++i;
        }
        return i;
    }

    public List<ClaimedResidence> getResList() {
        return new ArrayList<ClaimedResidence>(this.ResidenceList);
    }

    @Deprecated
    public String getPlayerName() {
        return this.getName();
    }

    public String getName() {
        if (this.player == null) {
            this.updatePlayer();
        }
        return this.userName;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    @Deprecated
    public UUID getUuid() {
        return this.getUniqueId();
    }

    public Player getPlayer() {
        if (this.player == null) {
            this.updatePlayer();
        }
        return this.player;
    }

    public ClaimedResidence getCurrentlyRaidedResidence() {
        for (ClaimedResidence one : this.getResList()) {
            if (!one.getRaid().isUnderRaid() && !one.getRaid().isInPreRaid()) continue;
            return one;
        }
        return null;
    }

    public Long getLastRaidAttackTimer() {
        return this.lastRaidAttackTimer;
    }

    public void setLastRaidAttackTimer(Long lastRaidAttackTimer) {
        this.lastRaidAttackTimer = lastRaidAttackTimer;
    }

    public Long getLastRaidDefendTimer() {
        return this.lastRaidDefendTimer;
    }

    public void setLastRaidDefendTimer(Long lastRaidDefendTimer) {
        this.lastRaidDefendTimer = lastRaidDefendTimer;
    }

    public ResidenceRaid getJoinedRaid() {
        return this.raid;
    }

    public void setJoinedRaid(ResidenceRaid raid2) {
        this.raid = raid2;
    }

    public PlayerGroup getGroups() {
        return this.groups;
    }

    @Deprecated
    public boolean canBreakBlock(Location loc, boolean inform) {
        return this.canBreakBlock(loc.getBlock(), inform);
    }

    public boolean canBreakBlock(Block block, boolean inform) {
        return ResidenceBlockListener.canBreakBlock(this.getPlayer(), block, inform);
    }

    @Deprecated
    public boolean canPlaceBlock(Location loc, boolean inform) {
        return this.canPlaceBlock(loc.getBlock(), inform);
    }

    public boolean canPlaceBlock(Block block, boolean inform) {
        return ResidenceBlockListener.canPlaceBlock(this.getPlayer(), block, inform);
    }

    public boolean canDamageEntity(Entity entity, boolean inform) {
        return ResidenceEntityListener.canDamageEntity((Entity)this.getPlayer(), entity, inform);
    }

    public Set<ClaimedResidence> getTrustedResidenceList() {
        return this.trustedList;
    }

    public void addTrustedResidence(ClaimedResidence residence) {
        if (residence == null) {
            return;
        }
        this.trustedList.add(residence);
    }

    public void removeTrustedResidence(ClaimedResidence residence) {
        if (residence == null) {
            return;
        }
        this.trustedList.remove(residence);
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public static ResidencePlayer get(String name) {
        return Residence.getInstance().getPlayerManager().getResidencePlayer(name);
    }

    public static ResidencePlayer get(Player player) {
        return Residence.getInstance().getPlayerManager().getResidencePlayer(player);
    }

    public static ResidencePlayer get(UUID uuid) {
        return Residence.getInstance().getPlayerManager().getResidencePlayer(uuid);
    }
}

