/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.gui;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.gui.FlagData;
import com.bekvon.bukkit.residence.gui.setFlagInfo;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Set;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIAsyncHead;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FlagUtil {
    private FlagData flagData = new FlagData();
    private Residence plugin;

    public FlagUtil(Residence plugin) {
        this.plugin = plugin;
    }

    public void load() {
        ConfigReader c = null;
        try {
            c = new ConfigReader((Plugin)Residence.getInstance(), "flags.yml");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (c != null) {
            if (!c.getC().isConfigurationSection("Global.FlagPermission")) {
                return;
            }
            Set allFlags = c.getC().getConfigurationSection("Global.FlagPermission").getKeys(false);
            for (final String oneFlag : allFlags) {
                if (!c.getC().contains("Global.FlagGui." + oneFlag)) continue;
                String value = c.get("Global.FlagGui." + oneFlag, "WHITE_WOOL");
                value = value.replace("-", ":");
                CMIAsyncHead ahead = new CMIAsyncHead(){

                    public void afterAsyncUpdate(ItemStack item) {
                        CMIScheduler.runTask(() -> FlagUtil.this.flagData.addFlagButton(oneFlag.toLowerCase(), item));
                    }
                };
                CMIItemStack i = CMILib.getInstance().getItemManager().getItem(value, ahead);
                if (i == null || i.getType() == null) {
                    i = new CMIItemStack(CMIMaterial.STONE);
                }
                ItemStack item = i.getItemStack();
                this.flagData.addFlagButton(oneFlag.toLowerCase(), item);
            }
        }
    }

    public void openPsetFlagGui(Player player, String targetPlayer, ClaimedResidence res, boolean resadmin2, int page) {
        if (player == null || !player.isOnline()) {
            return;
        }
        setFlagInfo flag = new setFlagInfo(res, player, targetPlayer, resadmin2);
        flag.recalculate();
        PageInfo pi = new PageInfo(45, flag.getButtons().size(), page);
        this.openUI(flag, pi, player, Residence.getInstance().msg(lm.Gui_Pset_Title, res.getName(), targetPlayer));
    }

    private void openUI(final setFlagInfo flag, PageInfo pi, final Player player, final String title) {
        CMIGui gui = new CMIGui(player){

            public void pageChange(int page) {
                FlagUtil.this.openUI(flag, new PageInfo(45, flag.getButtons().size(), page), player, title);
            }
        };
        gui.setTitle(title);
        gui.setInvSize(GUIManager.GUIRows.r6);
        for (CMIGuiButton one : flag.getButtons()) {
            if (pi.isContinue()) continue;
            if (pi.isBreak()) break;
            gui.addButton(one);
        }
        gui.addPagination(pi);
        gui.fillEmptyButtons();
        gui.open();
    }

    public void openSetFlagGui(Player player, ClaimedResidence res, boolean resadmin2, int page) {
        if (player == null || !player.isOnline()) {
            return;
        }
        setFlagInfo flag = new setFlagInfo(res, player, resadmin2);
        flag.recalculate();
        PageInfo pi = new PageInfo(45, flag.getButtons().size(), page);
        this.openUI(flag, pi, player, this.plugin.msg(lm.Gui_Set_Title, res.getName()));
    }

    public FlagData getFlagData() {
        return this.flagData;
    }
}

