/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.permissions;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.Zrips.CMILib.Container.CMIWorld;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class PermissionGroup {
    private int xmax = 0;
    private int ymax = 0;
    private int zmax = 0;
    private int xmin = 0;
    private int ymin = 0;
    private int zmin = 0;
    protected int Subzonexmax = 0;
    protected int Subzoneymax = 0;
    protected int Subzonezmax = 0;
    protected int Subzonexmin = 0;
    protected int Subzoneymin = 0;
    protected int Subzonezmin = 0;
    protected int resmax = 0;
    private double costperarea = 0.0;
    private double sellperarea = 0.0;
    protected boolean tpaccess = false;
    protected int subzonedepth = 0;
    protected int maxSubzones = 3;
    protected FlagPermissions flagPerms = new FlagPermissions();
    protected Map<String, Boolean> creatorDefaultFlags = new HashMap<String, Boolean>();
    protected Map<String, Map<String, Boolean>> groupDefaultFlags;
    protected Map<String, Boolean> residenceDefaultFlags = new HashMap<String, Boolean>();
    protected Map<String, Map<String, FlagPermissions>> groupperms;
    protected Map<String, FlagPermissions> worldperms;
    protected boolean messageperms = false;
    protected String defaultEnterMessage = null;
    protected String defaultLeaveMessage = null;
    private int maxLeaseTime = 16;
    private int leaseGiveTime = 14;
    protected double renewcostperarea = 0.02;
    protected boolean canBuy = false;
    protected boolean canSell = false;
    protected boolean buyIgnoreLimits = false;
    protected boolean cancreate = false;
    protected String groupname;
    protected int maxPhysical = 2;
    protected boolean unstuck = false;
    protected boolean kick = false;
    protected int minHeight = 0;
    protected int maxHeight = 256;
    protected int maxRents = 0;
    protected int MaxRentDays = -1;
    protected int maxRentables = 0;
    protected boolean selectCommandAccess = true;
    protected boolean itemListAccess = true;
    protected int priority = 0;

    public PermissionGroup(String name) {
        this.groupDefaultFlags = new HashMap<String, Map<String, Boolean>>();
        this.worldperms = new HashMap<String, FlagPermissions>();
        this.groupperms = new HashMap<String, Map<String, FlagPermissions>>();
        this.groupname = name;
    }

    public void setPriority(int number) {
        this.priority = number;
    }

    public int getPriority() {
        return this.priority;
    }

    public PermissionGroup(String name, ConfigurationSection node) {
        this(name);
        this.parseGroup(node);
    }

    public PermissionGroup(String name, ConfigurationSection node, FlagPermissions parentFlagPerms) {
        this(name, node);
        this.flagPerms.setParent(parentFlagPerms);
    }

    public PermissionGroup(String name, ConfigurationSection node, FlagPermissions parentFlagPerms, int priority) {
        this(name, node);
        this.flagPerms.setParent(parentFlagPerms);
        this.priority = priority;
    }

    public void mirrorIn(ConfigurationSection limits2) {
        this.parseGroup(limits2);
    }

    private void parseGroup(ConfigurationSection limits2) {
        boolean access;
        if (limits2 == null) {
            return;
        }
        if (limits2.contains("Residence.CanCreate")) {
            this.cancreate = limits2.getBoolean("Residence.CanCreate", false);
        }
        if (limits2.contains("Residence.MaxResidences")) {
            this.resmax = limits2.getInt("Residence.MaxResidences", 0);
        }
        if (limits2.contains("Residence.MaxAreasPerResidence")) {
            this.maxPhysical = limits2.getInt("Residence.MaxAreasPerResidence", 2);
        }
        if (limits2.contains("Residence.MaxEastWest")) {
            this.xmax = limits2.getInt("Residence.MaxEastWest", 0);
        }
        if (limits2.contains("Residence.MinEastWest")) {
            this.xmin = limits2.getInt("Residence.MinEastWest", 0);
        }
        int n = this.xmin = this.getXmin() > this.getXmax() ? this.getXmax() : this.getXmin();
        if (limits2.contains("Residence.MaxUpDown")) {
            this.ymax = limits2.getInt("Residence.MaxUpDown", 0);
        }
        if (limits2.contains("Residence.MinUpDown")) {
            this.ymin = limits2.getInt("Residence.MinUpDown", 0);
        }
        int n2 = this.ymin = this.ymin > this.ymax ? this.ymax : this.ymin;
        if (Residence.getInstance().getConfigManager().isSelectionIgnoreY()) {
            this.ymin = CMIWorld.getMinHeight((World)((World)Bukkit.getWorlds().get(0)));
            this.ymax = CMIWorld.getMaxHeight((World)((World)Bukkit.getWorlds().get(0)));
        }
        if (limits2.contains("Residence.MaxNorthSouth")) {
            this.zmax = limits2.getInt("Residence.MaxNorthSouth", 0);
        }
        if (limits2.contains("Residence.MinNorthSouth")) {
            this.zmin = limits2.getInt("Residence.MinNorthSouth", 0);
        }
        int n3 = this.zmin = this.zmin > this.zmax ? this.zmax : this.zmin;
        if (limits2.contains("Residence.MinHeight")) {
            this.minHeight = limits2.getInt("Residence.MinHeight", 0);
        }
        if (limits2.contains("Residence.MaxHeight")) {
            this.maxHeight = limits2.getInt("Residence.MaxHeight", CMIWorld.getMaxHeight((World)((World)Bukkit.getWorlds().get(0))));
        }
        if (limits2.contains("Residence.CanTeleport")) {
            this.tpaccess = limits2.getBoolean("Residence.CanTeleport", false);
        }
        if (limits2.contains("Residence.MaxSubzonesInArea")) {
            this.maxSubzones = limits2.getInt("Residence.MaxSubzonesInArea", 3);
        }
        if (limits2.contains("Residence.SubzoneDepth")) {
            this.subzonedepth = limits2.getInt("Residence.SubzoneDepth", 0);
        }
        this.Subzonexmax = limits2.contains("Residence.SubzoneMaxEastWest") ? limits2.getInt("Residence.SubzoneMaxEastWest", this.getXmax()) : this.getXmax();
        int n4 = this.Subzonexmax = this.getXmax() < this.Subzonexmax ? this.getXmax() : this.Subzonexmax;
        if (limits2.contains("Residence.SubzoneMinEastWest")) {
            this.Subzonexmin = limits2.getInt("Residence.SubzoneMinEastWest", 0);
        }
        this.Subzonexmin = this.Subzonexmin > this.Subzonexmax ? this.Subzonexmax : this.Subzonexmin;
        this.Subzoneymax = limits2.contains("Residence.SubzoneMaxUpDown") ? limits2.getInt("Residence.SubzoneMaxUpDown", this.ymax) : this.getYmax();
        int n5 = this.Subzoneymax = this.ymax < this.Subzoneymax ? this.ymax : this.Subzoneymax;
        if (limits2.contains("Residence.SubzoneMinUpDown")) {
            this.Subzoneymin = limits2.getInt("Residence.SubzoneMinUpDown", 0);
        }
        this.Subzoneymin = this.Subzoneymin > this.Subzoneymax ? this.Subzoneymax : this.Subzoneymin;
        this.Subzonezmax = limits2.contains("Residence.SubzoneMaxNorthSouth") ? limits2.getInt("Residence.SubzoneMaxNorthSouth", this.zmax) : this.getZmax();
        int n6 = this.Subzonezmax = this.zmax < this.Subzonezmax ? this.zmax : this.Subzonezmax;
        if (limits2.contains("Residence.SubzoneMinNorthSouth")) {
            this.Subzonezmin = limits2.getInt("Residence.SubzoneMinNorthSouth", 0);
        }
        int n7 = this.Subzonezmin = this.Subzonezmin > this.Subzonezmax ? this.Subzonezmax : this.Subzonezmin;
        if (limits2.contains("Messaging.CanChange")) {
            this.messageperms = limits2.getBoolean("Messaging.CanChange", false);
        }
        if (limits2.contains("Messaging.DefaultEnter")) {
            this.defaultEnterMessage = limits2.getString("Messaging.DefaultEnter", null);
        }
        if (limits2.contains("Messaging.DefaultLeave")) {
            this.defaultLeaveMessage = limits2.getString("Messaging.DefaultLeave", null);
        }
        if (limits2.contains("Lease.MaxDays")) {
            this.maxLeaseTime = limits2.getInt("Lease.MaxDays", 16);
        }
        if (limits2.contains("Lease.RenewIncrement")) {
            this.leaseGiveTime = limits2.getInt("Lease.RenewIncrement", 14);
        }
        if (limits2.contains("Rent.MaxRents")) {
            this.maxRents = limits2.getInt("Rent.MaxRents", 0);
        }
        if (limits2.contains("Rent.MaxRentDays")) {
            this.MaxRentDays = limits2.getInt("Rent.MaxRentDays", -1);
        }
        if (limits2.contains("Rent.MaxRentables")) {
            this.maxRentables = limits2.getInt("Rent.MaxRentables", 0);
        }
        if (limits2.contains("Economy.RenewCost")) {
            this.renewcostperarea = limits2.getDouble("Economy.RenewCost", 0.02);
        }
        if (limits2.contains("Economy.CanBuy")) {
            this.canBuy = limits2.getBoolean("Economy.CanBuy", false);
        }
        if (limits2.contains("Economy.CanSell")) {
            this.canSell = limits2.getBoolean("Economy.CanSell", false);
        }
        if (limits2.contains("Economy.IgnoreLimits")) {
            this.buyIgnoreLimits = limits2.getBoolean("Economy.IgnoreLimits", false);
        }
        if (limits2.contains("Economy.BuyCost")) {
            this.costperarea = limits2.getDouble("Economy.BuyCost", 0.0);
        }
        if (limits2.contains("Economy.SellCost")) {
            this.sellperarea = limits2.getDouble("Economy.SellCost", 0.0);
        }
        if (limits2.isBoolean("Residence.Unstuck")) {
            this.unstuck = limits2.getBoolean("Residence.Unstuck", false);
        }
        if (limits2.contains("Residence.Kick")) {
            this.kick = limits2.getBoolean("Residence.Kick", false);
        }
        if (limits2.contains("Residence.SelectCommandAccess")) {
            this.selectCommandAccess = limits2.getBoolean("Residence.SelectCommandAccess", true);
        }
        if (limits2.contains("Residence.ItemListAccess")) {
            this.itemListAccess = limits2.getBoolean("Residence.ItemListAccess", true);
        }
        ConfigurationSection node = limits2.getConfigurationSection("Flags.Permission");
        Set flags2 = null;
        if (node != null) {
            flags2 = node.getKeys(false);
        }
        if (flags2 != null) {
            Iterator flagit = flags2.iterator();
            while (flagit.hasNext()) {
                String flagname;
                access = limits2.getBoolean("Flags.Permission." + (flagname = (String)flagit.next()), false);
                this.flagPerms.setFlag(flagname, access ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
            }
        }
        if ((node = limits2.getConfigurationSection("Flags.CreatorDefault")) != null) {
            flags2 = node.getKeys(false);
        }
        if (flags2 != null) {
            for (String flagname : flags2) {
                access = limits2.getBoolean("Flags.CreatorDefault." + flagname, false);
                this.creatorDefaultFlags.put(flagname, access);
            }
        }
        if ((node = limits2.getConfigurationSection("Flags.Default")) != null) {
            flags2 = node.getKeys(false);
        }
        if (flags2 != null) {
            for (String flagname : flags2) {
                access = limits2.getBoolean("Flags.Default." + flagname, false);
                this.residenceDefaultFlags.put(flagname, access);
            }
        }
        node = limits2.getConfigurationSection("Flags.GroupDefault");
        Set groupDef = null;
        if (node != null) {
            groupDef = node.getKeys(false);
        }
        if (groupDef != null) {
            for (String name : groupDef) {
                HashMap<String, Boolean> gflags = new HashMap<String, Boolean>();
                flags2 = limits2.getConfigurationSection("Flags.GroupDefault." + name).getKeys(false);
                for (String flagname : flags2) {
                    boolean access2 = limits2.getBoolean("Flags.GroupDefault." + name + "." + flagname, false);
                    gflags.put(flagname, access2);
                }
                this.groupDefaultFlags.put(name, gflags);
            }
        }
    }

    public String getGroupName() {
        return this.groupname;
    }

    public int getMaxX() {
        return this.xmax;
    }

    public int getMaxY() {
        return this.ymax;
    }

    public int getMaxZ() {
        return this.zmax;
    }

    public int getMinX() {
        return this.xmin;
    }

    public int getMinY() {
        return this.ymin;
    }

    public int getMinZ() {
        return this.zmin;
    }

    public int getSubzoneMaxX() {
        return this.Subzonexmax;
    }

    public int getSubzoneMaxY() {
        return this.Subzoneymax;
    }

    public int getSubzoneMaxZ() {
        return this.Subzonezmax;
    }

    public int getSubzoneMinX() {
        return this.Subzonexmin;
    }

    public int getSubzoneMinY() {
        return this.Subzoneymin;
    }

    public int getSubzoneMinZ() {
        return this.Subzonezmin;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxZones() {
        return this.resmax;
    }

    public double getCostPerBlock() {
        return this.costperarea;
    }

    public double getSellPerBlock() {
        return this.sellperarea;
    }

    public boolean hasTpAccess() {
        return this.tpaccess;
    }

    public int getMaxSubzoneDepth() {
        return this.subzonedepth;
    }

    public int getMaxSubzones() {
        return this.maxSubzones;
    }

    public boolean canSetEnterLeaveMessages() {
        return this.messageperms;
    }

    public String getDefaultEnterMessage() {
        if (this.defaultEnterMessage == null) {
            return "";
        }
        return this.defaultEnterMessage;
    }

    public String getDefaultLeaveMessage() {
        if (this.defaultLeaveMessage == null) {
            return "";
        }
        return this.defaultLeaveMessage;
    }

    public int getMaxLeaseTime() {
        return this.maxLeaseTime;
    }

    public int getLeaseGiveTime() {
        return this.leaseGiveTime;
    }

    public double getLeaseRenewCost() {
        return this.renewcostperarea;
    }

    public boolean canBuyLand() {
        return this.canBuy;
    }

    public boolean canSellLand() {
        return this.canSell;
    }

    public int getMaxRents() {
        return this.maxRents;
    }

    public int getMaxRentDays() {
        return this.MaxRentDays;
    }

    public int getMaxRentables() {
        return this.maxRentables;
    }

    public boolean buyLandIgnoreLimits() {
        return this.buyIgnoreLimits;
    }

    public boolean hasUnstuckAccess() {
        return this.unstuck;
    }

    public boolean hasKickAccess() {
        return this.kick;
    }

    public int getMaxPhysicalPerResidence() {
        return this.maxPhysical;
    }

    public Set<Map.Entry<String, Boolean>> getDefaultResidenceFlags() {
        return this.residenceDefaultFlags.entrySet();
    }

    public Set<Map.Entry<String, Boolean>> getDefaultCreatorFlags() {
        return this.creatorDefaultFlags.entrySet();
    }

    public Set<Map.Entry<String, Map<String, Boolean>>> getDefaultGroupFlags() {
        return this.groupDefaultFlags.entrySet();
    }

    public boolean canCreateResidences() {
        return this.cancreate;
    }

    public boolean hasFlagAccess(Flags flag) {
        return this.flagPerms.has(flag, false);
    }

    @Deprecated
    public boolean hasFlagAccess(String flag) {
        return this.flagPerms.has(flag, false);
    }

    public boolean selectCommandAccess() {
        return this.selectCommandAccess;
    }

    public boolean itemListAccess() {
        return this.itemListAccess;
    }

    public void printLimits(CommandSender player, OfflinePlayer target, boolean resadmin2) {
        ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(target.getName());
        rPlayer.getGroup(true);
        PermissionGroup group = rPlayer.getGroup();
        Residence.getInstance().msg(player, lm.General_Separator, new Object[0]);
        Residence.getInstance().msg(player, lm.Limits_PGroup, Residence.getInstance().getPermissionManager().getPermissionsGroup(target.getName(), target.isOnline() ? Bukkit.getPlayer((String)target.getName()).getWorld().getName() : Residence.getInstance().getConfigManager().getDefaultWorld()));
        Residence.getInstance().msg(player, lm.Limits_RGroup, group.getGroupName());
        if (target.isOnline() && resadmin2) {
            Residence.getInstance().msg(player, lm.Limits_Admin, Residence.getInstance().getPermissionManager().isResidenceAdmin(player));
        }
        Residence.getInstance().msg(player, lm.Limits_CanCreate, group.canCreateResidences());
        Residence.getInstance().msg(player, lm.Limits_MaxRes, rPlayer.getMaxRes());
        Residence.getInstance().msg(player, lm.Limits_NumberOwn, rPlayer.getResAmount());
        Residence.getInstance().msg(player, lm.Limits_MaxEW, String.valueOf(group.getMinX()) + "-" + rPlayer.getMaxX());
        Residence.getInstance().msg(player, lm.Limits_MaxNS, String.valueOf(group.getMinZ()) + "-" + rPlayer.getMaxZ());
        Residence.getInstance().msg(player, lm.Limits_MaxUD, String.valueOf(group.getMinY()) + "-" + group.getMaxY());
        Residence.getInstance().msg(player, lm.Limits_MinMax, group.getMinHeight(), group.getMaxHeight());
        Residence.getInstance().msg(player, lm.Limits_MaxSubzones, rPlayer.getMaxSubzones());
        Residence.getInstance().msg(player, lm.Limits_MaxSubDepth, rPlayer.getMaxSubzoneDepth());
        Residence.getInstance().msg(player, lm.Limits_MaxRents, String.valueOf(rPlayer.getMaxRents()) + (this.getMaxRentDays() != -1 ? Residence.getInstance().msg(lm.Limits_MaxRentDays, this.getMaxRentDays()) : ""));
        Residence.getInstance().msg(player, lm.Limits_EnterLeave, group.messageperms);
        if (Residence.getInstance().getEconomyManager() != null) {
            Residence.getInstance().msg(player, lm.Limits_Cost, group.costperarea);
            Residence.getInstance().msg(player, lm.Limits_Sell, group.sellperarea);
        }
        Residence.getInstance().msg(player, lm.Limits_Flag, group.flagPerms.listFlags());
        if (Residence.getInstance().getConfigManager().useLeases()) {
            Residence.getInstance().msg(player, lm.Limits_MaxDays, group.maxLeaseTime);
            Residence.getInstance().msg(player, lm.Limits_LeaseTime, group.leaseGiveTime);
            Residence.getInstance().msg(player, lm.Limits_RenewCost, group.renewcostperarea);
        }
        Residence.getInstance().msg(player, lm.General_Separator, new Object[0]);
    }

    public double getCostperarea() {
        return this.costperarea;
    }

    public double getSellperarea() {
        return this.sellperarea;
    }

    @Deprecated
    public int getXmin() {
        return this.xmin;
    }

    @Deprecated
    public int getXmax() {
        return this.xmax;
    }

    @Deprecated
    public int getZmin() {
        return this.zmin;
    }

    @Deprecated
    public int getYmin() {
        return this.ymin;
    }

    @Deprecated
    public int getYmax() {
        return this.ymax;
    }

    @Deprecated
    public int getZmax() {
        return this.zmax;
    }
}

