/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.persistance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.representer.Representer;

public class YMLSaveHelper {
    File f;
    Yaml yml = null;
    Map<String, Object> root;

    public YMLSaveHelper(File ymlfile) throws IOException {
        YamlConstructor constructor = new YamlConstructor();
        YamlRepresenter representer = new YamlRepresenter();
        representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setIndent(2);
        dumperOptions.setAllowUnicode(true);
        dumperOptions.setWidth(4096);
        try {
            Class.forName("org.yaml.snakeyaml.LoaderOptions");
            LoaderOptions loaderOptions = new LoaderOptions();
            loaderOptions.setMaxAliasesForCollections(Integer.MAX_VALUE);
            loaderOptions.getClass().getMethod("setCodePointLimit", Integer.TYPE).invoke((Object)loaderOptions, Integer.MAX_VALUE);
            this.yml = new Yaml((BaseConstructor)constructor, (Representer)representer, dumperOptions, loaderOptions);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.yml == null) {
            this.yml = new Yaml((BaseConstructor)constructor, (Representer)representer, dumperOptions);
        }
        this.root = new LinkedHashMap<String, Object>();
        if (ymlfile == null) {
            throw new IOException("YMLSaveHelper: null file...");
        }
        this.f = ymlfile;
    }

    public void save() throws IOException {
        if (this.f.getParentFile() != null && !this.f.getParentFile().exists()) {
            this.f.getParentFile().mkdirs();
        }
        if (this.f.isFile()) {
            this.f.delete();
        }
        FileOutputStream fout = new FileOutputStream(this.f);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fout, StandardCharsets.UTF_8);
        this.yml.dump(this.root, (Writer)osw);
        osw.close();
    }

    public void load() throws IOException {
        FileInputStream fis = new FileInputStream(this.f);
        try {
            this.root = (Map)this.yml.load((InputStream)fis);
        }
        catch (ReaderException e) {
            System.out.println("[Residence] - Failed to load " + this.yml.getName() + " file!");
        }
        ((InputStream)fis).close();
    }

    public Map<String, Object> getRoot() {
        return this.root;
    }
}

