/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.EconomyInterface;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.ResidenceManager;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class LeaseManager {
    private Set<ClaimedResidence> leaseExpireTime;
    ResidenceManager manager;
    private Residence plugin;

    public LeaseManager(Residence plugin) {
        this.plugin = plugin;
        this.manager = plugin.getResidenceManager();
        this.leaseExpireTime = new HashSet<ClaimedResidence>();
    }

    @Deprecated
    public boolean leaseExpires(ClaimedResidence res) {
        return this.isLeased(res);
    }

    public boolean isLeased(ClaimedResidence res) {
        if (res == null) {
            return false;
        }
        return res.getLeaseExpireTime() > 0L;
    }

    @Deprecated
    public boolean leaseExpires(String area2) {
        return this.isLeased(this.plugin.getResidenceManager().getByName(area2));
    }

    public String getExpireTime(ClaimedResidence res) {
        if (res == null) {
            return null;
        }
        long time = res.getLeaseExpireTime();
        if (time > 0L) {
            return GetTime.getTime(time);
        }
        return null;
    }

    @Deprecated
    public String getExpireTime(String area2) {
        return this.getExpireTime(this.plugin.getResidenceManager().getByName(area2));
    }

    public void removeExpireTime(ClaimedResidence res) {
        if (res == null) {
            return;
        }
        this.leaseExpireTime.remove(res);
    }

    @Deprecated
    public void removeExpireTime(String area2) {
        this.removeExpireTime(this.plugin.getResidenceManager().getByName(area2));
    }

    public void setExpireTime(Player player, ClaimedResidence res, int days) {
        if (res == null) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Invalid_Area, new Object[0]);
            }
            return;
        }
        res.setLeaseExpireTime(LeaseManager.daysToMs(days) + System.currentTimeMillis());
        this.leaseExpireTime.add(res);
        if (player != null) {
            this.plugin.msg((CommandSender)player, lm.Economy_LeaseRenew, this.getExpireTime(res));
        }
    }

    @Deprecated
    public void setExpireTime(String area2, int days) {
        this.setExpireTime(null, area2, days);
    }

    @Deprecated
    public void setExpireTime(Player player, String area2, int days) {
        this.setExpireTime(player, this.plugin.getResidenceManager().getByName(area2), days);
    }

    @Deprecated
    public void renewArea(String area2, Player player) {
        this.renewArea(this.plugin.getResidenceManager().getByName(area2), player);
    }

    public void renewArea(ClaimedResidence res, Player player) {
        if (res == null) {
            return;
        }
        if (!this.isLeased(res)) {
            this.plugin.msg((CommandSender)player, lm.Economy_LeaseNotExpire, new Object[0]);
            return;
        }
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        int max = group.getMaxLeaseTime();
        int add = group.getLeaseGiveTime();
        int rem = LeaseManager.daysRemaining(res);
        if (rem >= max) {
            this.plugin.msg((CommandSender)player, lm.Economy_LeaseRenew, this.getExpireTime(res));
            return;
        }
        EconomyInterface econ = this.plugin.getEconomyManager();
        if (econ != null) {
            double cost = group.getLeaseRenewCost();
            int amount = (int)Math.ceil((double)res.getTotalSize() * cost);
            if (cost != 0.0) {
                if (econ.canAfford(player.getName(), (double)amount)) {
                    econ.subtract(player.getName(), amount);
                    econ.add("Lease Money", amount);
                    if ((double)amount != 0.0) {
                        this.plugin.msg((CommandSender)player, lm.Economy_MoneyCharged, this.plugin.getEconomyManager().format(amount), econ.getName());
                    }
                } else {
                    this.plugin.msg((CommandSender)player, lm.Economy_NotEnoughMoney, new Object[0]);
                    return;
                }
            }
        }
        if (rem + add > max) {
            this.setExpireTime(player, res, max);
            this.plugin.msg((CommandSender)player, lm.Economy_LeaseRenewMax, new Object[0]);
            return;
        }
        long get = res.getLeaseExpireTime();
        if (get > 0L) {
            res.setLeaseExpireTime(get += LeaseManager.daysToMs(add));
            this.leaseExpireTime.add(res);
        } else {
            res.setLeaseExpireTime(LeaseManager.daysToMs(add));
            this.leaseExpireTime.add(res);
        }
        this.plugin.msg((CommandSender)player, lm.Economy_LeaseRenew, this.getExpireTime(res));
    }

    public double getRenewCostD(ClaimedResidence res) {
        double cost = res.getOwnerGroup().getLeaseRenewCost();
        double amount = (double)res.getTotalSize() * cost;
        amount = (double)Math.round(amount * 100.0) / 100.0;
        return amount;
    }

    private static long daysToMs(int days) {
        return (long)days * 24L * 60L * 60L * 1000L;
    }

    private static int msToDays(long ms) {
        return (int)Math.ceil((double)ms / 1000.0 / 60.0 / 60.0 / 24.0);
    }

    private static int daysRemaining(ClaimedResidence res) {
        if (res == null) {
            return 999;
        }
        long get = res.getLeaseExpireTime();
        if (get <= System.currentTimeMillis()) {
            return 0;
        }
        return LeaseManager.msToDays(get - System.currentTimeMillis());
    }

    public void doExpirations() {
        HashSet<ClaimedResidence> t = new HashSet<ClaimedResidence>(this.leaseExpireTime);
        for (ClaimedResidence res : t) {
            if (res == null) {
                this.leaseExpireTime.remove(res);
                continue;
            }
            if (res.getLeaseExpireTime() > System.currentTimeMillis()) continue;
            String resname = res.getName();
            boolean renewed = false;
            String owner = res.getPermissions().getOwner();
            PermissionGroup group = res.getOwnerGroup();
            double cost = this.getRenewCostD(res);
            if (this.plugin.getConfigManager().enableEconomy() && this.plugin.getConfigManager().autoRenewLeases()) {
                if (cost == 0.0) {
                    renewed = true;
                } else if (res.getBank().hasEnough(cost)) {
                    res.getBank().subtract(cost);
                    renewed = true;
                    if (this.plugin.getConfigManager().debugEnabled()) {
                        System.out.println("Lease Renewed From Residence Bank: " + resname);
                    }
                } else if (this.plugin.getEconomyManager().canAfford(owner, cost) && this.plugin.getEconomyManager().subtract(owner, cost)) {
                    renewed = true;
                    if (this.plugin.getConfigManager().debugEnabled()) {
                        System.out.println("Lease Renewed From Economy: " + resname);
                    }
                }
            }
            if (!renewed) {
                if (this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(resname)) continue;
                ResidenceDeleteEvent resevent = new ResidenceDeleteEvent(null, res, ResidenceDeleteEvent.DeleteCause.LEASE_EXPIRE);
                this.plugin.getServ().getPluginManager().callEvent((Event)resevent);
                if (resevent.isCancelled()) continue;
                this.manager.removeResidence(res);
                this.leaseExpireTime.remove(res);
                if (!this.plugin.getConfigManager().debugEnabled()) continue;
                System.out.println("Lease NOT removed, Removing: " + resname);
                continue;
            }
            if (this.plugin.getConfigManager().enableEconomy() && this.plugin.getConfigManager().enableLeaseMoneyAccount()) {
                this.plugin.getEconomyManager().add("Lease Money", cost);
            }
            if (this.plugin.getConfigManager().debugEnabled()) {
                System.out.println("Lease Renew Old: " + res.getName());
            }
            res.setLeaseExpireTime(System.currentTimeMillis() + LeaseManager.daysToMs(group.getLeaseGiveTime()));
            if (!this.plugin.getConfigManager().debugEnabled()) continue;
            System.out.println("Lease Renew New: " + res.getName());
        }
    }

    public void resetLeases() {
        String[] list2;
        this.leaseExpireTime.clear();
        String[] stringArray = list2 = this.manager.getResidenceList();
        int n = list2.length;
        int n2 = 0;
        while (n2 < n) {
            ClaimedResidence res;
            String item = stringArray[n2];
            if (item != null && (res = this.plugin.getResidenceManager().getByName(item)) != null) {
                this.setExpireTime(null, res, res.getOwnerGroup().getLeaseGiveTime());
            }
            ++n2;
        }
        System.out.println("[Residence] - Set default leases.");
    }

    public Map<String, Long> save() {
        HashMap<String, Long> m = new HashMap<String, Long>();
        for (ClaimedResidence one : this.leaseExpireTime) {
            m.put(one.getName(), one.getLeaseExpireTime());
        }
        return m;
    }

    public LeaseManager load(Map root) {
        LeaseManager l = new LeaseManager(this.plugin);
        if (root == null) {
            return l;
        }
        for (Object val : root.values()) {
            if (val instanceof Long) continue;
            root.remove(val);
        }
        Map m = root;
        for (Map.Entry one : m.entrySet()) {
            ClaimedResidence res = this.plugin.getResidenceManager().getByName((String)one.getKey());
            if (res == null) continue;
            res.setLeaseExpireTime((Long)one.getValue());
            l.leaseExpireTime.add(res);
        }
        return l;
    }
}

