/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.commands.padd;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.event.ResidenceFlagChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagCheckEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagEvent;
import com.bekvon.bukkit.residence.event.ResidenceOwnerChangeEvent;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ResidencePermissions
extends FlagPermissions {
    private UUID ownerUUID;
    private String ownerLastKnownName;
    private String world;
    private ClaimedResidence residence;
    private static boolean suspendEventCalls = false;

    private ResidencePermissions(ClaimedResidence res) {
        this.residence = res;
    }

    public ResidencePermissions(ClaimedResidence res, String creator, UUID creatorUUID, String inworld) {
        this(res);
        this.ownerUUID = creatorUUID == null ? Residence.getInstance().getPlayerUUID(creator) : creatorUUID;
        if (this.ownerUUID == null) {
            this.ownerUUID = Residence.getInstance().getEmptyUserUUID();
        }
        this.ownerLastKnownName = creator;
        this.world = inworld;
    }

    @Deprecated
    public ResidencePermissions(ClaimedResidence res, String creator, String inworld) {
        this(res);
        this.ownerUUID = Residence.getInstance().getPlayerUUID(creator);
        if (this.ownerUUID == null) {
            this.ownerUUID = Residence.getInstance().getEmptyUserUUID();
        }
        this.ownerLastKnownName = creator;
        this.world = inworld;
    }

    public boolean playerHas(CommandSender sender, Flags flag, boolean def) {
        if (sender instanceof Player) {
            return this.playerHas((Player)sender, flag, def);
        }
        return true;
    }

    @Override
    public boolean playerHas(Player player, Flags flag, boolean def) {
        return this.playerHas(player, this.world, flag, def);
    }

    @Deprecated
    public boolean playerHas(Player player, String flag, boolean def) {
        return this.playerHas(player.getName(), this.world, flag, def);
    }

    public boolean playerHas(String player, Flags flag, boolean def) {
        return this.playerHas(player, flag.toString(), def);
    }

    @Deprecated
    public boolean playerHas(String player, String flag, boolean def) {
        return this.playerHas(player, this.world, flag, def);
    }

    @Override
    public boolean playerHas(Player player, Flags flag, FlagPermissions.FlagCombo f) {
        switch (f) {
            case FalseOrNone: {
                return !this.playerHas(player, this.world, flag, false);
            }
            case OnlyFalse: {
                return !this.playerHas(player, this.world, flag, true);
            }
            case OnlyTrue: {
                return this.playerHas(player, this.world, flag, false);
            }
            case TrueOrNone: {
                return this.playerHas(player, this.world, flag, true);
            }
        }
        return false;
    }

    public boolean playerHas(ResidencePlayer player, Flags flag, FlagPermissions.FlagCombo f) {
        switch (f) {
            case FalseOrNone: {
                return !this.playerHas(player, flag, false);
            }
            case OnlyFalse: {
                return !this.playerHas(player, flag, true);
            }
            case OnlyTrue: {
                return this.playerHas(player, flag, false);
            }
            case TrueOrNone: {
                return this.playerHas(player, flag, true);
            }
        }
        return false;
    }

    @Override
    public boolean playerHas(ResidencePlayer player, Flags flag, boolean def) {
        if (player == null) {
            return false;
        }
        if (!ResidencePermissions.isEventCallsSuspended()) {
            ResidenceFlagCheckEvent fc = new ResidenceFlagCheckEvent(this.residence, flag.toString(), ResidenceFlagEvent.FlagType.PLAYER, player.getName(), def);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
            if (fc.isOverriden()) {
                return fc.getOverrideValue();
            }
        }
        return super.playerHas(player, flag, def);
    }

    @Deprecated
    public boolean playerHas(String player, String flag, FlagPermissions.FlagCombo f) {
        switch (f) {
            case FalseOrNone: {
                return !this.playerHas(player, this.world, flag, false);
            }
            case OnlyFalse: {
                return !this.playerHas(player, this.world, flag, true);
            }
            case OnlyTrue: {
                return this.playerHas(player, this.world, flag, false);
            }
            case TrueOrNone: {
                return this.playerHas(player, this.world, flag, true);
            }
        }
        return false;
    }

    @Override
    public boolean playerHas(Player player, String world, Flags flag, boolean def) {
        if (player == null) {
            return false;
        }
        if (!ResidencePermissions.isEventCallsSuspended()) {
            ResidenceFlagCheckEvent fc = new ResidenceFlagCheckEvent(this.residence, flag.toString(), ResidenceFlagEvent.FlagType.PLAYER, player.getName(), def);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
            if (fc.isOverriden()) {
                return fc.getOverrideValue();
            }
        }
        return super.playerHas(player, world, flag, def);
    }

    @Override
    @Deprecated
    public boolean playerHas(String player, String world, String flag, boolean def) {
        if (!ResidencePermissions.isEventCallsSuspended()) {
            ResidenceFlagCheckEvent fc = new ResidenceFlagCheckEvent(this.residence, flag, ResidenceFlagEvent.FlagType.PLAYER, player, def);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
            if (fc.isOverriden()) {
                return fc.getOverrideValue();
            }
        }
        return super.playerHas(player, world, flag, def);
    }

    @Override
    public boolean groupHas(String group, String flag, boolean def) {
        if (!ResidencePermissions.isEventCallsSuspended()) {
            ResidenceFlagCheckEvent fc = new ResidenceFlagCheckEvent(this.residence, flag, ResidenceFlagEvent.FlagType.GROUP, group, def);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
            if (fc.isOverriden()) {
                return fc.getOverrideValue();
            }
        }
        return super.groupHas(group, flag, def);
    }

    @Override
    public boolean has(Flags flag, FlagPermissions.FlagCombo f) {
        return this.has(flag, f, true);
    }

    public boolean has(Flags flag, FlagPermissions.FlagCombo f, boolean checkParent) {
        switch (f) {
            case FalseOrNone: {
                return !this.has(flag, false, checkParent);
            }
            case OnlyFalse: {
                return !this.has(flag, true, checkParent);
            }
            case OnlyTrue: {
                return this.has(flag, false, checkParent);
            }
            case TrueOrNone: {
                return this.has(flag, true, checkParent);
            }
        }
        return false;
    }

    @Deprecated
    public boolean has(String flag, FlagPermissions.FlagCombo f) {
        return this.has(flag, f, true);
    }

    @Deprecated
    public boolean has(String flag, FlagPermissions.FlagCombo f, boolean checkParent) {
        switch (f) {
            case FalseOrNone: {
                return !this.has(flag, false, checkParent);
            }
            case OnlyFalse: {
                return !this.has(flag, true, checkParent);
            }
            case OnlyTrue: {
                return this.has(flag, false, checkParent);
            }
            case TrueOrNone: {
                return this.has(flag, true, checkParent);
            }
        }
        return false;
    }

    @Override
    public boolean has(Flags flag, boolean def) {
        return this.has(flag.toString(), def, true);
    }

    @Override
    public boolean has(String flag, boolean def) {
        return this.has(flag, def, true);
    }

    @Override
    public boolean has(String flag, boolean def, boolean checkParent) {
        if (!ResidencePermissions.isEventCallsSuspended()) {
            ResidenceFlagCheckEvent fc = new ResidenceFlagCheckEvent(this.residence, flag, ResidenceFlagEvent.FlagType.RESIDENCE, null, def);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
            if (fc.isOverriden()) {
                return fc.getOverrideValue();
            }
        }
        return super.has(flag, def, checkParent);
    }

    public boolean hasApplicableFlag(String player, String flag) {
        return super.inheritanceIsPlayerSet(player, flag) || super.inheritanceIsGroupSet(Residence.getInstance().getPlayerManager().getResidencePlayer(player).getGroup(this.world).getGroupName(), flag) || super.inheritanceIsSet(flag);
    }

    public void applyTemplate(Player player, FlagPermissions list2, boolean resadmin2) {
        if (player != null) {
            if (!resadmin2) {
                if (!Residence.getInstance().getConfigManager().isOfflineMode() && !player.getUniqueId().toString().equals(this.ownerUUID.toString())) {
                    Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return;
                }
                if (!player.getName().equalsIgnoreCase(this.ownerLastKnownName)) {
                    Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return;
                }
            }
        } else {
            resadmin2 = true;
        }
        ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(this.getOwner());
        PermissionGroup group = rPlayer.getGroup(this.world);
        for (Map.Entry<String, Boolean> entry : list2.cuboidFlags.entrySet()) {
            if (group.hasFlagAccess(entry.getKey()) || resadmin2) {
                this.cuboidFlags.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (player == null) continue;
            Residence.getInstance().msg((CommandSender)player, lm.Flag_SetDeny, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : list2.playerFlags.entrySet()) {
            Map<String, Boolean> map = this.getPlayerFlags(entry.getKey(), true);
            for (Map.Entry flag : ((Map)entry.getValue()).entrySet()) {
                if (group.hasFlagAccess((String)flag.getKey()) || resadmin2) {
                    map.put((String)flag.getKey(), (Boolean)flag.getValue());
                    continue;
                }
                if (player == null) continue;
                Residence.getInstance().msg((CommandSender)player, lm.Flag_SetDeny, flag.getKey());
            }
        }
        for (Map.Entry<String, Object> entry : list2.groupFlags.entrySet()) {
            for (Map.Entry flag : ((Map)entry.getValue()).entrySet()) {
                if (group.hasFlagAccess((String)flag.getKey()) || resadmin2) {
                    if (!this.groupFlags.containsKey(entry.getKey())) {
                        this.groupFlags.put(entry.getKey(), Collections.synchronizedMap(new HashMap()));
                    }
                    ((Map)this.groupFlags.get(entry.getKey())).put((String)flag.getKey(), (Boolean)flag.getValue());
                    continue;
                }
                if (player == null) continue;
                Residence.getInstance().msg((CommandSender)player, lm.Flag_SetDeny, flag.getKey());
            }
        }
        if (player != null) {
            Residence.getInstance().msg((CommandSender)player, lm.Residence_PermissionsApply, new Object[0]);
        }
    }

    public boolean hasResidencePermission(CommandSender sender, boolean requireOwner) {
        if (!(sender instanceof Player)) {
            return true;
        }
        ClaimedResidence par = this.residence.getParent();
        Player player = (Player)sender;
        if (par != null && par.getPermissions().playerHas(player, Flags.admin, FlagPermissions.FlagCombo.OnlyTrue)) {
            return true;
        }
        if (Residence.getInstance().getConfigManager().enabledRentSystem()) {
            String resname = this.residence.getName();
            if (Residence.getInstance().getRentManager().isRented(resname)) {
                if (requireOwner) {
                    return false;
                }
                String renter = Residence.getInstance().getRentManager().getRentingPlayer(resname);
                if (sender.getName().equals(renter)) {
                    return true;
                }
                return this.playerHas(player, Flags.admin, FlagPermissions.FlagCombo.OnlyTrue);
            }
        }
        if (requireOwner) {
            return this.getOwner().equals(sender.getName());
        }
        return this.playerHas(player, Flags.admin, FlagPermissions.FlagCombo.OnlyTrue) || this.getOwner().equals(sender.getName());
    }

    private boolean checkCanSetFlag(CommandSender sender, String flag, FlagPermissions.FlagState state, boolean globalflag, boolean resadmin2) {
        Flags f = Flags.getFlag(flag);
        if (f != null) {
            flag = f.toString();
        }
        if (!this.checkValidFlag(flag, globalflag)) {
            if (f != null) {
                Residence.getInstance().msg(sender, lm.Invalid_FlagType_Fail, f.getFlagMode() == Flags.FlagMode.Residence ? Residence.getInstance().getLM().getMessage(lm.Invalid_FlagType_Residence, new Object[0]) : Residence.getInstance().getLM().getMessage(lm.Invalid_FlagType_Player, new Object[0]));
            } else {
                Residence.getInstance().msg(sender, lm.Invalid_Flag, new Object[0]);
            }
            return false;
        }
        if (state == FlagPermissions.FlagState.INVALID) {
            Residence.getInstance().msg(sender, lm.Invalid_FlagState, new Object[0]);
            return false;
        }
        if (!resadmin2) {
            if (!this.hasResidencePermission(sender, false)) {
                Residence.getInstance().msg(sender, lm.General_NoPermission, new Object[0]);
                return false;
            }
            if (!this.hasFlagAccess(this.getOwner(), flag) && !PermissionManager.ResPerm.flag_$1.hasPermission(sender, 10000L, flag.toLowerCase())) {
                Residence.getInstance().msg(sender, lm.Flag_SetFailed, flag);
                return false;
            }
        }
        return true;
    }

    private boolean hasFlagAccess(String player, String flag) {
        ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup(this.world);
        return group.hasFlagAccess(flag);
    }

    public boolean setPlayerFlag(CommandSender sender, String targetPlayer, String flag, String flagstate, boolean resadmin2, boolean Show) {
        if (Residence.getInstance().getPlayerUUID(targetPlayer) == null) {
            sender.sendMessage("No player by this name");
            return false;
        }
        if (this.residence.getRaid().isRaidInitialized() && !resadmin2) {
            Residence.getInstance().msg(sender, lm.Raid_noFlagChange, new Object[0]);
            return false;
        }
        Flags f = Flags.getFlag(flag);
        if (f != null) {
            flag = f.toString();
        }
        if (validFlagGroups.containsKey(flag)) {
            return this.setFlagGroupOnPlayer(sender, targetPlayer, flag, flagstate, resadmin2);
        }
        FlagPermissions.FlagState state = FlagPermissions.stringToFlagState(flagstate);
        if (this.checkCanSetFlag(sender, flag, state, false, resadmin2)) {
            if (!ResidencePermissions.isEventCallsSuspended()) {
                ResidenceFlagChangeEvent fc = new ResidenceFlagChangeEvent(this.residence, sender instanceof Player ? (Player)sender : null, flag, ResidenceFlagEvent.FlagType.PLAYER, state, targetPlayer);
                Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
                if (fc.isCancelled()) {
                    return false;
                }
            }
            if (super.setPlayerFlag(targetPlayer, flag, state)) {
                if (Show) {
                    Residence.getInstance().msg(sender, lm.Flag_Set, flag, this.residence.getName(), flagstate);
                }
                if ((f == null || f.isInGroup(padd.groupedFlag)) && targetPlayer != null) {
                    ResidencePlayer rplayer;
                    boolean trusted = this.residence.isTrusted(targetPlayer);
                    if (!state.equals((Object)FlagPermissions.FlagState.TRUE) && !trusted) {
                        ResidencePlayer rplayer2 = Residence.getInstance().getPlayerManager().getResidencePlayer(targetPlayer);
                        if (rplayer2 != null) {
                            rplayer2.removeTrustedResidence(this.residence);
                        }
                    } else if (state.equals((Object)FlagPermissions.FlagState.TRUE) && trusted && (rplayer = Residence.getInstance().getPlayerManager().getResidencePlayer(targetPlayer)) != null) {
                        rplayer.addTrustedResidence(this.residence);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean setGroupFlag(Player player, String group, String flag, String flagstate, boolean resadmin2) {
        Flags f = Flags.getFlag(flag);
        FlagPermissions.FlagState state = FlagPermissions.stringToFlagState(flagstate);
        return this.setGroupFlag(player, group, f, state, resadmin2);
    }

    public boolean setGroupFlag(Player player, String group, Flags f, FlagPermissions.FlagState flagstate, boolean resadmin2) {
        String flag = null;
        if (f != null) {
            flag = f.toString();
        }
        if (flag == null) {
            Residence.getInstance().msg((CommandSender)player, lm.Invalid_Flag, new Object[0]);
            return false;
        }
        if (flagstate.equals((Object)FlagPermissions.FlagState.INVALID)) {
            Residence.getInstance().msg((CommandSender)player, lm.Invalid_FlagState, new Object[0]);
            return false;
        }
        if (this.residence.getRaid().isRaidInitialized() && !resadmin2) {
            Residence.getInstance().msg((CommandSender)player, lm.Raid_noFlagChange, new Object[0]);
            return false;
        }
        group = group.toLowerCase();
        if (validFlagGroups.containsKey(flag)) {
            return this.setFlagGroupOnGroup(player, flag, group, flagstate.toString(), resadmin2);
        }
        if (this.checkCanSetFlag((CommandSender)player, flag, flagstate, false, resadmin2)) {
            if (Residence.getInstance().getPermissionManager().hasGroup(group)) {
                if (!ResidencePermissions.isEventCallsSuspended()) {
                    ResidenceFlagChangeEvent fc = new ResidenceFlagChangeEvent(this.residence, player, flag, ResidenceFlagEvent.FlagType.GROUP, flagstate, group);
                    Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
                    if (fc.isCancelled()) {
                        return false;
                    }
                }
                if (super.setGroupFlag(group, flag, flagstate)) {
                    Residence.getInstance().msg((CommandSender)player, lm.Flag_Set, new Object[]{flag, this.residence.getName(), flagstate});
                    return true;
                }
            } else {
                Residence.getInstance().msg((CommandSender)player, lm.Invalid_Group, new Object[0]);
                return false;
            }
        }
        return false;
    }

    @Deprecated
    public boolean setFlag(CommandSender sender, String flag, String flagstate, boolean resadmin2) {
        return this.setFlag(sender, flag, FlagPermissions.stringToFlagState(flagstate), resadmin2);
    }

    public boolean setFlag(CommandSender sender, String flag, FlagPermissions.FlagState state, boolean resadmin2) {
        return this.setFlag(sender, flag, state, resadmin2, true);
    }

    public boolean setFlag(CommandSender sender, String flag, FlagPermissions.FlagState state, boolean resadmin2, boolean inform) {
        Flags f = Flags.getFlag(flag);
        if (f != null) {
            flag = f.toString();
        }
        if (this.residence.getRaid().isRaidInitialized() && !resadmin2) {
            Residence.getInstance().msg(sender, lm.Raid_noFlagChange, new Object[0]);
            return false;
        }
        if (validFlagGroups.containsKey(flag)) {
            return this.setFlagGroup(sender, flag, state, resadmin2);
        }
        if (Residence.getInstance().getConfigManager().isPvPFlagPrevent()) {
            for (String oneFlag : Residence.getInstance().getConfigManager().getProtectedFlagsList()) {
                if (!flag.equalsIgnoreCase(oneFlag)) continue;
                ArrayList<Player> players = this.residence.getPlayersInResidence();
                if (resadmin2 || players.size() <= 1 && (players.size() != 1 || players.get(0).getName().equals(this.getOwner()))) continue;
                int size = 0;
                for (Player one : players) {
                    if (one.getName().equals(this.getOwner())) continue;
                    ++size;
                }
                if (inform) {
                    Residence.getInstance().msg(sender, lm.Flag_ChangeDeny, flag, size);
                }
                return false;
            }
        }
        if (this.checkCanSetFlag(sender, flag, state, true, resadmin2)) {
            if (!ResidencePermissions.isEventCallsSuspended()) {
                ResidenceFlagChangeEvent fc = new ResidenceFlagChangeEvent(this.residence, sender instanceof Player ? (Player)sender : null, flag, ResidenceFlagEvent.FlagType.RESIDENCE, state, null);
                Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
                if (fc.isCancelled()) {
                    return false;
                }
            }
            if (super.setFlag(flag, state)) {
                if (inform) {
                    Residence.getInstance().msg(sender, lm.Flag_Set, flag, this.residence.getName(), state.name());
                }
                return true;
            }
        }
        return false;
    }

    public boolean removeAllPlayerFlags(CommandSender sender, String targetPlayer, boolean resadmin2) {
        if (this.hasResidencePermission(sender, false) || resadmin2) {
            if (!ResidencePermissions.isEventCallsSuspended()) {
                ResidenceFlagChangeEvent fc = new ResidenceFlagChangeEvent(this.residence, sender instanceof Player ? (Player)sender : null, "ALL", ResidenceFlagEvent.FlagType.RESIDENCE, FlagPermissions.FlagState.NEITHER, null);
                Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
                if (fc.isCancelled()) {
                    return false;
                }
            }
            super.removeAllPlayerFlags(targetPlayer);
            Residence.getInstance().msg(sender, lm.Flag_RemovedAll, targetPlayer, this.residence.getName());
            return true;
        }
        return false;
    }

    public boolean removeAllGroupFlags(Player player, String group, boolean resadmin2) {
        if (this.hasResidencePermission((CommandSender)player, false) || resadmin2) {
            if (!ResidencePermissions.isEventCallsSuspended()) {
                ResidenceFlagChangeEvent fc = new ResidenceFlagChangeEvent(this.residence, player, "ALL", ResidenceFlagEvent.FlagType.GROUP, FlagPermissions.FlagState.NEITHER, null);
                Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
                if (fc.isCancelled()) {
                    return false;
                }
            }
            super.removeAllGroupFlags(group);
            Residence.getInstance().msg((CommandSender)player, lm.Flag_RemovedGroup, group, this.residence.getName());
            return true;
        }
        return false;
    }

    @Override
    public boolean setFlag(String flag, FlagPermissions.FlagState state) {
        if (!ResidencePermissions.isEventCallsSuspended()) {
            ResidenceFlagChangeEvent fc = new ResidenceFlagChangeEvent(this.residence, null, flag, ResidenceFlagEvent.FlagType.RESIDENCE, state, null);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
            if (fc.isCancelled()) {
                return false;
            }
        }
        return super.setFlag(flag, state);
    }

    @Override
    public boolean setGroupFlag(String group, String flag, FlagPermissions.FlagState state) {
        if (!ResidencePermissions.isEventCallsSuspended()) {
            ResidenceFlagChangeEvent fc = new ResidenceFlagChangeEvent(this.residence, null, flag, ResidenceFlagEvent.FlagType.GROUP, state, group);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
            if (fc.isCancelled()) {
                return false;
            }
        }
        return super.setGroupFlag(group, flag, state);
    }

    @Override
    public boolean setPlayerFlag(String player, String flag, FlagPermissions.FlagState state) {
        if (!ResidencePermissions.isEventCallsSuspended()) {
            ResidenceFlagChangeEvent fc = new ResidenceFlagChangeEvent(this.residence, null, flag, ResidenceFlagEvent.FlagType.PLAYER, state, player);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)fc);
            if (fc.isCancelled()) {
                return false;
            }
        }
        return super.setPlayerFlag(player, flag, state);
    }

    public void applyDefaultFlags(Player player, boolean resadmin2) {
        if (this.hasResidencePermission((CommandSender)player, true) || resadmin2) {
            this.applyDefaultFlags();
            Residence.getInstance().msg((CommandSender)player, lm.Flag_Default, new Object[0]);
        } else {
            Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
        }
    }

    public void applyDefaultFlags() {
        ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(this.getOwner());
        PermissionGroup group = rPlayer.getGroup(this.world);
        Set<Map.Entry<String, Boolean>> dflags = group.getDefaultResidenceFlags();
        Set<Map.Entry<String, Map<String, Boolean>>> dgflags = group.getDefaultGroupFlags();
        this.applyGlobalDefaults();
        for (Map.Entry<String, Boolean> entry : dflags) {
            if (!this.checkValidFlag(entry.getKey(), true)) continue;
            this.setFlag(entry.getKey(), entry.getValue() != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
        }
        for (Map.Entry<String, Object> entry : dgflags) {
            Map value = (Map)entry.getValue();
            for (Map.Entry flag : value.entrySet()) {
                this.setGroupFlag(entry.getKey(), (String)flag.getKey(), (Boolean)flag.getValue() != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
            }
        }
    }

    public void applyDefaultRentedFlags() {
        if (!this.residence.isRented()) {
            return;
        }
        FlagPermissions dflags = Residence.getInstance().getConfigManager().getGlobalRentedDefaultFlags();
        Map<String, Boolean> dgflags = dflags.getFlags();
        if (this.residence.rentedland == null || this.residence.rentedland.player == null) {
            return;
        }
        this.removeAllPlayerFlags(this.residence.rentedland.player);
        String player = this.residence.rentedland.player;
        for (Map.Entry<String, Boolean> entry : dgflags.entrySet()) {
            this.setPlayerFlag(player, entry.getKey(), entry.getValue() != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
        }
    }

    public boolean setOwner(Player player, boolean resetFlags) {
        ResidenceOwnerChangeEvent ownerchange = new ResidenceOwnerChangeEvent(this.residence, player);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)ownerchange);
        if (ownerchange.isCancelled()) {
            return false;
        }
        Residence.getInstance().getPlayerManager().removeResFromPlayer(this.residence.getOwnerUUID(), this.residence);
        Residence.getInstance().getPlayerManager().addResidence(player, this.residence);
        this.ownerLastKnownName = player.getName();
        this.ownerUUID = player.getUniqueId();
        if (resetFlags) {
            this.applyDefaultFlags();
        }
        return true;
    }

    public void setOwner(String newOwner, boolean resetFlags) {
        UUID playerUUID;
        ResidenceOwnerChangeEvent ownerchange = new ResidenceOwnerChangeEvent(this.residence, newOwner);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)ownerchange);
        if (ownerchange.isCancelled()) {
            return;
        }
        Residence.getInstance().getPlayerManager().removeResFromPlayer(this.residence.getOwnerUUID(), this.residence);
        this.ownerLastKnownName = newOwner;
        ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(newOwner);
        if (rPlayer != null) {
            this.ownerUUID = rPlayer.getUniqueId();
            this.ownerLastKnownName = rPlayer.getName();
        }
        this.ownerUUID = this.ownerLastKnownName.equalsIgnoreCase("Server Land") || this.ownerLastKnownName.equalsIgnoreCase(Residence.getInstance().getServerLandName()) ? UUID.fromString(Residence.getInstance().getServerLandUUID()) : ((playerUUID = Residence.getInstance().getPlayerUUID(this.ownerLastKnownName)) != null ? playerUUID : UUID.fromString(Residence.getInstance().getTempUserUUID()));
        Residence.getInstance().getPlayerManager().addResidence(this.ownerLastKnownName, this.residence);
        if (resetFlags) {
            this.applyDefaultFlags();
        }
    }

    public String getOwner() {
        if (Residence.getInstance().getConfigManager().isOfflineMode()) {
            return this.ownerLastKnownName == null ? "Unknown" : this.ownerLastKnownName;
        }
        if (this.ownerUUID != null && this.ownerUUID.toString().equals(Residence.getInstance().getServerLandUUID())) {
            return Residence.getInstance().getServerLandName();
        }
        String name = Residence.getInstance().getPlayerName(this.ownerUUID);
        if (name == null) {
            return this.ownerLastKnownName == null ? "Unknown" : this.ownerLastKnownName;
        }
        this.ownerLastKnownName = name;
        return name;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        if (ownerUUID != null) {
            this.ownerUUID = ownerUUID;
        }
    }

    @Deprecated
    public String getWorld() {
        return this.world;
    }

    public String getWorldName() {
        return this.world;
    }

    public World getBukkitWorld() {
        return Bukkit.getWorld((String)this.world);
    }

    @Override
    public Map<String, Object> save(String world) {
        Map<String, Object> root = super.save(this.world);
        if (!this.ownerUUID.toString().equals(Residence.getInstance().getTempUserUUID())) {
            root.put("OwnerUUID", this.ownerUUID.toString());
        }
        root.put("OwnerLastKnownName", this.ownerLastKnownName);
        return root;
    }

    public static ResidencePermissions load(String worldName, ClaimedResidence res, Map<String, Object> root) throws Exception {
        ResidencePermissions newperms = new ResidencePermissions(res);
        if (root.containsKey("OwnerUUID") || root.containsKey("OwnerLastKnownName")) {
            UUID realUUID;
            newperms.ownerUUID = !root.containsKey("OwnerUUID") ? UUID.fromString(Residence.getInstance().getTempUserUUID()) : UUID.fromString((String)root.get("OwnerUUID"));
            newperms.ownerLastKnownName = (String)root.get("OwnerLastKnownName");
            OfflinePlayer p = null;
            if (newperms.ownerLastKnownName == null) {
                p = Residence.getInstance().getOfflinePlayer(newperms.ownerUUID);
            }
            if (p != null) {
                newperms.ownerLastKnownName = p.getName();
            }
            if (newperms.ownerLastKnownName == null) {
                return newperms;
            }
            if (newperms.ownerLastKnownName.equalsIgnoreCase("Server land") || newperms.ownerLastKnownName.equalsIgnoreCase(Residence.getInstance().getServerLandName())) {
                newperms.ownerUUID = UUID.fromString(Residence.getInstance().getServerLandUUID());
                newperms.ownerLastKnownName = Residence.getInstance().getServerLandName();
            } else if (newperms.ownerUUID.toString().equals(Residence.getInstance().getTempUserUUID()) && (realUUID = Residence.getInstance().getPlayerUUID(newperms.ownerLastKnownName)) != null) {
                newperms.ownerUUID = realUUID;
            }
        } else if (root.containsKey("Owner")) {
            String owner;
            newperms.ownerLastKnownName = owner = (String)root.get("Owner");
            newperms.ownerUUID = Residence.getInstance().getPlayerUUID(owner);
            if (newperms.ownerUUID == null) {
                newperms.ownerUUID = UUID.fromString(Residence.getInstance().getTempUserUUID());
            }
        } else {
            newperms.ownerUUID = UUID.fromString(Residence.getInstance().getServerLandUUID());
            newperms.ownerLastKnownName = Residence.getInstance().getServerLandName();
        }
        newperms.world = worldName;
        FlagPermissions.load(root, newperms);
        if (newperms.getOwner() == null || newperms.world == null || newperms.playerFlags == null || newperms.groupFlags == null || newperms.cuboidFlags == null) {
            throw new Exception("Invalid Residence Permissions...");
        }
        return newperms;
    }

    public void applyGlobalDefaults() {
        this.clearFlags();
        FlagPermissions gRD = Residence.getInstance().getConfigManager().getGlobalResidenceDefaultFlags();
        FlagPermissions gCD = Residence.getInstance().getConfigManager().getGlobalCreatorDefaultFlags();
        Map<String, FlagPermissions> gGD = Residence.getInstance().getConfigManager().getGlobalGroupDefaultFlags();
        for (Map.Entry<String, Boolean> entry : gRD.cuboidFlags.entrySet()) {
            this.setFlag(entry.getKey(), entry.getValue() != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
        }
        for (Map.Entry<String, Boolean> entry : gCD.cuboidFlags.entrySet()) {
            if (entry.getValue().booleanValue()) {
                this.setPlayerFlag(this.getOwner(), entry.getKey(), FlagPermissions.FlagState.TRUE);
                continue;
            }
            this.setPlayerFlag(this.getOwner(), entry.getKey(), FlagPermissions.FlagState.FALSE);
        }
        for (Map.Entry<String, Object> entry : gGD.entrySet()) {
            for (Map.Entry<String, Boolean> flag : ((FlagPermissions)entry.getValue()).cuboidFlags.entrySet()) {
                if (flag.getValue().booleanValue()) {
                    this.setGroupFlag(entry.getKey(), flag.getKey(), FlagPermissions.FlagState.TRUE);
                    continue;
                }
                this.setGroupFlag(entry.getKey(), flag.getKey(), FlagPermissions.FlagState.FALSE);
            }
        }
    }

    @Deprecated
    public boolean setFlagGroup(CommandSender sender, String flaggroup, String state, boolean resadmin2) {
        return this.setFlagGroup(sender, flaggroup, FlagPermissions.stringToFlagState(state), resadmin2);
    }

    public boolean setFlagGroup(CommandSender sender, String flaggroup, FlagPermissions.FlagState state, boolean resadmin2) {
        if (FlagPermissions.validFlagGroups.containsKey(flaggroup)) {
            Set<String> flags2 = FlagPermissions.validFlagGroups.get(flaggroup);
            boolean changed = false;
            for (String flag : flags2) {
                if (!this.setFlag(sender, flag, state, resadmin2)) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    public boolean setFlagGroupOnGroup(Player player, String flaggroup, String group, String state, boolean resadmin2) {
        if (FlagPermissions.validFlagGroups.containsKey(flaggroup)) {
            Set<String> flags2 = FlagPermissions.validFlagGroups.get(flaggroup);
            boolean changed = false;
            for (String flag : flags2) {
                if (!this.setGroupFlag(player, group, flag, state, resadmin2)) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    public boolean setFlagGroupOnPlayer(CommandSender sender, String target, String flaggroup, String state, boolean resadmin2) {
        ResidencePlayer rplayer;
        if (!FlagPermissions.validFlagGroups.containsKey(flaggroup)) {
            return false;
        }
        Set<String> flags2 = FlagPermissions.validFlagGroups.get(flaggroup);
        boolean changed = false;
        boolean changedAll = true;
        StringBuilder flagString = new StringBuilder();
        for (String flag : flags2) {
            if (this.setPlayerFlag(sender, target, flag, state, resadmin2, false)) {
                changed = true;
                if (!flagString.toString().isEmpty()) {
                    flagString.append(lm.info_listSplitter.getMessage(new Object[0]));
                }
                flagString.append(flag);
                continue;
            }
            changedAll = false;
        }
        if (changedAll && (rplayer = Residence.getInstance().getPlayerManager().getResidencePlayer(target)) != null) {
            rplayer.addTrustedResidence(this.residence);
        }
        if (!flagString.toString().isEmpty()) {
            Residence.getInstance().msg(sender, lm.Flag_Set, flagString, target, state);
        }
        return changed;
    }

    public String getOwnerLastKnownName() {
        return this.ownerLastKnownName;
    }

    public void setOwnerLastKnownName(String ownerLastKnownName) {
        this.ownerLastKnownName = ownerLastKnownName;
    }

    public static boolean isEventCallsSuspended() {
        return suspendEventCalls;
    }

    public static void setEventCallsSuspended(boolean suspendEventCalls) {
        ResidencePermissions.suspendEventCalls = suspendEventCalls;
    }
}

