/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.slimeFun;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.listeners.ResidenceBlockListener;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.ProtectionModule;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SlimeFunResidenceModule
implements ProtectionModule {
    private final Residence residence;

    public SlimeFunResidenceModule(Plugin plugin) {
        this.residence = (Residence)plugin;
    }

    public Plugin getPlugin() {
        return this.residence;
    }

    public void load() {
    }

    public boolean hasPermission(OfflinePlayer op, Location loc, Interaction action) {
        if (op == null) {
            return false;
        }
        switch (action) {
            case INTERACT_BLOCK: {
                ClaimedResidence res = this.residence.getResidenceManager().getByLoc(loc);
                if (res == null) break;
                boolean allow = res.getPermissions().playerHas(ResidencePlayer.get(op.getUniqueId()), Flags.container, false);
                if (!allow) {
                    this.residence.msg((CommandSender)op.getPlayer(), lm.Flag_Deny, new Object[]{Flags.container});
                }
                return allow;
            }
            case BREAK_BLOCK: {
                Player player = Bukkit.getPlayer((UUID)op.getUniqueId());
                if (player == null) {
                    return false;
                }
                return ResidenceBlockListener.canBreakBlock(player, loc.getBlock(), true);
            }
        }
        return true;
    }
}

