/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.utils;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.utils.Utils;
import com.shampaggon.crackshot.events.WeaponDamageEntityEvent;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class CrackShot
implements Listener {
    private Residence plugin;

    public CrackShot(Residence plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalKilling(WeaponDamageEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Entity damager = event.getDamager();
        if (!(damager instanceof Arrow) && !(damager instanceof Player)) {
            return;
        }
        Player cause = null;
        if (damager instanceof Arrow && !(((Arrow)damager).getShooter() instanceof Player)) {
            return;
        }
        cause = damager instanceof Player ? (Player)damager : (Player)((Arrow)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (this.plugin.isResAdminOn(cause)) {
            return;
        }
        if (!(event.getVictim() instanceof LivingEntity)) {
            return;
        }
        Entity entity = event.getVictim();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (Utils.isAnimal(entity) && res != null && res.getPermissions().playerHas(cause, Flags.animalkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
            cause.sendMessage(this.plugin.msg(lm.Residence_FlagDeny, new Object[]{Flags.animalkilling, res.getName()}));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByEntityEvent(WeaponDamageEntityEvent event) {
        Player player;
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getVictim().getType() != EntityType.ITEM_FRAME && !Utils.isArmorStandEntity(event.getVictim().getType())) {
            return;
        }
        Entity dmgr = event.getDamager();
        if (event.getDamager() instanceof Player) {
            player = (Player)event.getDamager();
        } else if (dmgr instanceof Projectile && ((Projectile)dmgr).getShooter() instanceof Player) {
            player = (Player)((Projectile)dmgr).getShooter();
        } else {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Location loc = event.getVictim().getLocation();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res != null && res.getPermissions().playerHas(player, Flags.container, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.container, res.getName()});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(WeaponDamageEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!(event.getVictim() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getVictim();
        if (victim.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence area2 = this.plugin.getResidenceManager().getByLoc(victim.getLocation());
        Player damager = event.getPlayer();
        ClaimedResidence srcarea = null;
        if (damager == null) {
            return;
        }
        srcarea = this.plugin.getResidenceManager().getByLoc(damager.getLocation());
        boolean srcpvp = true;
        if (srcarea != null) {
            srcpvp = srcarea.getPermissions().has(Flags.pvp, true);
        }
        if (!srcpvp) {
            damager.sendMessage(this.plugin.msg(lm.General_NoPVPZone, new Object[0]));
            event.setCancelled(true);
            return;
        }
        if (area2 == null) {
            if (!this.plugin.getWorldFlags().getPerms(damager.getWorld().getName()).has(Flags.pvp, true)) {
                damager.sendMessage(this.plugin.msg(lm.General_WorldPVPDisabled, new Object[0]));
                event.setCancelled(true);
            }
        } else if (!area2.getPermissions().has(Flags.pvp, true)) {
            damager.sendMessage(this.plugin.msg(lm.General_NoPVPZone, new Object[0]));
            event.setCancelled(true);
        }
    }
}

