/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.database;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.coreprotect.CoreProtect;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Lookup;
import net.coreprotect.database.statement.UserStatement;
import net.coreprotect.language.Phrase;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.paper.PaperAdapter;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.thread.Scheduler;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.ChestTool;
import net.coreprotect.utility.Teleport;
import net.coreprotect.utility.Util;
import net.coreprotect.utility.entity.HangingUtil;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Jukebox;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.block.data.type.Snow;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.block.data.type.TechnicalPiston;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.io.BukkitObjectInputStream;

public class Rollback
extends Queue {
    public static List<String[]> performRollbackRestore(Statement statement, CommandSender user, List<String> checkUuids, List<String> checkUsers, String timeString, List<Object> restrictList, Map<Object, Boolean> excludeList, List<String> excludeUserList, List<Integer> actionList, Location location, Integer[] radius, long startTime, long endTime, boolean restrictWorld, boolean lookup, boolean verbose, int rollbackType, int preview) {
        ArrayList<String[]> list = new ArrayList();
        try {
            long chunkKey;
            long timeStart = System.currentTimeMillis();
            List<Object> lookupList = new ArrayList();
            if (!(actionList.contains(4) || actionList.contains(5) || checkUsers.contains("#container"))) {
                lookupList = Lookup.performLookupRaw(statement, user, checkUuids, checkUsers, restrictList, excludeList, excludeUserList, actionList, location, radius, null, startTime, endTime, -1, -1, restrictWorld, lookup);
            }
            if (lookupList == null) {
                return null;
            }
            boolean ROLLBACK_ITEMS = false;
            ArrayList<Object> itemRestrictList = new ArrayList<Object>(restrictList);
            HashMap<Object, Boolean> itemExcludeList = new HashMap<Object, Boolean>(excludeList);
            if (actionList.contains(1)) {
                for (Object target : restrictList) {
                    if (!(target instanceof Material) || excludeList.containsKey(target) || !BlockGroup.CONTAINERS.contains(target)) continue;
                    ROLLBACK_ITEMS = true;
                    itemRestrictList.clear();
                    itemExcludeList.clear();
                    break;
                }
            }
            ArrayList<Object[]> itemList = new ArrayList();
            if (Config.getGlobal().ROLLBACK_ITEMS && !checkUsers.contains("#container") && (actionList.size() == 0 || actionList.contains(4) || ROLLBACK_ITEMS) && preview == 0) {
                ArrayList<Integer> itemActionList = new ArrayList<Integer>(actionList);
                if (!itemActionList.contains(4)) {
                    itemActionList.add(4);
                }
                itemExcludeList.entrySet().removeIf(entry -> Boolean.TRUE.equals(entry.getValue()));
                itemList = Lookup.performLookupRaw(statement, user, checkUuids, checkUsers, itemRestrictList, itemExcludeList, excludeUserList, itemActionList, location, radius, null, startTime, endTime, -1, -1, restrictWorld, lookup);
            }
            LinkedHashSet<Integer> worldList = new LinkedHashSet<Integer>();
            TreeMap<Long, Integer> chunkList = new TreeMap<Long, Integer>();
            HashMap dataList = new HashMap();
            HashMap itemDataList = new HashMap();
            boolean inventoryRollback = actionList.contains(11);
            int worldId = -1;
            int worldMin = 0;
            int worldMax = 2032;
            for (int listC = 0; listC < 2; ++listC) {
                List<Object> scanList = lookupList;
                if (listC == 1) {
                    scanList = itemList;
                }
                for (Object[] objectArray : scanList) {
                    int userId = (Integer)objectArray[2];
                    int n = (Integer)objectArray[3];
                    int rowY = (Integer)objectArray[4];
                    int rowZ = (Integer)objectArray[5];
                    int rowWorldId = (Integer)objectArray[10];
                    int chunkX = n >> 4;
                    int chunkZ = rowZ >> 4;
                    long l = chunkKey = inventoryRollback ? 0L : (long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32;
                    if (rowWorldId != worldId) {
                        String world = Util.getWorldName(rowWorldId);
                        World bukkitWorld = Bukkit.getServer().getWorld(world);
                        if (bukkitWorld != null) {
                            worldMin = BukkitAdapter.ADAPTER.getMinHeight(bukkitWorld);
                            worldMax = bukkitWorld.getMaxHeight();
                        }
                    }
                    if (chunkList.get(chunkKey) == null) {
                        int distance = 0;
                        if (location != null) {
                            distance = (int)Math.sqrt(Math.pow((Integer)objectArray[3] - location.getBlockX(), 2.0) + Math.pow((Integer)objectArray[5] - location.getBlockZ(), 2.0));
                        }
                        chunkList.put(chunkKey, distance);
                    }
                    if (ConfigHandler.playerIdCacheReversed.get(userId) == null) {
                        UserStatement.loadName(statement.getConnection(), userId);
                    }
                    HashMap modifyList = dataList;
                    if (listC == 1) {
                        modifyList = itemDataList;
                    }
                    if (modifyList.get(rowWorldId) == null) {
                        dataList.put(rowWorldId, new HashMap());
                        itemDataList.put(rowWorldId, new HashMap());
                        worldList.add(rowWorldId);
                    }
                    if (((HashMap)modifyList.get(rowWorldId)).get(chunkKey) == null) {
                        ((HashMap)dataList.get(rowWorldId)).put(chunkKey, new ArrayList());
                        ((HashMap)itemDataList.get(rowWorldId)).put(chunkKey, new ArrayList());
                    }
                    ((ArrayList)((HashMap)modifyList.get(rowWorldId)).get(chunkKey)).add(objectArray);
                }
            }
            if (rollbackType == 1) {
                Iterator dlIterator = dataList.entrySet().iterator();
                while (dlIterator.hasNext()) {
                    for (ArrayList arrayList : ((HashMap)dlIterator.next().getValue()).values()) {
                        Collections.reverse(arrayList);
                    }
                }
                dlIterator = itemDataList.entrySet().iterator();
                while (dlIterator.hasNext()) {
                    for (ArrayList arrayList : ((HashMap)dlIterator.next().getValue()).values()) {
                        Collections.reverse(arrayList);
                    }
                }
            }
            Integer chunkCount = 0;
            String userString = "#server";
            if (user != null) {
                userString = user.getName();
                if (verbose && preview == 0 && !actionList.contains(11)) {
                    Integer n = chunkList.size();
                    Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_CHUNKS_FOUND, n.toString(), n == 1 ? "{1}" : "{2}"));
                }
            }
            if (preview == 0) {
                if (actionList.contains(11)) {
                    ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                    ArrayList<Object[]> inventoryList = new ArrayList<Object[]>();
                    ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
                    for (Object[] data : itemList) {
                        int table = (Integer)data[14];
                        if (table == 2) {
                            inventoryList.add(data);
                            continue;
                        }
                        if (table == 1) {
                            arrayList2.add(data);
                            continue;
                        }
                        arrayList.add(data);
                    }
                    Queue.queueRollbackUpdate(userString, location, inventoryList, 27, rollbackType);
                    Queue.queueRollbackUpdate(userString, location, arrayList2, 28, rollbackType);
                    Queue.queueRollbackUpdate(userString, location, arrayList, 29, rollbackType);
                } else {
                    Queue.queueRollbackUpdate(userString, location, lookupList, 7, rollbackType);
                    Queue.queueRollbackUpdate(userString, location, itemList, 8, rollbackType);
                }
            }
            ConfigHandler.rollbackHash.put(userString, new int[]{0, 0, 0, 0, 0});
            String string = userString;
            for (Map.Entry entry2 : Util.entriesSortedByValues(chunkList)) {
                int n;
                World bukkitRollbackWorld;
                Integer rowY = chunkCount;
                chunkCount = chunkCount + 1;
                int itemCount = 0;
                int blockCount = 0;
                int entityCount = 0;
                int scannedWorldData = 0;
                int[] rollbackHashData = ConfigHandler.rollbackHash.get(string);
                itemCount = rollbackHashData[0];
                blockCount = rollbackHashData[1];
                entityCount = rollbackHashData[2];
                scannedWorldData = rollbackHashData[4];
                chunkKey = (Long)entry2.getKey();
                int finalChunkX = (int)chunkKey;
                int finalChunkZ = (int)(chunkKey >> 32);
                CommandSender finalUser = user;
                HashMap<Integer, World> worldMap = new HashMap<Integer, World>();
                Iterator<Object> iterator = worldList.iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    String rollbackWorld = Util.getWorldName(n2);
                    if (rollbackWorld.length() == 0 || (bukkitRollbackWorld = Bukkit.getServer().getWorld(rollbackWorld)) == null) continue;
                    worldMap.put(n2, bukkitRollbackWorld);
                }
                ConfigHandler.rollbackHash.put(string, new int[]{itemCount, blockCount, entityCount, 0, scannedWorldData});
                for (Map.Entry entry3 : worldMap.entrySet()) {
                    Integer rollbackWorldId = (Integer)entry3.getKey();
                    bukkitRollbackWorld = (World)entry3.getValue();
                    Location chunkLocation = new Location(bukkitRollbackWorld, (double)(finalChunkX << 4), 0.0, (double)(finalChunkZ << 4));
                    HashMap finalBlockList = (HashMap)dataList.get(rollbackWorldId);
                    HashMap finalItemList = (HashMap)itemDataList.get(rollbackWorldId);
                    Scheduler.scheduleSyncDelayedTask(CoreProtect.getInstance(), () -> {
                        try {
                            boolean clearInventories = false;
                            if (Config.getGlobal().ROLLBACK_ITEMS) {
                                clearInventories = true;
                            }
                            ArrayList data = finalBlockList.getOrDefault(chunkKey, new ArrayList());
                            ArrayList itemData = finalItemList.getOrDefault(chunkKey, new ArrayList());
                            LinkedHashMap<Block, BlockData> chunkChanges = new LinkedHashMap<Block, BlockData>();
                            for (Object[] objectArray : data) {
                                int zmax;
                                Block block;
                                World bukkitWorld;
                                String world;
                                int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                                int[] rollbackHashData1 = ConfigHandler.rollbackHash.get(finalUserString);
                                int itemCount1 = rollbackHashData1[0];
                                int blockCount1 = rollbackHashData1[1];
                                int entityCount1 = rollbackHashData1[2];
                                int scannedWorlds = rollbackHashData1[4];
                                int rowTime = (Integer)objectArray[1];
                                int rowUserId = (Integer)objectArray[2];
                                int n = (Integer)objectArray[3];
                                int rowY = (Integer)objectArray[4];
                                int rowZ = (Integer)objectArray[5];
                                int rowTypeRaw = (Integer)objectArray[6];
                                int rowData = (Integer)objectArray[7];
                                int rowAction = (Integer)objectArray[8];
                                int rowRolledBack = Util.rolledBack((Integer)objectArray[9], false);
                                int rowWorldId = (Integer)objectArray[10];
                                byte[] rowMeta = (byte[])objectArray[12];
                                byte[] rowBlockData = (byte[])objectArray[13];
                                String blockDataString = Util.byteDataToString(rowBlockData, rowTypeRaw);
                                Material rowType = Util.getType(rowTypeRaw);
                                List meta = null;
                                if (rowMeta != null) {
                                    ByteArrayInputStream metaByteStream = new ByteArrayInputStream(rowMeta);
                                    BukkitObjectInputStream metaObjectStream = new BukkitObjectInputStream((InputStream)metaByteStream);
                                    List metaList = (List)metaObjectStream.readObject();
                                    metaObjectStream.close();
                                    metaByteStream.close();
                                    meta = metaList;
                                }
                                BlockData blockData = null;
                                if (blockDataString != null && blockDataString.contains(":")) {
                                    try {
                                        blockData = Bukkit.getServer().createBlockData(blockDataString);
                                    }
                                    catch (Exception metaObjectStream) {
                                        // empty catch block
                                    }
                                }
                                BlockData rawBlockData = null;
                                if (blockData != null) {
                                    rawBlockData = blockData.clone();
                                }
                                if (rawBlockData == null && rowType != null && rowType.isBlock()) {
                                    rawBlockData = Util.createBlockData(rowType);
                                }
                                String rowUser = ConfigHandler.playerIdCacheReversed.get(rowUserId);
                                int oldTypeRaw = rowTypeRaw;
                                Material oldTypeMaterial = Util.getType(oldTypeRaw);
                                if (rowAction == 1 && rollbackType == 0) {
                                    rowType = Material.AIR;
                                    blockData = null;
                                    rowTypeRaw = 0;
                                } else if (rowAction == 0 && rollbackType == 1) {
                                    rowType = Material.AIR;
                                    blockData = null;
                                    rowTypeRaw = 0;
                                } else if (rowAction == 4 && rollbackType == 0) {
                                    rowType = null;
                                    rowTypeRaw = 0;
                                } else if (rowAction == 3 && rollbackType == 1) {
                                    rowType = null;
                                    rowTypeRaw = 0;
                                }
                                if (preview > 0) {
                                    if (rowAction != 3) {
                                        world = Util.getWorldName(rowWorldId);
                                        if (world.length() == 0 || (bukkitWorld = Bukkit.getServer().getWorld(world)) == null) continue;
                                        block = new Location(bukkitWorld, (double)n, (double)rowY, (double)rowZ).getBlock();
                                        if (preview == 2) {
                                            Material blockType = block.getType();
                                            if (!(BukkitAdapter.ADAPTER.isItemFrame(blockType) || blockType.equals((Object)Material.PAINTING) || blockType.equals((Object)Material.ARMOR_STAND) || blockType.equals((Object)Material.END_CRYSTAL))) {
                                                Util.prepareTypeAndData(chunkChanges, block, blockType, block.getBlockData(), true);
                                            }
                                        } else if (!BukkitAdapter.ADAPTER.isItemFrame(rowType) && rowType != Material.PAINTING && rowType != Material.ARMOR_STAND && rowType != Material.END_CRYSTAL) {
                                            Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, true);
                                            ++blockCount1;
                                        }
                                    }
                                } else if (rowAction == 3) {
                                    world = Util.getWorldName(rowWorldId);
                                    if (world.length() == 0 || (bukkitWorld = Bukkit.getServer().getWorld(world)) == null) continue;
                                    block = bukkitWorld.getBlockAt(n, rowY, rowZ);
                                    if (!bukkitWorld.isChunkLoaded(block.getChunk())) {
                                        bukkitWorld.getChunkAt(block.getLocation());
                                    }
                                    if (rowTypeRaw > 0) {
                                        if (rowRolledBack == 0) {
                                            EntityType entity_type = Util.getEntityType(rowTypeRaw);
                                            Queue.queueEntitySpawn(rowUser, block.getState(), entity_type, rowData);
                                            ++entityCount1;
                                        }
                                    } else if (oldTypeRaw > 0 && rowRolledBack == 1) {
                                        boolean removed = false;
                                        int entityId = -1;
                                        String entityName = Util.getEntityType(oldTypeRaw).name();
                                        String token = n + "." + rowY + "." + rowZ + "." + rowWorldId + "." + entityName;
                                        Object[] cachedEntity = CacheHandler.entityCache.get(token);
                                        if (cachedEntity != null) {
                                            entityId = (Integer)cachedEntity[1];
                                        }
                                        int xmin = n - 5;
                                        int xmax = n + 5;
                                        int ymin = rowY - 1;
                                        int ymax = rowY + 1;
                                        int zmin = rowZ - 5;
                                        zmax = rowZ + 5;
                                        for (Entity entity : block.getChunk().getEntities()) {
                                            if (entityId > -1) {
                                                int id = entity.getEntityId();
                                                if (id != entityId) continue;
                                                ++entityCount1;
                                                removed = true;
                                                entity.remove();
                                                break;
                                            }
                                            if (!entity.getType().equals((Object)Util.getEntityType(oldTypeRaw))) continue;
                                            Location entityLocation = entity.getLocation();
                                            int entityx = entityLocation.getBlockX();
                                            int entityY = entityLocation.getBlockY();
                                            int entityZ = entityLocation.getBlockZ();
                                            if (entityx < xmin || entityx > xmax || entityY < ymin || entityY > ymax || entityZ < zmin || entityZ > zmax) continue;
                                            ++entityCount1;
                                            removed = true;
                                            entity.remove();
                                            break;
                                        }
                                        if (!removed && entityId > -1) {
                                            for (Entity entity : block.getWorld().getLivingEntities()) {
                                                int id = entity.getEntityId();
                                                if (id != entityId) continue;
                                                ++entityCount1;
                                                removed = true;
                                                entity.remove();
                                                break;
                                            }
                                        }
                                    }
                                } else {
                                    boolean changeBlock;
                                    block194: {
                                        if (rowType == null || (world = Util.getWorldName(rowWorldId)).length() == 0 || (bukkitWorld = Bukkit.getServer().getWorld(world)) == null) continue;
                                        block = bukkitWorld.getBlockAt(n, rowY, rowZ);
                                        if (!bukkitWorld.isChunkLoaded(block.getChunk())) {
                                            bukkitWorld.getChunkAt(block.getLocation());
                                        }
                                        changeBlock = true;
                                        boolean countBlock = true;
                                        Material changeType = block.getType();
                                        BlockData changeBlockData = block.getBlockData();
                                        BlockData pendingChangeData = (BlockData)chunkChanges.get(block);
                                        Material pendingChangeType = changeType;
                                        if (pendingChangeData != null) {
                                            pendingChangeType = pendingChangeData.getMaterial();
                                        } else {
                                            pendingChangeData = changeBlockData;
                                        }
                                        if (rowRolledBack == 1 && rollbackType == 0) {
                                            countBlock = false;
                                        }
                                        if (rowType == pendingChangeType && !BukkitAdapter.ADAPTER.isItemFrame(oldTypeMaterial) && oldTypeMaterial != Material.PAINTING && oldTypeMaterial != Material.ARMOR_STAND && oldTypeMaterial != Material.END_CRYSTAL) {
                                            BlockData checkData;
                                            BlockData blockData2 = checkData = rowType == Material.AIR ? blockData : rawBlockData;
                                            if (checkData != null) {
                                                if ((checkData.getAsString().equals(pendingChangeData.getAsString()) || checkData instanceof MultipleFacing || checkData instanceof Stairs || checkData instanceof RedstoneWire) && rowType != Material.CHEST && rowType != Material.TRAPPED_CHEST) {
                                                    changeBlock = false;
                                                }
                                            } else if (rowType == Material.AIR) {
                                                changeBlock = false;
                                            }
                                            countBlock = false;
                                        } else if (pendingChangeType != Material.AIR && pendingChangeType != Material.CAVE_AIR) {
                                            countBlock = true;
                                        }
                                        if (pendingChangeType == Material.WATER && rowType != Material.AIR && rowType != Material.CAVE_AIR && blockData != null && blockData instanceof Waterlogged && Material.WATER.createBlockData().equals(block.getBlockData())) {
                                            Waterlogged waterlogged = (Waterlogged)blockData;
                                            waterlogged.setWaterlogged(true);
                                        }
                                        try {
                                            if (!changeBlock) break block194;
                                            if (changeBlockData instanceof PistonHead) {
                                                PistonHead pistonHead = (PistonHead)changeBlockData;
                                                Block pistonBlock = block.getRelative(pistonHead.getFacing().getOppositeFace());
                                                BlockData pistonData = pistonBlock.getBlockData();
                                                if (pistonData instanceof Piston) {
                                                    Piston piston = (Piston)pistonData;
                                                    piston.setExtended(false);
                                                    pistonBlock.setBlockData((BlockData)piston, false);
                                                }
                                            } else if (rowType == Material.MOVING_PISTON && blockData instanceof TechnicalPiston && !(blockData instanceof PistonHead)) {
                                                TechnicalPiston technicalPiston = (TechnicalPiston)blockData;
                                                rowType = technicalPiston.getType() == TechnicalPiston.Type.STICKY ? Material.STICKY_PISTON : Material.PISTON;
                                                blockData = rowType.createBlockData();
                                                ((Piston)blockData).setFacing(technicalPiston.getFacing());
                                            }
                                            if (rowType == Material.AIR && (BukkitAdapter.ADAPTER.isItemFrame(oldTypeMaterial) || oldTypeMaterial == Material.PAINTING)) {
                                                HangingUtil.removeHanging(block.getState(), blockDataString);
                                                break block194;
                                            }
                                            if (BukkitAdapter.ADAPTER.isItemFrame(rowType) || rowType == Material.PAINTING) {
                                                HangingUtil.spawnHanging(block.getState(), rowType, blockDataString, rowData);
                                                break block194;
                                            }
                                            if (rowType == Material.ARMOR_STAND) {
                                                Location location1 = block.getLocation();
                                                location1.setX(location1.getX() + 0.5);
                                                location1.setZ(location1.getZ() + 0.5);
                                                location1.setYaw((float)rowData);
                                                boolean exists = false;
                                                Entity[] pistonData = block.getChunk().getEntities();
                                                int piston = pistonData.length;
                                                for (zmax = 0; zmax < piston; ++zmax) {
                                                    Entity entity = pistonData[zmax];
                                                    if (!(entity instanceof ArmorStand) || entity.getLocation().getBlockX() != location1.getBlockX() || entity.getLocation().getBlockY() != location1.getBlockY() || entity.getLocation().getBlockZ() != location1.getBlockZ()) continue;
                                                    exists = true;
                                                }
                                                if (!exists) {
                                                    Entity entity = block.getLocation().getWorld().spawnEntity(location1, EntityType.ARMOR_STAND);
                                                    PaperAdapter.ADAPTER.teleportAsync(entity, location1);
                                                }
                                                break block194;
                                            }
                                            if (rowType == Material.END_CRYSTAL) {
                                                Location location1 = block.getLocation();
                                                location1.setX(location1.getX() + 0.5);
                                                location1.setZ(location1.getZ() + 0.5);
                                                boolean exists = false;
                                                Entity entity = block.getChunk().getEntities();
                                                int piston = ((Entity[])entity).length;
                                                for (zmax = 0; zmax < piston; ++zmax) {
                                                    Entity entity2 = entity[zmax];
                                                    if (!(entity2 instanceof EnderCrystal) || entity2.getLocation().getBlockX() != location1.getBlockX() || entity2.getLocation().getBlockY() != location1.getBlockY() || entity2.getLocation().getBlockZ() != location1.getBlockZ()) continue;
                                                    exists = true;
                                                }
                                                if (!exists) {
                                                    entity = block.getLocation().getWorld().spawnEntity(location1, EntityType.ENDER_CRYSTAL);
                                                    EnderCrystal enderCrystal = (EnderCrystal)entity;
                                                    enderCrystal.setShowingBottom(rowData != 0);
                                                    PaperAdapter.ADAPTER.teleportAsync(entity, location1);
                                                }
                                                break block194;
                                            }
                                            if (rowType == Material.AIR && oldTypeMaterial == Material.WATER) {
                                                if (pendingChangeData instanceof Waterlogged) {
                                                    Waterlogged waterlogged = (Waterlogged)pendingChangeData;
                                                    waterlogged.setWaterlogged(false);
                                                    Util.prepareTypeAndData(chunkChanges, block, null, (BlockData)waterlogged, false);
                                                } else {
                                                    Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, true);
                                                }
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                                break block194;
                                            }
                                            if (rowType == Material.AIR && oldTypeMaterial == Material.SNOW) {
                                                Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, true);
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                                break block194;
                                            }
                                            if (rowType == Material.AIR && oldTypeMaterial == Material.END_CRYSTAL) {
                                                for (Entity entity : block.getChunk().getEntities()) {
                                                    if (!(entity instanceof EnderCrystal) || entity.getLocation().getBlockX() != n || entity.getLocation().getBlockY() != rowY || entity.getLocation().getBlockZ() != rowZ) continue;
                                                    entity.remove();
                                                }
                                                break block194;
                                            }
                                            if (rollbackType == 0 && rowAction == 0 && rowType == Material.AIR) break block194;
                                            if (rowType == Material.AIR || rowType == Material.TNT) {
                                                if (clearInventories) {
                                                    if (BlockGroup.CONTAINERS.contains(changeType)) {
                                                        Inventory inventory = Util.getContainerInventory(block.getState(), false);
                                                        if (inventory != null) {
                                                            inventory.clear();
                                                        }
                                                    } else if (BlockGroup.CONTAINERS.contains(Material.ARMOR_STAND) && oldTypeMaterial == Material.ARMOR_STAND) {
                                                        for (Entity entity : block.getChunk().getEntities()) {
                                                            if (!(entity instanceof ArmorStand)) continue;
                                                            Location entityLocation = entity.getLocation();
                                                            entityLocation.setY(entityLocation.getY() + 0.99);
                                                            if (entityLocation.getBlockX() != n || entityLocation.getBlockY() != rowY || entityLocation.getBlockZ() != rowZ) continue;
                                                            EntityEquipment equipment = Util.getEntityEquipment((LivingEntity)entity);
                                                            if (equipment != null) {
                                                                equipment.clear();
                                                            }
                                                            entityLocation.setY(entityLocation.getY() - 1.99);
                                                            PaperAdapter.ADAPTER.teleportAsync(entity, entityLocation);
                                                            entity.remove();
                                                        }
                                                    }
                                                }
                                                boolean remove = true;
                                                if (rowType == Material.AIR) {
                                                    Waterlogged waterlogged;
                                                    if (pendingChangeData instanceof Waterlogged) {
                                                        Waterlogged waterlogged2 = (Waterlogged)pendingChangeData;
                                                        if (waterlogged2.isWaterlogged()) {
                                                            Util.prepareTypeAndData(chunkChanges, block, Material.WATER, Material.WATER.createBlockData(), true);
                                                            remove = false;
                                                        }
                                                    } else if (pendingChangeType == Material.WATER && rawBlockData instanceof Waterlogged && (waterlogged = (Waterlogged)rawBlockData).isWaterlogged()) {
                                                        remove = false;
                                                    }
                                                }
                                                if (remove) {
                                                    Bed bed;
                                                    boolean physics = true;
                                                    if (changeType == Material.NETHER_PORTAL || changeBlockData instanceof MultipleFacing || changeBlockData instanceof Snow || changeBlockData instanceof Stairs || changeBlockData instanceof RedstoneWire || changeBlockData instanceof Chest) {
                                                        physics = true;
                                                    } else if (changeBlockData instanceof Bisected && !(changeBlockData instanceof TrapDoor)) {
                                                        Bisected bisected = (Bisected)changeBlockData;
                                                        Location bisectLocation = block.getLocation().clone();
                                                        if (bisected.getHalf() == Bisected.Half.TOP) {
                                                            bisectLocation.setY(bisectLocation.getY() - 1.0);
                                                        } else {
                                                            bisectLocation.setY(bisectLocation.getY() + 1.0);
                                                        }
                                                        int worldMaxHeight = bukkitWorld.getMaxHeight();
                                                        int worldMinHeight = BukkitAdapter.ADAPTER.getMinHeight(bukkitWorld);
                                                        if (bisectLocation.getBlockY() >= worldMinHeight && bisectLocation.getBlockY() < worldMaxHeight) {
                                                            Block bisectBlock = block.getWorld().getBlockAt(bisectLocation);
                                                            Util.prepareTypeAndData(chunkChanges, bisectBlock, rowType, null, false);
                                                            if (countBlock) {
                                                                ++blockCount1;
                                                            }
                                                        }
                                                    } else if (changeBlockData instanceof Bed && (bed = (Bed)changeBlockData).getPart() == Bed.Part.FOOT) {
                                                        Block adjacentBlock = block.getRelative(bed.getFacing());
                                                        Util.prepareTypeAndData(chunkChanges, adjacentBlock, rowType, null, false);
                                                    }
                                                    Util.prepareTypeAndData(chunkChanges, block, rowType, null, physics);
                                                }
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                                break block194;
                                            }
                                            if (rowType == Material.SPAWNER) {
                                                try {
                                                    Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                                                    CreatureSpawner mobSpawner = (CreatureSpawner)block.getState();
                                                    mobSpawner.setSpawnedType(Util.getSpawnerType(rowData));
                                                    mobSpawner.update();
                                                    if (countBlock) {
                                                        ++blockCount1;
                                                    }
                                                    break block194;
                                                }
                                                catch (Exception mobSpawner) {}
                                                break block194;
                                            }
                                            if (rowType == Material.SKELETON_SKULL || rowType == Material.SKELETON_WALL_SKULL || rowType == Material.WITHER_SKELETON_SKULL || rowType == Material.WITHER_SKELETON_WALL_SKULL || rowType == Material.ZOMBIE_HEAD || rowType == Material.ZOMBIE_WALL_HEAD || rowType == Material.PLAYER_HEAD || rowType == Material.PLAYER_WALL_HEAD || rowType == Material.CREEPER_HEAD || rowType == Material.CREEPER_WALL_HEAD || rowType == Material.DRAGON_HEAD || rowType == Material.DRAGON_WALL_HEAD) {
                                                Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                                                if (rowData > 0) {
                                                    Queue.queueSkullUpdate(rowUser, block.getState(), rowData);
                                                }
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                            } else if (BukkitAdapter.ADAPTER.isSign(rowType)) {
                                                Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                                                Queue.queueSignUpdate(rowUser, block.getState(), rollbackType, rowTime);
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                            } else if (BlockGroup.SHULKER_BOXES.contains(rowType)) {
                                                Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                                if (meta != null) {
                                                    Inventory inventory = Util.getContainerInventory(block.getState(), false);
                                                    for (Object value : meta) {
                                                        ItemStack item = Util.unserializeItemStackLegacy(value);
                                                        if (item == null) continue;
                                                        Rollback.modifyContainerItems(rowType, inventory, 0, item, 1);
                                                    }
                                                }
                                            } else if (rowType == Material.COMMAND_BLOCK || rowType == Material.REPEATING_COMMAND_BLOCK || rowType == Material.CHAIN_COMMAND_BLOCK) {
                                                Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                                if (meta != null) {
                                                    CommandBlock commandBlock = (CommandBlock)block.getState();
                                                    for (Object value : meta) {
                                                        if (!(value instanceof String)) continue;
                                                        String string = (String)value;
                                                        commandBlock.setCommand(string);
                                                        commandBlock.update();
                                                    }
                                                }
                                            } else if (rowType == Material.WATER) {
                                                if (pendingChangeData instanceof Waterlogged) {
                                                    Waterlogged waterlogged = (Waterlogged)pendingChangeData;
                                                    waterlogged.setWaterlogged(true);
                                                    Util.prepareTypeAndData(chunkChanges, block, null, (BlockData)waterlogged, false);
                                                } else {
                                                    Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                                                }
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                            } else if (rowType == Material.NETHER_PORTAL && rowAction == 0) {
                                                Util.prepareTypeAndData(chunkChanges, block, Material.FIRE, null, true);
                                            } else if (blockData == null && rowData > 0 && (rowType == Material.IRON_DOOR || BlockGroup.DOORS.contains(rowType))) {
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                                block.setType(rowType, false);
                                                Door door = (Door)block.getBlockData();
                                                if (rowData >= 8) {
                                                    door.setHalf(Bisected.Half.TOP);
                                                    rowData -= 8;
                                                } else {
                                                    door.setHalf(Bisected.Half.BOTTOM);
                                                }
                                                if (rowData >= 4) {
                                                    door.setHinge(Door.Hinge.RIGHT);
                                                    rowData -= 4;
                                                } else {
                                                    door.setHinge(Door.Hinge.LEFT);
                                                }
                                                BlockFace face = BlockFace.NORTH;
                                                switch (rowData) {
                                                    case 0: {
                                                        face = BlockFace.EAST;
                                                        break;
                                                    }
                                                    case 1: {
                                                        face = BlockFace.SOUTH;
                                                        break;
                                                    }
                                                    case 2: {
                                                        face = BlockFace.WEST;
                                                    }
                                                }
                                                door.setFacing(face);
                                                door.setOpen(false);
                                                block.setBlockData((BlockData)door, false);
                                            } else if (blockData == null && rowData > 0 && rowType.name().endsWith("_BED")) {
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                                block.setType(rowType, false);
                                                Bed bed = (Bed)block.getBlockData();
                                                BlockFace face = BlockFace.NORTH;
                                                if (rowData > 4) {
                                                    bed.setPart(Bed.Part.HEAD);
                                                    rowData -= 4;
                                                }
                                                switch (rowData) {
                                                    case 2: {
                                                        face = BlockFace.WEST;
                                                        break;
                                                    }
                                                    case 3: {
                                                        face = BlockFace.EAST;
                                                        break;
                                                    }
                                                    case 4: {
                                                        face = BlockFace.SOUTH;
                                                    }
                                                }
                                                bed.setFacing(face);
                                                block.setBlockData((BlockData)bed, false);
                                            } else if (rowType.name().endsWith("_BANNER")) {
                                                Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                                if (meta != null) {
                                                    Banner banner = (Banner)block.getState();
                                                    for (Object value : meta) {
                                                        if (value instanceof DyeColor) {
                                                            banner.setBaseColor((DyeColor)value);
                                                            continue;
                                                        }
                                                        if (!(value instanceof Map)) continue;
                                                        Pattern pattern = new Pattern((Map)value);
                                                        banner.addPattern(pattern);
                                                    }
                                                    banner.update();
                                                }
                                            } else if (rowType != changeType && (BlockGroup.CONTAINERS.contains(rowType) || BlockGroup.CONTAINERS.contains(changeType))) {
                                                block.setType(Material.AIR);
                                                boolean isChest = blockData instanceof Chest;
                                                Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, isChest);
                                                if (isChest) {
                                                    ChestTool.updateDoubleChest(block, blockData, false);
                                                }
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                            } else if (BlockGroup.UPDATE_STATE.contains(rowType) || rowType.name().contains("CANDLE")) {
                                                Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, true);
                                                ChestTool.updateDoubleChest(block, blockData, true);
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                            } else if (rowType != Material.AIR && rawBlockData instanceof Bisected && !(rawBlockData instanceof Stairs) && !(rawBlockData instanceof TrapDoor)) {
                                                Bisected bisected = (Bisected)rawBlockData;
                                                Bisected bisectData = (Bisected)rawBlockData.clone();
                                                Location bisectLocation = block.getLocation().clone();
                                                if (bisected.getHalf() == Bisected.Half.TOP) {
                                                    bisectData.setHalf(Bisected.Half.BOTTOM);
                                                    bisectLocation.setY(bisectLocation.getY() - 1.0);
                                                } else {
                                                    bisectData.setHalf(Bisected.Half.TOP);
                                                    bisectLocation.setY(bisectLocation.getY() + 1.0);
                                                }
                                                int worldMaxHeight = bukkitWorld.getMaxHeight();
                                                int worldMinHeight = BukkitAdapter.ADAPTER.getMinHeight(bukkitWorld);
                                                if (bisectLocation.getBlockY() >= worldMinHeight && bisectLocation.getBlockY() < worldMaxHeight) {
                                                    Block bisectBlock = block.getWorld().getBlockAt(bisectLocation);
                                                    Util.prepareTypeAndData(chunkChanges, bisectBlock, rowType, (BlockData)bisectData, false);
                                                }
                                                Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, false);
                                                if (countBlock) {
                                                    ++blockCount1;
                                                    ++blockCount1;
                                                }
                                            } else if (rowType != Material.AIR && rawBlockData instanceof Bed) {
                                                Bed bed = (Bed)rawBlockData;
                                                if (bed.getPart() == Bed.Part.FOOT) {
                                                    Block adjacentBlock = block.getRelative(bed.getFacing());
                                                    Bed bedData = (Bed)rawBlockData.clone();
                                                    bedData.setPart(Bed.Part.HEAD);
                                                    Util.prepareTypeAndData(chunkChanges, adjacentBlock, rowType, (BlockData)bedData, false);
                                                    if (countBlock) {
                                                        ++blockCount1;
                                                    }
                                                }
                                                Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, true);
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                            } else {
                                                boolean physics = true;
                                                Util.prepareTypeAndData(chunkChanges, block, rowType, blockData, physics);
                                                if (countBlock) {
                                                    ++blockCount1;
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    if (rowType != Material.AIR && changeBlock && rowUser.length() > 0) {
                                        CacheHandler.lookupCache.put(n + "." + rowY + "." + rowZ + "." + rowWorldId, new Object[]{unixtimestamp, rowUser, rowType});
                                    }
                                }
                                ConfigHandler.rollbackHash.put(finalUserString, new int[]{itemCount1, ++blockCount1, ++entityCount1, 0, scannedWorlds});
                            }
                            data.clear();
                            for (Map.Entry entry : chunkChanges.entrySet()) {
                                Block changeBlock = (Block)entry.getKey();
                                BlockData changeBlockData = (BlockData)entry.getValue();
                                if (preview > 0) {
                                    Util.sendBlockChange((Player)finalUser, changeBlock.getLocation(), changeBlockData);
                                    continue;
                                }
                                Util.setTypeAndData(changeBlock, null, changeBlockData, true);
                            }
                            chunkChanges.clear();
                            HashMap<Player, List> sortPlayers = new HashMap<Player, List>();
                            Object var17_24 = null;
                            Material containerType = null;
                            boolean containerInit = false;
                            int lastX = 0;
                            int lastY = 0;
                            int lastZ = 0;
                            int lastWorldId = 0;
                            String lastFace = "";
                            for (Object[] objectArray : itemData) {
                                int[] rollbackHashData1 = ConfigHandler.rollbackHash.get(finalUserString);
                                int itemCount1 = rollbackHashData1[0];
                                int blockCount1 = rollbackHashData1[1];
                                int entityCount1 = rollbackHashData1[2];
                                int scannedWorlds = rollbackHashData1[4];
                                int rowX = (Integer)objectArray[3];
                                int rowY = (Integer)objectArray[4];
                                int rowZ = (Integer)objectArray[5];
                                int rowTypeRaw = (Integer)objectArray[6];
                                int rowData = (Integer)objectArray[7];
                                int rowAction = (Integer)objectArray[8];
                                int rowRolledBack = Util.rolledBack((Integer)objectArray[9], false);
                                int rowWorldId = (Integer)objectArray[10];
                                int rowAmount = (Integer)objectArray[11];
                                byte[] rowMetadata = (byte[])objectArray[12];
                                Material rowType = Util.getType(rowTypeRaw);
                                int rolledBackInventory = Util.rolledBack((Integer)objectArray[9], true);
                                if (rowType != null) {
                                    if (inventoryRollback && (rollbackType == 0 && rolledBackInventory == 0 || rollbackType == 1 && rolledBackInventory == 1)) {
                                        int modifiedArmor;
                                        Player player;
                                        String uuid;
                                        Material inventoryItem = Util.itemFilter(rowType, (Integer)objectArray[14] == 0);
                                        int rowUserId = (Integer)objectArray[2];
                                        String rowUser = ConfigHandler.playerIdCacheReversed.get(rowUserId);
                                        if (rowUser == null || (uuid = ConfigHandler.uuidCache.get(rowUser.toLowerCase(Locale.ROOT))) == null || (player = Bukkit.getServer().getPlayer(UUID.fromString(uuid))) == null) continue;
                                        int inventoryAction = 0;
                                        inventoryAction = rowAction == 2 || rowAction == 3 || rowAction == 6 || rowAction == 7 || rowAction == 8 || rowAction == 9 || rowAction == 10 || rowAction == 11 || rowAction == 12 ? (rowAction == 3 || rowAction == 10 || rowAction == 12 ? 1 : 0) : (rowAction == 4 || rowAction == 5 ? (rowAction == 4 ? 1 : 0) : (rowAction == 0 ? 1 : 0));
                                        int action = rollbackType == 0 ? inventoryAction ^ 1 : inventoryAction;
                                        ItemStack itemstack = new ItemStack(inventoryItem, rowAmount);
                                        Object[] populatedStack = Rollback.populateItemStack(itemstack, rowMetadata);
                                        if (rowAction == 4 || rowAction == 5) {
                                            Rollback.modifyContainerItems(containerType, player.getEnderChest(), (Integer)populatedStack[0], ((ItemStack)populatedStack[2]).clone(), action ^ 1);
                                        }
                                        if ((modifiedArmor = Rollback.modifyContainerItems(containerType, player.getInventory(), (Integer)populatedStack[0], (ItemStack)populatedStack[2], action)) > -1) {
                                            List currentSortList = sortPlayers.getOrDefault(player, new ArrayList());
                                            if (!currentSortList.contains(modifiedArmor)) {
                                                currentSortList.add(modifiedArmor);
                                            }
                                            sortPlayers.put(player, currentSortList);
                                        }
                                        ConfigHandler.rollbackHash.put(finalUserString, new int[]{itemCount1 += rowAmount, blockCount1, entityCount1, 0, scannedWorlds});
                                        continue;
                                    }
                                    if (inventoryRollback || rowAction > 1) continue;
                                    if (rollbackType == 0 && rowRolledBack == 0 || rollbackType == 1 && rowRolledBack == 1) {
                                        void var17_25;
                                        ItemStack itemstack = new ItemStack(rowType, rowAmount);
                                        Object[] populatedStack = Rollback.populateItemStack(itemstack, rowMetadata);
                                        String faceData = (String)populatedStack[1];
                                        if (!containerInit || rowX != lastX || rowY != lastY || rowZ != lastZ || rowWorldId != lastWorldId || !faceData.equals(lastFace)) {
                                            World bukkitWorld;
                                            Object var17_26 = null;
                                            String world = Util.getWorldName(rowWorldId);
                                            if (world.length() == 0 || (bukkitWorld = Bukkit.getServer().getWorld(world)) == null) continue;
                                            Block block = bukkitWorld.getBlockAt(rowX, rowY, rowZ);
                                            if (!bukkitWorld.isChunkLoaded(block.getChunk())) {
                                                bukkitWorld.getChunkAt(block.getLocation());
                                            }
                                            if (BlockGroup.CONTAINERS.contains(block.getType())) {
                                                BlockState blockState = block.getState();
                                                if (blockState instanceof Jukebox) {
                                                    BlockState blockState2 = blockState;
                                                } else {
                                                    Inventory inventory = Util.getContainerInventory(blockState, false);
                                                }
                                                containerType = block.getType();
                                            } else if (BlockGroup.CONTAINERS.contains(Material.ARMOR_STAND) || BlockGroup.CONTAINERS.contains(Material.ITEM_FRAME)) {
                                                for (Entity entity : block.getChunk().getEntities()) {
                                                    if (entity.getLocation().getBlockX() != rowX || entity.getLocation().getBlockY() != rowY || entity.getLocation().getBlockZ() != rowZ) continue;
                                                    if (entity instanceof ArmorStand) {
                                                        EntityEquipment entityEquipment = Util.getEntityEquipment((LivingEntity)entity);
                                                        containerType = Material.ARMOR_STAND;
                                                        continue;
                                                    }
                                                    if (!(entity instanceof ItemFrame)) continue;
                                                    Entity entity2 = entity;
                                                    containerType = Material.ITEM_FRAME;
                                                    if (faceData.length() > 0 && BlockFace.valueOf((String)faceData) == ((ItemFrame)entity).getFacing()) break;
                                                }
                                            }
                                            lastX = rowX;
                                            lastY = rowY;
                                            lastZ = rowZ;
                                            lastWorldId = rowWorldId;
                                            lastFace = faceData;
                                        }
                                        if (var17_25 != null) {
                                            int action = 0;
                                            if (rollbackType == 0 && rowAction == 0) {
                                                action = 1;
                                            }
                                            if (rollbackType == 1 && rowAction == 1) {
                                                action = 1;
                                            }
                                            int slot = (Integer)populatedStack[0];
                                            itemstack = (ItemStack)populatedStack[2];
                                            Rollback.modifyContainerItems(containerType, var17_25, slot, itemstack, action);
                                            itemCount1 += rowAmount;
                                        }
                                        containerInit = true;
                                    }
                                }
                                ConfigHandler.rollbackHash.put(finalUserString, new int[]{itemCount1, blockCount1, entityCount1, 0, scannedWorlds});
                            }
                            itemData.clear();
                            for (Map.Entry entry : sortPlayers.entrySet()) {
                                Rollback.sortContainerItems(((Player)entry.getKey()).getInventory(), (List)entry.getValue());
                            }
                            sortPlayers.clear();
                            int[] rollbackHashData1 = ConfigHandler.rollbackHash.get(finalUserString);
                            int n = rollbackHashData1[0];
                            int blockCount1 = rollbackHashData1[1];
                            int entityCount1 = rollbackHashData1[2];
                            int scannedWorlds = rollbackHashData1[4];
                            ConfigHandler.rollbackHash.put(finalUserString, new int[]{n, blockCount1, entityCount1, 1, scannedWorlds + 1});
                            if (preview == 0) {
                                for (Player player : Bukkit.getOnlinePlayers()) {
                                    Location playerLocation = player.getLocation();
                                    String playerWorld = playerLocation.getWorld().getName();
                                    int chunkX = playerLocation.getBlockX() >> 4;
                                    int chunkZ = playerLocation.getBlockZ() >> 4;
                                    if (!bukkitRollbackWorld.getName().equals(playerWorld) || chunkX != finalChunkX || chunkZ != finalChunkZ) continue;
                                    Teleport.performSafeTeleport(player, playerLocation, false);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            int[] rollbackHashData1 = ConfigHandler.rollbackHash.get(finalUserString);
                            int itemCount1 = rollbackHashData1[0];
                            int blockCount1 = rollbackHashData1[1];
                            int entityCount1 = rollbackHashData1[2];
                            int n = rollbackHashData1[4];
                            ConfigHandler.rollbackHash.put(finalUserString, new int[]{itemCount1, blockCount1, entityCount1, 2, n + 1});
                        }
                    }, chunkLocation, 0);
                }
                rollbackHashData = ConfigHandler.rollbackHash.get(string);
                int next = rollbackHashData[3];
                int n3 = rollbackHashData[4];
                int sleepTime = 0;
                boolean abort = false;
                while (next == 0 || n < worldMap.size()) {
                    if (preview == 1) {
                        ++sleepTime;
                        Thread.sleep(1L);
                    } else {
                        sleepTime += 5;
                        Thread.sleep(5L);
                    }
                    rollbackHashData = ConfigHandler.rollbackHash.get(string);
                    next = rollbackHashData[3];
                    n = rollbackHashData[4];
                    if (sleepTime <= 300000) continue;
                    abort = true;
                    break;
                }
                if (abort || next == 2) {
                    Chat.console(Phrase.build(Phrase.ROLLBACK_ABORTED, new String[0]));
                    break;
                }
                rollbackHashData = ConfigHandler.rollbackHash.get(string);
                itemCount = rollbackHashData[0];
                blockCount = rollbackHashData[1];
                entityCount = rollbackHashData[2];
                ConfigHandler.rollbackHash.put(string, new int[]{itemCount, blockCount, entityCount, 0, 0});
                if (!verbose || user == null || preview != 0 || actionList.contains(11)) continue;
                Integer chunks = chunkList.size();
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_CHUNKS_MODIFIED, chunkCount.toString(), chunks.toString(), chunks == 1 ? "{1}" : "{2}"));
            }
            chunkList.clear();
            dataList.clear();
            itemDataList.clear();
            int[] rollbackHashData = ConfigHandler.rollbackHash.get(string);
            int n = rollbackHashData[0];
            int blockCount = rollbackHashData[1];
            int entityCount = rollbackHashData[2];
            long timeFinish = System.currentTimeMillis();
            double totalSeconds = (double)(timeFinish - timeStart) / 1000.0;
            if (user != null) {
                Rollback.finishRollbackRestore(user, location, checkUsers, restrictList, excludeList, excludeUserList, actionList, timeString, chunkCount, totalSeconds, n, blockCount, entityCount, rollbackType, radius, verbose, restrictWorld, preview);
            }
            list = Lookup.convertRawLookup(statement, lookupList);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static void finishRollbackRestore(CommandSender user, Location location, List<String> checkUsers, List<Object> restrictList, Map<Object, Boolean> excludeList, List<String> excludeUserList, List<Integer> actionList, String timeString, Integer chunkCount, Double seconds, Integer itemCount, Integer blockCount, Integer entityCount, int rollbackType, Integer[] radius, boolean verbose, boolean restrictWorld, int preview) {
        try {
            Object targetType;
            boolean entity;
            if (preview == 2) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.PREVIEW_CANCELLED, new String[0]));
                return;
            }
            Chat.sendMessage(user, "-----");
            StringBuilder usersBuilder = new StringBuilder();
            for (String value : checkUsers) {
                if (usersBuilder.length() == 0) {
                    usersBuilder = usersBuilder.append(value);
                    continue;
                }
                usersBuilder.append(", ").append(value);
            }
            Object users = usersBuilder.toString();
            if (((String)users).equals("#global") && restrictWorld) {
                users = "#" + location.getWorld().getName();
            }
            if (preview > 0) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_COMPLETED, new String[]{users, "{3}"}));
            } else if (rollbackType == 0) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_COMPLETED, new String[]{users, "{1}"}));
            } else if (rollbackType == 1) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_COMPLETED, new String[]{users, "{2}"}));
            }
            if (preview == 1 || rollbackType == 0 || rollbackType == 1) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_TIME, timeString));
            }
            if (radius != null) {
                int worldedit = radius[7];
                if (worldedit == 0) {
                    Integer rollbackRadius = radius[0];
                    Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_RADIUS, rollbackRadius.toString(), rollbackRadius == 1 ? "{1}" : "{2}"));
                } else {
                    Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_SELECTION, "#worldedit"));
                }
            }
            if (restrictWorld && radius == null && location != null) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_WORLD_ACTION, location.getWorld().getName(), "{1}"));
            }
            if (actionList.contains(4) && actionList.contains(11)) {
                if (actionList.contains(0)) {
                    Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_WORLD_ACTION, "+inventory", "{2}"));
                } else if (actionList.contains(1)) {
                    Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_WORLD_ACTION, "-inventory", "{2}"));
                } else {
                    Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_WORLD_ACTION, "inventory", "{2}"));
                }
            } else if (actionList.contains(4)) {
                if (actionList.contains(0)) {
                    Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_WORLD_ACTION, "-container", "{2}"));
                } else if (actionList.contains(1)) {
                    Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_WORLD_ACTION, "+container", "{2}"));
                } else {
                    Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_WORLD_ACTION, "container", "{2}"));
                }
            } else if (actionList.contains(0) && actionList.contains(1)) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_WORLD_ACTION, "block", "{2}"));
            } else if (actionList.contains(0)) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_WORLD_ACTION, "-block", "{2}"));
            } else if (actionList.contains(1)) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_WORLD_ACTION, "+block", "{2}"));
            } else if (actionList.contains(3)) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_WORLD_ACTION, "kill", "{2}"));
            }
            if (restrictList.size() > 0) {
                StringBuilder restrictTargets = new StringBuilder();
                boolean material = false;
                boolean item = false;
                entity = false;
                int targetCount = 0;
                for (Object object : restrictList) {
                    String targetName = "";
                    if (object instanceof Material) {
                        targetName = ((Material)object).name().toLowerCase(Locale.ROOT);
                        item = !item ? !((Material)object).isBlock() : item;
                        material = true;
                    } else if (object instanceof EntityType) {
                        targetName = ((EntityType)object).name().toLowerCase(Locale.ROOT);
                        entity = true;
                    }
                    if (targetCount == 0) {
                        restrictTargets = restrictTargets.append(targetName);
                    } else {
                        restrictTargets.append(", ").append(targetName);
                    }
                    ++targetCount;
                }
                targetType = "{3}";
                if (material && !item && !entity) {
                    targetType = "{1}";
                } else if (material && item && !entity) {
                    targetType = "{3}";
                } else if (entity && !material) {
                    targetType = "{2}";
                }
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_INCLUDE, new String[]{restrictTargets.toString(), "{1}", targetType, targetCount == 1 ? "{1}" : "{2}"}));
            }
            if (excludeList.size() > 0) {
                StringBuilder excludeTargets = new StringBuilder();
                boolean material = false;
                boolean item2 = false;
                entity = false;
                int excludeCount = 0;
                for (Map.Entry entry : excludeList.entrySet()) {
                    Object excludeTarget = entry.getKey();
                    Boolean excludeTargetInternal = (Boolean)entry.getValue();
                    if (Boolean.TRUE.equals(excludeTargetInternal) || actionList.contains(4) && actionList.contains(11) && (excludeTarget.equals(Material.FIRE) || excludeTarget.equals(Material.WATER) || excludeTarget.equals(Material.FARMLAND))) continue;
                    String targetName = "";
                    if (excludeTarget instanceof Material) {
                        targetName = ((Material)excludeTarget).name().toLowerCase(Locale.ROOT);
                        item2 = !item2 ? !((Material)excludeTarget).isBlock() : item2;
                        material = true;
                    } else if (excludeTarget instanceof EntityType) {
                        targetName = ((EntityType)excludeTarget).name().toLowerCase(Locale.ROOT);
                        entity = true;
                    }
                    if (excludeCount == 0) {
                        excludeTargets = excludeTargets.append(targetName);
                    } else {
                        excludeTargets.append(", ").append(targetName);
                    }
                    ++excludeCount;
                }
                targetType = "{3}";
                if (material && !item2 && !entity) {
                    targetType = "{1}";
                } else if (material && item2 && !entity) {
                    targetType = "{3}";
                } else if (entity && !material) {
                    targetType = "{2}";
                }
                if (excludeCount > 0) {
                    Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_INCLUDE, new String[]{excludeTargets.toString(), "{2}", targetType, excludeCount == 1 ? "{1}" : "{2}"}));
                }
            }
            if (excludeUserList.size() > 0) {
                StringBuilder excludeUsers = new StringBuilder();
                int excludeCount = 0;
                for (String excludeUser : excludeUserList) {
                    if (actionList.contains(4) && actionList.contains(11) && excludeUser.equals("#hopper")) continue;
                    if (excludeCount == 0) {
                        excludeUsers = excludeUsers.append(excludeUser);
                    } else {
                        excludeUsers.append(", ").append(excludeUser);
                    }
                    ++excludeCount;
                }
                if (excludeCount > 0) {
                    Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_EXCLUDED_USERS, excludeUsers.toString(), excludeCount == 1 ? "{1}" : "{2}"));
                }
            }
            StringBuilder modifiedData = new StringBuilder();
            Integer modifyCount = 0;
            if (actionList.contains(5)) {
                modifiedData = modifiedData.append(Phrase.build(Phrase.AMOUNT_ITEM, NumberFormat.getInstance().format(blockCount), blockCount == 1 ? "{1}" : "{2}"));
                Integer item2 = modifyCount;
                modifyCount = modifyCount + 1;
            } else {
                if (itemCount > 0 || actionList.contains(4)) {
                    modifiedData = modifiedData.append(Phrase.build(Phrase.AMOUNT_ITEM, NumberFormat.getInstance().format(itemCount), itemCount == 1 ? "{1}" : "{2}"));
                    Integer item2 = modifyCount;
                    modifyCount = modifyCount + 1;
                }
                if (entityCount > 0) {
                    if (modifyCount > 0) {
                        modifiedData.append(", ");
                    }
                    modifiedData.append(Phrase.build(Phrase.AMOUNT_ENTITY, NumberFormat.getInstance().format(entityCount), entityCount == 1 ? "{1}" : "{2}"));
                    Integer item2 = modifyCount;
                    modifyCount = modifyCount + 1;
                }
                if (blockCount > 0 || !actionList.contains(4) || preview > 0) {
                    if (modifyCount > 0) {
                        modifiedData.append(", ");
                    }
                    modifiedData.append(Phrase.build(Phrase.AMOUNT_BLOCK, NumberFormat.getInstance().format(blockCount), blockCount == 1 ? "{1}" : "{2}"));
                    Integer item2 = modifyCount;
                    modifyCount = modifyCount + 1;
                }
            }
            StringBuilder modifiedDataVerbose = new StringBuilder();
            if (verbose && preview == 0 && !actionList.contains(11)) {
                if (chunkCount > -1 && modifyCount < 3) {
                    if (modifyCount > 0) {
                        modifiedData.append(", ");
                    }
                    modifiedData.append(Phrase.build(Phrase.AMOUNT_CHUNK, NumberFormat.getInstance().format(chunkCount), chunkCount == 1 ? "{1}" : "{2}"));
                    Integer excludeUser = modifyCount;
                    modifyCount = modifyCount + 1;
                } else if (chunkCount > 1) {
                    modifiedDataVerbose.append(Phrase.build(Phrase.AMOUNT_CHUNK, NumberFormat.getInstance().format(chunkCount), chunkCount == 1 ? "{1}" : "{2}"));
                }
            }
            Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_MODIFIED, modifiedData.toString(), preview == 0 ? "{1}" : "{2}"));
            if (modifiedDataVerbose.length() > 0) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_MODIFIED, modifiedDataVerbose.toString(), preview == 0 ? "{1}" : "{2}"));
            }
            if (preview == 0) {
                BigDecimal decimalSeconds = new BigDecimal(seconds).setScale(1, RoundingMode.HALF_EVEN);
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.ROLLBACK_LENGTH, decimalSeconds.stripTrailingZeros().toPlainString(), decimalSeconds.doubleValue() == 1.0 ? "{1}" : "{2}"));
            }
            Chat.sendMessage(user, "-----");
            if (preview > 0) {
                Chat.sendMessage(user, net.coreprotect.utility.Color.DARK_AQUA + "CoreProtect " + net.coreprotect.utility.Color.WHITE + "- " + Phrase.build(Phrase.PLEASE_SELECT, "/co apply", "/co cancel"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static int modifyContainerItems(Material type, Object container, int slot, ItemStack itemstack, int action) {
        int modifiedArmor = -1;
        try {
            ItemStack[] contents = null;
            if (type != null && type.equals((Object)Material.ARMOR_STAND)) {
                EntityEquipment equipment = (EntityEquipment)container;
                if (equipment != null) {
                    if (action == 1) {
                        itemstack.setAmount(1);
                    } else {
                        itemstack.setType(Material.AIR);
                        itemstack.setAmount(0);
                    }
                    if (slot < 4) {
                        contents = equipment.getArmorContents();
                        if (slot >= 0) {
                            contents[slot] = itemstack;
                        }
                        equipment.setArmorContents(contents);
                    } else {
                        ArmorStand armorStand = (ArmorStand)equipment.getHolder();
                        armorStand.setArms(true);
                        switch (slot) {
                            case 4: {
                                equipment.setItemInMainHand(itemstack);
                                break;
                            }
                            case 5: {
                                equipment.setItemInOffHand(itemstack);
                            }
                        }
                    }
                }
            } else if (type != null && type.equals((Object)Material.ITEM_FRAME)) {
                ItemFrame frame = (ItemFrame)container;
                if (frame != null) {
                    if (action == 1) {
                        itemstack.setAmount(1);
                    } else {
                        itemstack.setType(Material.AIR);
                        itemstack.setAmount(0);
                    }
                    frame.setItem(itemstack);
                }
            } else if (type != null && type.equals((Object)Material.JUKEBOX)) {
                Jukebox jukebox = (Jukebox)container;
                if (jukebox != null) {
                    if (action == 1 && Tag.ITEMS_MUSIC_DISCS.isTagged((Keyed)itemstack.getType())) {
                        itemstack.setAmount(1);
                    } else {
                        itemstack.setType(Material.AIR);
                        itemstack.setAmount(0);
                    }
                    jukebox.setRecord(itemstack);
                    jukebox.update();
                }
            } else {
                Inventory inventory = (Inventory)container;
                if (inventory != null) {
                    boolean isPlayerInventory = inventory instanceof PlayerInventory;
                    if (action == 1) {
                        int amount = itemstack.getAmount();
                        itemstack.setAmount(1);
                        for (int count = 0; count < amount; ++count) {
                            PlayerInventory playerInventory;
                            ItemStack offhand;
                            boolean addedItem = false;
                            if (isPlayerInventory) {
                                int setArmor = Util.setPlayerArmor((PlayerInventory)inventory, itemstack);
                                addedItem = setArmor > -1;
                                int n = modifiedArmor = addedItem ? setArmor : modifiedArmor;
                            }
                            if (!addedItem) {
                                if (BukkitAdapter.ADAPTER.isChiseledBookshelf(type)) {
                                    ItemStack[] inventoryContents = inventory.getStorageContents();
                                    int i = 0;
                                    for (ItemStack stack : inventoryContents) {
                                        if (stack == null) {
                                            inventoryContents[i] = itemstack;
                                            addedItem = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (addedItem) {
                                        inventory.setStorageContents(inventoryContents);
                                    } else {
                                        addedItem = inventory.addItem(new ItemStack[]{itemstack}).size() == 0;
                                    }
                                } else {
                                    boolean bl = addedItem = inventory.addItem(new ItemStack[]{itemstack}).size() == 0;
                                }
                            }
                            if (addedItem || !isPlayerInventory || (offhand = (playerInventory = (PlayerInventory)inventory).getItemInOffHand()) != null && offhand.getType() != Material.AIR && (!itemstack.isSimilar(offhand) || offhand.getAmount() >= offhand.getMaxStackSize())) continue;
                            ItemStack setOffhand = itemstack.clone();
                            if (itemstack.isSimilar(offhand)) {
                                setOffhand.setAmount(offhand.getAmount() + 1);
                            }
                            playerInventory.setItemInOffHand(setOffhand);
                        }
                    } else {
                        int removeAmount = itemstack.getAmount();
                        ItemStack removeMatch = itemstack.clone();
                        removeMatch.setAmount(1);
                        ItemStack[] inventoryContents = (ItemStack[])(isPlayerInventory ? inventory.getContents() : inventory.getStorageContents()).clone();
                        for (int i = inventoryContents.length - 1; i >= 0; --i) {
                            if (inventoryContents[i] != null) {
                                int maxAmount;
                                ItemStack itemStack = inventoryContents[i].clone();
                                int currentAmount = maxAmount = itemStack.getAmount();
                                itemStack.setAmount(1);
                                if (itemStack.toString().equals(removeMatch.toString())) {
                                    for (int scan = 0; scan < maxAmount && removeAmount > 0; --removeAmount, ++scan) {
                                        itemStack.setAmount(--currentAmount);
                                    }
                                } else {
                                    itemStack.setAmount(maxAmount);
                                }
                                inventoryContents[i] = itemStack.getAmount() == 0 ? null : itemStack;
                            }
                            if (removeAmount == 0) break;
                        }
                        if (isPlayerInventory) {
                            inventory.setContents(inventoryContents);
                        } else {
                            inventory.setStorageContents(inventoryContents);
                        }
                        for (int count = 0; count < removeAmount; ++count) {
                            inventory.removeItem(new ItemStack[]{removeMatch});
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modifiedArmor;
    }

    public static void sortContainerItems(PlayerInventory inventory, List<Integer> modifiedArmorSlots) {
        try {
            ItemStack[] armorContents = inventory.getArmorContents();
            ItemStack[] storageContents = inventory.getStorageContents();
            block2: for (int armor = 0; armor < armorContents.length; ++armor) {
                ItemStack armorItem = armorContents[armor];
                if (armorItem == null || !modifiedArmorSlots.contains(armor)) continue;
                for (int storage = 0; storage < storageContents.length; ++storage) {
                    ItemStack storageItem = storageContents[storage];
                    if (storageItem != null) continue;
                    storageContents[storage] = armorItem;
                    armorContents[armor] = null;
                    continue block2;
                }
            }
            inventory.setArmorContents(armorContents);
            inventory.setStorageContents(storageContents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void buildFireworkEffect(FireworkEffect.Builder effectBuilder, Material rowType, ItemStack itemstack) {
        try {
            FireworkEffect effect = effectBuilder.build();
            if (rowType == Material.FIREWORK_ROCKET) {
                FireworkMeta meta = (FireworkMeta)itemstack.getItemMeta();
                meta.addEffect(effect);
                itemstack.setItemMeta((ItemMeta)meta);
            } else if (rowType == Material.FIREWORK_STAR) {
                FireworkEffectMeta meta = (FireworkEffectMeta)itemstack.getItemMeta();
                meta.setEffect(effect);
                itemstack.setItemMeta((ItemMeta)meta);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object[] populateItemStack(ItemStack itemstack, Object list) {
        int slot = 0;
        String faceData = "";
        try {
            Material rowType = itemstack.getType();
            List metaList = (List)list;
            if (metaList.size() > 0 && !(metaList.get(0) instanceof List)) {
                if (rowType.name().endsWith("_BANNER")) {
                    BannerMeta meta = (BannerMeta)itemstack.getItemMeta();
                    for (Object value : metaList) {
                        if (!(value instanceof Map)) continue;
                        Pattern pattern = new Pattern((Map)value);
                        meta.addPattern(pattern);
                    }
                    itemstack.setItemMeta((ItemMeta)meta);
                } else if (BlockGroup.SHULKER_BOXES.contains(rowType)) {
                    BlockStateMeta meta = (BlockStateMeta)itemstack.getItemMeta();
                    ShulkerBox shulkerBox = (ShulkerBox)meta.getBlockState();
                    for (Object value : metaList) {
                        ItemStack item = Util.unserializeItemStackLegacy(value);
                        if (item == null) continue;
                        shulkerBox.getInventory().addItem(new ItemStack[]{item});
                    }
                    meta.setBlockState((BlockState)shulkerBox);
                    itemstack.setItemMeta((ItemMeta)meta);
                }
                return new Object[]{slot, faceData, itemstack};
            }
            int itemCount = 0;
            FireworkEffect.Builder effectBuilder = FireworkEffect.builder();
            for (List map : (List)list) {
                LeatherArmorMeta meta;
                Color color;
                Object meta2;
                if (map.size() == 0) {
                    if (itemCount == 3 && (rowType == Material.FIREWORK_ROCKET || rowType == Material.FIREWORK_STAR)) {
                        Rollback.buildFireworkEffect(effectBuilder, rowType, itemstack);
                        itemCount = 0;
                    }
                    ++itemCount;
                    continue;
                }
                Map mapData = (Map)map.get(0);
                if (mapData.get("slot") != null) {
                    slot = (Integer)mapData.get("slot");
                } else if (mapData.get("facing") != null) {
                    faceData = (String)mapData.get("facing");
                } else if (mapData.get("modifiers") != null) {
                    Object entry2;
                    ItemMeta itemMeta = itemstack.getItemMeta();
                    if (itemMeta.hasAttributeModifiers()) {
                        for (Object entry2 : itemMeta.getAttributeModifiers().entries()) {
                            itemMeta.removeAttributeModifier((Attribute)entry2.getKey(), (AttributeModifier)entry2.getValue());
                        }
                    }
                    List modifiers = (List)mapData.get("modifiers");
                    entry2 = modifiers.iterator();
                    while (entry2.hasNext()) {
                        Object item = entry2.next();
                        Map modifiersMap = (Map)item;
                        for (Map.Entry entry3 : modifiersMap.entrySet()) {
                            try {
                                Attribute attribute = (Attribute)entry3.getKey();
                                AttributeModifier modifier = AttributeModifier.deserialize((Map)((Map)entry3.getValue()));
                                itemMeta.addAttributeModifier(attribute, modifier);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                    }
                    itemstack.setItemMeta(itemMeta);
                } else if (itemCount == 0) {
                    meta2 = Util.deserializeItemMeta(itemstack.getItemMeta().getClass(), (Map)map.get(0));
                    itemstack.setItemMeta((ItemMeta)meta2);
                    if (map.size() > 1 && rowType == Material.POTION) {
                        PotionMeta subMeta = (PotionMeta)itemstack.getItemMeta();
                        color = Color.deserialize((Map)((Map)map.get(1)));
                        subMeta.setColor(color);
                        itemstack.setItemMeta((ItemMeta)subMeta);
                    }
                } else if (rowType == Material.LEATHER_HORSE_ARMOR || rowType == Material.LEATHER_HELMET || rowType == Material.LEATHER_CHESTPLATE || rowType == Material.LEATHER_LEGGINGS || rowType == Material.LEATHER_BOOTS) {
                    for (Map colorData : map) {
                        meta = (LeatherArmorMeta)itemstack.getItemMeta();
                        Color color2 = Color.deserialize((Map)colorData);
                        meta.setColor(color2);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (rowType == Material.POTION) {
                    for (Map potionData : map) {
                        meta = (PotionMeta)itemstack.getItemMeta();
                        PotionEffect effect = new PotionEffect(potionData);
                        meta.addCustomEffect(effect, true);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (rowType.name().endsWith("_BANNER")) {
                    for (Object patternData : map) {
                        meta = (BannerMeta)itemstack.getItemMeta();
                        Pattern pattern = new Pattern((Map)patternData);
                        meta.addPattern(pattern);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (rowType == Material.CROSSBOW) {
                    Object patternData;
                    meta2 = (CrossbowMeta)itemstack.getItemMeta();
                    patternData = map.iterator();
                    while (patternData.hasNext()) {
                        Map itemData = (Map)patternData.next();
                        ItemStack crossbowItem = Util.unserializeItemStack(itemData);
                        if (crossbowItem == null) continue;
                        meta2.addChargedProjectile(crossbowItem);
                    }
                    itemstack.setItemMeta((ItemMeta)meta2);
                } else if (rowType == Material.MAP || rowType == Material.FILLED_MAP) {
                    for (Map colorData : map) {
                        meta = (MapMeta)itemstack.getItemMeta();
                        Color color3 = Color.deserialize((Map)colorData);
                        meta.setColor(color3);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (rowType == Material.FIREWORK_ROCKET || rowType == Material.FIREWORK_STAR) {
                    if (itemCount == 1) {
                        effectBuilder = FireworkEffect.builder();
                        for (Map fireworkData : map) {
                            FireworkEffect.Type type = fireworkData.getOrDefault("type", FireworkEffect.Type.BALL);
                            boolean hasFlicker = (Boolean)fireworkData.get("flicker");
                            boolean hasTrail = (Boolean)fireworkData.get("trail");
                            effectBuilder.with(type);
                            effectBuilder.flicker(hasFlicker);
                            effectBuilder.trail(hasTrail);
                        }
                    } else if (itemCount == 2) {
                        for (Map colorData : map) {
                            color = Color.deserialize((Map)colorData);
                            effectBuilder.withColor(color);
                        }
                    } else if (itemCount == 3) {
                        for (Map colorData : map) {
                            color = Color.deserialize((Map)colorData);
                            effectBuilder.withFade(color);
                        }
                        Rollback.buildFireworkEffect(effectBuilder, rowType, itemstack);
                        itemCount = 0;
                    }
                } else if (rowType == Material.SUSPICIOUS_STEW) {
                    for (Map suspiciousStewData : map) {
                        meta = (SuspiciousStewMeta)itemstack.getItemMeta();
                        PotionEffect effect = new PotionEffect(suspiciousStewData);
                        meta.addCustomEffect(effect, true);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else {
                    BukkitAdapter.ADAPTER.setItemMeta(rowType, itemstack, map);
                }
                ++itemCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Object[]{slot, faceData, itemstack};
    }

    public static Object[] populateItemStack(ItemStack itemstack, byte[] metadata) {
        if (metadata != null) {
            try {
                ByteArrayInputStream metaByteStream = new ByteArrayInputStream(metadata);
                BukkitObjectInputStream metaObjectStream = new BukkitObjectInputStream((InputStream)metaByteStream);
                Object metaList = metaObjectStream.readObject();
                metaObjectStream.close();
                metaByteStream.close();
                return Rollback.populateItemStack(itemstack, metaList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Object[]{0, "", itemstack};
    }
}

