/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_12_2to1_13;

import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.rewriters.TranslatableRewriter;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.data.BackwardsMappings;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.data.PaintingMapping;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.packets.BlockItemPackets1_13;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.packets.EntityPackets1_13;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.packets.PlayerPacket1_13;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.packets.SoundPackets1_13;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.providers.BackwardsBlockEntityProvider;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.storage.BackwardsBlockStorage;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.storage.PlayerPositionStorage1_13;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.storage.TabCompleteStorage;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.minecraft.ClientWorld;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_13;
import com.viaversion.viaversion.api.platform.providers.Provider;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.data.entity.EntityTrackerBase;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.gson.JsonParser;
import com.viaversion.viaversion.libs.kyori.adventure.text.Component;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.viaversion.viaversion.protocols.protocol1_12_1to1_12.ClientboundPackets1_12_1;
import com.viaversion.viaversion.protocols.protocol1_12_1to1_12.ServerboundPackets1_12_1;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ChatRewriter;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ClientboundPackets1_13;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.Protocol1_13To1_12_2;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ServerboundPackets1_13;
import com.viaversion.viaversion.rewriter.ComponentRewriter;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Protocol1_12_2To1_13
extends BackwardsProtocol<ClientboundPackets1_13, ClientboundPackets1_12_1, ServerboundPackets1_13, ServerboundPackets1_12_1> {
    public static final BackwardsMappings MAPPINGS = new BackwardsMappings();
    private final EntityPackets1_13 entityRewriter = new EntityPackets1_13(this);
    private final BlockItemPackets1_13 blockItemPackets = new BlockItemPackets1_13(this);
    private final TranslatableRewriter<ClientboundPackets1_13> translatableRewriter = new TranslatableRewriter<ClientboundPackets1_13>((BackwardsProtocol)this, ComponentRewriter.ReadType.JSON){

        @Override
        protected void handleTranslate(JsonObject root, String translate) {
            String mappedKey = this.mappedTranslationKey(translate);
            if (mappedKey != null || (mappedKey = Protocol1_12_2To1_13.this.getMappingData().getTranslateMappings().get(translate)) != null) {
                root.addProperty("translate", mappedKey);
            }
        }
    };
    private final TranslatableRewriter<ClientboundPackets1_13> translatableToLegacyRewriter = new TranslatableRewriter<ClientboundPackets1_13>((BackwardsProtocol)this, ComponentRewriter.ReadType.JSON){

        @Override
        protected void handleTranslate(JsonObject root, String translate) {
            String mappedKey = this.mappedTranslationKey(translate);
            if (mappedKey != null || (mappedKey = Protocol1_12_2To1_13.this.getMappingData().getTranslateMappings().get(translate)) != null) {
                root.addProperty("translate", Protocol1_13To1_12_2.MAPPINGS.getMojangTranslation().getOrDefault(mappedKey, mappedKey));
            }
        }
    };

    public Protocol1_12_2To1_13() {
        super(ClientboundPackets1_13.class, ClientboundPackets1_12_1.class, ServerboundPackets1_13.class, ServerboundPackets1_12_1.class);
    }

    @Override
    protected void registerPackets() {
        this.executeAsyncAfterLoaded(Protocol1_13To1_12_2.class, () -> {
            MAPPINGS.load();
            PaintingMapping.init();
            Via.getManager().getProviders().register(BackwardsBlockEntityProvider.class, (Provider)new BackwardsBlockEntityProvider());
        });
        this.translatableRewriter.registerPing();
        this.translatableRewriter.registerBossBar((ClientboundPacketType)ClientboundPackets1_13.BOSSBAR);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_13.CHAT_MESSAGE);
        this.translatableRewriter.registerLegacyOpenWindow((ClientboundPacketType)ClientboundPackets1_13.OPEN_WINDOW);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_13.DISCONNECT);
        this.translatableRewriter.registerCombatEvent((ClientboundPacketType)ClientboundPackets1_13.COMBAT_EVENT);
        this.translatableRewriter.registerTitle((ClientboundPacketType)ClientboundPackets1_13.TITLE);
        this.translatableRewriter.registerTabList((ClientboundPacketType)ClientboundPackets1_13.TAB_LIST);
        this.blockItemPackets.register();
        this.entityRewriter.register();
        new PlayerPacket1_13(this).register();
        new SoundPackets1_13(this).register();
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_13.NBT_QUERY);
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_13.CRAFT_RECIPE_RESPONSE);
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_13.UNLOCK_RECIPES);
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_13.ADVANCEMENTS);
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_13.DECLARE_RECIPES);
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_13.TAGS);
        this.cancelServerbound((ServerboundPacketType)ServerboundPackets1_12_1.CRAFT_RECIPE_REQUEST);
        this.cancelServerbound((ServerboundPacketType)ServerboundPackets1_12_1.RECIPE_BOOK_DATA);
    }

    public void init(UserConnection user) {
        if (!user.has(ClientWorld.class)) {
            user.put((StorableObject)new ClientWorld());
        }
        user.addEntityTracker(((Object)((Object)this)).getClass(), (EntityTracker)new EntityTrackerBase(user, (EntityType)EntityTypes1_13.EntityType.PLAYER));
        user.put((StorableObject)new BackwardsBlockStorage());
        user.put((StorableObject)new TabCompleteStorage());
        if (ViaBackwards.getConfig().isFix1_13FacePlayer() && !user.has(PlayerPositionStorage1_13.class)) {
            user.put((StorableObject)new PlayerPositionStorage1_13());
        }
    }

    @Override
    public BackwardsMappings getMappingData() {
        return MAPPINGS;
    }

    public EntityPackets1_13 getEntityRewriter() {
        return this.entityRewriter;
    }

    public BlockItemPackets1_13 getItemRewriter() {
        return this.blockItemPackets;
    }

    public TranslatableRewriter<ClientboundPackets1_13> translatableRewriter() {
        return this.translatableRewriter;
    }

    public String jsonToLegacy(String value) {
        if (value.isEmpty()) {
            return "";
        }
        try {
            return this.jsonToLegacy(JsonParser.parseString((String)value));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String jsonToLegacy(@Nullable JsonElement value) {
        if (value == null || value.isJsonNull()) {
            return "";
        }
        this.translatableToLegacyRewriter.processText(value);
        try {
            Component component = ChatRewriter.HOVER_GSON_SERIALIZER.deserializeFromTree(value);
            return LegacyComponentSerializer.legacySection().serialize(component);
        }
        catch (Exception e) {
            ViaBackwards.getPlatform().getLogger().warning("Error converting json text to legacy: " + value);
            e.printStackTrace();
            return "";
        }
    }
}

